/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.util.Objects;
import java.util.function.BiFunction;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.builder.ExecutableBuilder;
import org.kie.api.runtime.builder.KieSessionFluent;
import org.kie.api.runtime.conf.ClockTypeOption;

public class ScenarioExecutableBuilder {
    public static String DEFAULT_APPLICATION = "defaultApplication";
    private final KieSessionFluent kieSessionFluent;
    private final ExecutableBuilder executableBuilder = ExecutableBuilder.create();
    private static BiFunction<String, KieContainer, KieContainer> forcePseudoClock = (sessionName, kc) -> {
        KieSessionModel kieSessionModel = kc.getKieSessionModel(sessionName);
        kieSessionModel.setClockType(ClockTypeOption.get((String)"pseudo"));
        return kc;
    };

    private ScenarioExecutableBuilder(KieContainer kieContainer, String name) {
        this.kieSessionFluent = ((ExecutableBuilder)this.executableBuilder.newApplicationContext(name)).setKieContainer(kieContainer).newSessionCustomized(null, forcePseudoClock);
    }

    private ScenarioExecutableBuilder(KieContainer kieContainer) {
        this(kieContainer, DEFAULT_APPLICATION);
    }

    public static ScenarioExecutableBuilder createBuilder(KieContainer kieContainer, String name) {
        return new ScenarioExecutableBuilder(kieContainer, name);
    }

    public static ScenarioExecutableBuilder createBuilder(KieContainer kieContainer) {
        return new ScenarioExecutableBuilder(kieContainer);
    }

    public void insert(Object element) {
        this.kieSessionFluent.insert(element);
    }

    public RequestContext run() {
        Objects.requireNonNull(this.executableBuilder, "Executable builder is null, please invoke create(KieContainer, )");
        ((ExecutableBuilder)((KieSessionFluent)this.kieSessionFluent.fireAllRules()).dispose()).end();
        return (RequestContext)ExecutableRunner.create().execute(this.executableBuilder.getExecutable());
    }
}

