/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioAssumptionViolatedException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioExecutableBuilder;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioInput;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioOutput;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ScenarioBeanUtil;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;

public class ScenarioRunnerHelper {
    private ScenarioRunnerHelper() {
    }

    public static List<ScenarioInput> extractGivenValues(SimulationDescriptor simulationDescriptor, List<FactMappingValue> factMappingValues, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator) {
        ArrayList<ScenarioInput> scenarioInput = new ArrayList<ScenarioInput>();
        Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = ScenarioRunnerHelper.groupByFactIdentifierAndFilter(factMappingValues, FactMappingType.GIVEN);
        for (Map.Entry<FactIdentifier, List<FactMappingValue>> entry : groupByFactIdentifier.entrySet()) {
            FactIdentifier factIdentifier = entry.getKey();
            Map<List<String>, Object> paramsForBean = ScenarioRunnerHelper.getParamsForBean(simulationDescriptor, factIdentifier, entry.getValue(), classLoader, expressionEvaluator);
            Object bean = ScenarioBeanUtil.fillBean(factIdentifier.getClassName(), paramsForBean, classLoader);
            scenarioInput.add(new ScenarioInput(factIdentifier, bean));
        }
        return scenarioInput;
    }

    public static List<ScenarioOutput> extractExpectedValues(List<FactMappingValue> factMappingValues) {
        ArrayList<ScenarioOutput> scenarioOutput = new ArrayList<ScenarioOutput>();
        Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = ScenarioRunnerHelper.groupByFactIdentifierAndFilter(factMappingValues, FactMappingType.EXPECTED);
        for (Map.Entry<FactIdentifier, List<FactMappingValue>> entry : groupByFactIdentifier.entrySet()) {
            FactIdentifier factIdentifier = entry.getKey();
            scenarioOutput.add(new ScenarioOutput(factIdentifier, entry.getValue()));
        }
        return scenarioOutput;
    }

    public static RequestContext executeScenario(KieContainer kieContainer, List<ScenarioInput> given) {
        ScenarioExecutableBuilder scenarioExecutableBuilder = ScenarioExecutableBuilder.createBuilder(kieContainer);
        given.stream().map(ScenarioInput::getValue).forEach(scenarioExecutableBuilder::insert);
        return scenarioExecutableBuilder.run();
    }

    public static List<ScenarioResult> verifyConditions(SimulationDescriptor simulationDescriptor, List<ScenarioInput> inputData, List<ScenarioOutput> outputData, ExpressionEvaluator expressionEvaluator) {
        ArrayList<ScenarioResult> scenarioResult = new ArrayList<ScenarioResult>();
        List inputIds = inputData.stream().map(ScenarioInput::getFactIdentifier).collect(Collectors.toList());
        List outputNotValidIds = outputData.stream().map(ScenarioOutput::getFactIdentifier).filter(output -> !inputIds.contains(output)).map(FactIdentifier::getName).collect(Collectors.toList());
        if (outputNotValidIds.size() > 0) {
            throw new ScenarioException("Some expected conditions are not linked to any given facts: " + String.join((CharSequence)", ", outputNotValidIds));
        }
        for (ScenarioInput input : inputData) {
            FactIdentifier factIdentifier = input.getFactIdentifier();
            List<ScenarioOutput> assertionOnFact = outputData.stream().filter(elem -> Objects.equals(elem.getFactIdentifier(), factIdentifier)).collect(Collectors.toList());
            if (assertionOnFact.size() < 1) continue;
            scenarioResult.addAll(ScenarioRunnerHelper.getScenarioResults(simulationDescriptor, assertionOnFact, input, expressionEvaluator));
        }
        return scenarioResult;
    }

    public static List<ScenarioResult> getScenarioResults(SimulationDescriptor simulationDescriptor, List<ScenarioOutput> scenarioOutputsPerFact, ScenarioInput input, ExpressionEvaluator expressionEvaluator) {
        FactIdentifier factIdentifier = input.getFactIdentifier();
        Object factInstance = input.getValue();
        ArrayList<ScenarioResult> scenarioResults = new ArrayList<ScenarioResult>();
        for (ScenarioOutput scenarioOutput : scenarioOutputsPerFact) {
            List<FactMappingValue> expectedResults = scenarioOutput.getExpectedResult();
            for (FactMappingValue expectedResult : expectedResults) {
                ExpressionIdentifier expressionIdentifier = expectedResult.getExpressionIdentifier();
                FactMapping factMapping = (FactMapping)simulationDescriptor.getFactMapping(factIdentifier, expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
                List<String> pathToValue = factMapping.getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
                Object resultValue = ScenarioBeanUtil.navigateToObject(factInstance, pathToValue, false);
                Boolean conditionResult = expressionEvaluator.evaluate(expectedResult.getRawValue(), resultValue);
                scenarioResults.add(new ScenarioResult(factIdentifier, expectedResult, resultValue, conditionResult));
            }
        }
        return scenarioResults;
    }

    public static void validateAssertion(List<ScenarioResult> scenarioResults, Scenario scenario, EachTestNotifier singleNotifier) {
        boolean scenarioFailed = false;
        for (ScenarioResult scenarioResult : scenarioResults) {
            if (scenarioResult.getResult() != null && scenarioResult.getResult().booleanValue()) continue;
            singleNotifier.addFailedAssumption((AssumptionViolatedException)new ScenarioAssumptionViolatedException(scenario, scenarioResult, "Scenario '" + scenario.getDescription() + "' has wrong assertion"));
            scenarioFailed = true;
        }
        if (scenarioFailed) {
            throw new ScenarioException("Scenario '" + scenario.getDescription() + "' failed");
        }
    }

    public static Map<List<String>, Object> getParamsForBean(SimulationDescriptor simulationDescriptor, FactIdentifier factIdentifier, List<FactMappingValue> factMappingValues, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator) {
        HashMap<List<String>, Object> paramsForBean = new HashMap<List<String>, Object>();
        for (FactMappingValue factMappingValue : factMappingValues) {
            ExpressionIdentifier expressionIdentifier = factMappingValue.getExpressionIdentifier();
            FactMapping factMapping = (FactMapping)simulationDescriptor.getFactMapping(factIdentifier, expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
            List pathToField = factMapping.getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            Object value = expressionEvaluator.getValueForGiven(factMapping.getClassName(), factMappingValue.getRawValue(), classLoader);
            paramsForBean.put(pathToField, value);
        }
        return paramsForBean;
    }

    public static Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifierAndFilter(List<FactMappingValue> factMappingValues, FactMappingType type) {
        HashMap<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = new HashMap<FactIdentifier, List<FactMappingValue>>();
        for (FactMappingValue factMappingValue : factMappingValues) {
            FactIdentifier factIdentifier = factMappingValue.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = factMappingValue.getExpressionIdentifier();
            if (expressionIdentifier == null) {
                throw new IllegalArgumentException("ExpressionIdentifier malformed");
            }
            if (!Objects.equals(expressionIdentifier.getType(), type)) continue;
            groupByFactIdentifier.computeIfAbsent(factIdentifier, key -> new ArrayList()).add(factMappingValue);
        }
        return groupByFactIdentifier;
    }
}

