/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import javax.enterprise.event.Event;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioRunnerServiceImpl;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.service.BuildInfo;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioRunnerImplServiceImplTest {
    @Mock
    private EventSourceMock<TestResultMessage> defaultTestResultMessageEvent;
    @Mock
    private Runner runnerMock;
    @Mock
    private KieModuleService moduleService;
    @Mock
    private BuildInfoService buildInfoService;
    @Mock
    private BuildInfo buildInfo;
    @Mock
    private KieContainer kieContainer;
    @Mock
    private ModuleClassLoaderHelper classLoaderHelper;
    @InjectMocks
    private ScenarioRunnerServiceImpl scenarioRunnerService = new ScenarioRunnerServiceImpl();

    @Before
    public void setup() {
        Mockito.when((Object)this.classLoaderHelper.getModuleClassLoader((KieModule)Matchers.any())).thenReturn((Object)ClassLoader.getSystemClassLoader());
    }

    @Test
    public void runAllTests() throws Exception {
        this.scenarioRunnerService.runAllTests("test", (Path)Mockito.mock(Path.class));
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEvent)).fire(Matchers.any());
    }

    @Test
    public void runTest() throws Exception {
        Mockito.when((Object)this.buildInfoService.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfo);
        Mockito.when((Object)this.buildInfo.getKieContainer()).thenReturn((Object)this.kieContainer);
        ScenarioSimulationModel scenarioSimulationModel = (ScenarioSimulationModel)Mockito.mock(ScenarioSimulationModel.class);
        Mockito.when((Object)scenarioSimulationModel.getSimulation()).thenReturn(Mockito.mock(Simulation.class));
        this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), scenarioSimulationModel);
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEvent)).fire(Matchers.any());
    }

    @Test
    public void runAllTestsSpecifiedEvent() throws Exception {
        EventSourceMock customTestResultEvent = (EventSourceMock)Mockito.mock(EventSourceMock.class);
        this.scenarioRunnerService.setRunnerSupplier((kieContainer, simulation) -> this.runnerMock);
        this.scenarioRunnerService.runAllTests("test", (Path)Mockito.mock(Path.class), (Event)customTestResultEvent);
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEvent, (VerificationMode)Mockito.never())).fire(Matchers.any());
        ((EventSourceMock)Mockito.verify((Object)customTestResultEvent)).fire(Matchers.any());
    }
}

