/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.Collections;
import java.util.HashSet;
import javax.inject.Named;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioRunnerServiceImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationServiceImpl;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.backend.service.KieServiceOverviewLoader;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.backend.version.PathResolver;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioSimulationServiceImplTest {
    @Mock
    @Named(value="ioStrategy")
    private IOService ioService;
    @Mock
    private CommentedOptionFactory commentedOptionFactory;
    @Mock
    private SaveAndRenameServiceImpl<ScenarioSimulationModel, Metadata> saveAndRenameService;
    @Mock
    private PathResolver pathResolver;
    @Mock
    protected KieServiceOverviewLoader overviewLoader;
    @Mock
    protected MetadataServerSideService metadataService;
    @Mock
    private DeleteService deleteService;
    @Mock
    private RenameService renameService;
    @Mock
    private CopyService copyService;
    @Mock
    private User user;
    @Mock
    private ScenarioRunnerServiceImpl scenarioRunnerService;
    @Mock
    private POMService pomService;
    @Mock
    private Path activatorPath;
    @Mock
    private KieModuleService kieModuleService;
    @Mock
    private KieModule module;
    @Mock
    private POM projectPom;
    @Mock
    private GAV gav;
    @Mock
    private Dependencies dependencies;
    @Mock
    private Package mockedPackage;
    @InjectMocks
    private ScenarioSimulationServiceImpl service = new ScenarioSimulationServiceImpl((SessionInfo)Mockito.mock(SafeSessionInfo.class));
    private org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"contextpath", (String)"file:///contextpath");

    @Before
    public void setuo() {
        HashSet<Package> packages = new HashSet<Package>();
        packages.add(new Package(this.path, this.path, this.path, this.path, this.path, "Test", "", ""));
        Mockito.when((Object)this.kieModuleService.resolveModule((org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)this.module);
        Mockito.when((Object)this.kieModuleService.resolvePackages((Module)Matchers.any(KieModule.class))).thenReturn(packages);
        Mockito.when((Object)this.ioService.exists(this.activatorPath)).thenReturn((Object)false);
        Mockito.when((Object)this.kieModuleService.resolveModule((org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)this.module);
        Mockito.when((Object)this.module.getPom()).thenReturn((Object)this.projectPom);
        Mockito.when((Object)this.projectPom.getGav()).thenReturn((Object)this.gav);
        Mockito.when((Object)this.gav.getGroupId()).thenReturn((Object)"Test");
        Mockito.when((Object)this.projectPom.getDependencies()).thenReturn((Object)this.dependencies);
        Mockito.when((Object)this.ioService.exists((Path)Matchers.any(Path.class))).thenReturn((Object)false);
        Mockito.when((Object)this.mockedPackage.getPackageTestSrcPath()).thenReturn((Object)this.path);
    }

    @Test
    public void init() throws Exception {
        this.service.init();
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).init((SupportsSaveAndRename)this.service);
    }

    @Test
    public void delete() throws Exception {
        this.service.delete(this.path, "Removing this");
        ((DeleteService)Mockito.verify((Object)this.deleteService)).delete(this.path, "Removing this");
    }

    @Test
    public void rename() throws Exception {
        this.service.rename(this.path, "newName.scesim", "comment");
        ((RenameService)Mockito.verify((Object)this.renameService)).rename(this.path, "newName.scesim", "comment");
    }

    @Test
    public void copy() throws Exception {
        this.service.copy(this.path, "newName.scesim", "comment");
        ((CopyService)Mockito.verify((Object)this.copyService)).copy(this.path, "newName.scesim", "comment");
    }

    @Test
    public void copyToDirectory() throws Exception {
        org.uberfire.backend.vfs.Path folder = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        this.service.copy(this.path, "newName.scesim", folder, "comment");
        ((CopyService)Mockito.verify((Object)this.copyService)).copy(this.path, "newName.scesim", folder, "comment");
    }

    @Test
    public void saveAndRename() throws Exception {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        this.service.saveAndRename(this.path, "newName.scesim", metadata, model, "comment");
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameService)).saveAndRename(this.path, "newName.scesim", (Object)metadata, (Object)model, "comment");
    }

    @Test
    public void save() throws Exception {
        org.uberfire.backend.vfs.Path returnPath = this.service.save(this.path, new ScenarioSimulationModel(), new Metadata(), "Commit comment");
        Assert.assertNotNull((Object)returnPath);
        ((IOService)Mockito.verify((Object)this.ioService)).write((Path)Matchers.any(Path.class), Matchers.anyString(), Matchers.anyMap(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
    }

    @Test
    public void create() throws Exception {
        ((IOService)Mockito.doReturn((Object)false).when((Object)this.ioService)).exists((Path)Matchers.any());
        org.uberfire.backend.vfs.Path returnPath = this.service.create(this.path, "test.scesim", new ScenarioSimulationModel(), "Commit comment");
        Assert.assertNotNull((Object)returnPath);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).write((Path)Matchers.any(Path.class), Matchers.anyString(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createFileExists() throws Exception {
        ((IOService)Mockito.doReturn((Object)true).when((Object)this.ioService)).exists((Path)Matchers.any());
        this.service.create(this.path, "test.scesim", new ScenarioSimulationModel(), "Commit comment");
    }

    @Test
    public void runScenario() throws Exception {
        ((User)Mockito.doReturn((Object)"test user").when((Object)this.user)).getIdentifier();
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        this.service.runScenario(path, model);
        ((ScenarioRunnerServiceImpl)Mockito.verify((Object)this.scenarioRunnerService)).runTest("test user", path, model);
    }

    @Test
    public void createActivatorIfNotExistTest() {
        this.service.createActivatorIfNotExist(this.path);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)1))).write((Path)Matchers.any(Path.class), Matchers.anyString(), new OpenOption[]{(OpenOption)Matchers.any(OpenOption.class)});
        Mockito.when((Object)this.kieModuleService.resolvePackages((Module)Matchers.any(KieModule.class))).thenReturn(Collections.emptySet());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.service.createActivatorIfNotExist(this.path)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Impossible to retrieve package information from path: file:///contextpath");
    }

    @Test
    public void ensureDependenciesTest() {
        this.service.ensureDependencies(this.module);
        int expectedCalls = this.service.getDependecies(null).size();
        ((POMService)Mockito.verify((Object)this.pomService, (VerificationMode)Mockito.times((int)expectedCalls))).save((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class), Matchers.any(POM.class), (Metadata)Matchers.any(Metadata.class), Matchers.anyString());
    }

    @Test
    public void editPomIfNecessaryTest() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        POM pom = new POM();
        GAV gav = new GAV(groupId, artifactId, version);
        Dependencies dependencies = new Dependencies();
        this.service.editPomIfNecessary(this.path, pom, dependencies, gav);
        ((POMService)Mockito.verify((Object)this.pomService, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class), Matchers.any(POM.class), (Metadata)Matchers.any(Metadata.class), Matchers.anyString());
        Mockito.reset((Object[])new POMService[]{this.pomService});
        this.service.editPomIfNecessary(this.path, pom, dependencies, gav);
        ((POMService)Mockito.verify((Object)this.pomService, (VerificationMode)Mockito.times((int)0))).save((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class), Matchers.any(POM.class), (Metadata)Matchers.any(Metadata.class), Matchers.anyString());
    }

    @Test
    public void getActivatorPathTest() {
        Assert.assertTrue((boolean)this.service.getActivatorPath(this.mockedPackage).endsWith("ScenarioJunitActivatorTest.java"));
    }
}

