/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.util.List;
import java.util.stream.Stream;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationXMLPersistence;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioJunitActivator;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ResourceHelper;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.kie.api.runtime.KieContainer;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioJunitActivatorTest {
    @Mock
    private ScenarioSimulationXMLPersistence xmlReader;
    @Mock
    private KieContainer kieContainer;
    @Mock
    private Runner runner;
    @Mock
    private Simulation simulation;
    @Mock
    private ScenarioSimulationModel scenarioSimulationModel;
    @Mock
    private RunNotifier runNotifier;

    @Before
    public void setup() {
        Mockito.when((Object)this.xmlReader.unmarshal((String)Matchers.any())).thenReturn((Object)this.scenarioSimulationModel);
        Mockito.when((Object)this.scenarioSimulationModel.getSimulation()).thenReturn((Object)this.simulation);
    }

    @Test
    public void getChildrenTest() throws InitializationError {
        List children = this.getScenarioJunitActivator().getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
    }

    @Test
    public void runChildTest() throws InitializationError {
        this.getScenarioJunitActivator().runChild(this.simulation, this.runNotifier);
        ((Runner)Mockito.verify((Object)this.runner, (VerificationMode)Mockito.times((int)1))).run(this.runNotifier);
    }

    private ScenarioJunitActivator getScenarioJunitActivator() throws InitializationError {
        return new ScenarioJunitActivator(ScenarioJunitActivator.class){

            ScenarioSimulationXMLPersistence getXmlReader() {
                return ScenarioJunitActivatorTest.this.xmlReader;
            }

            Stream<String> getResources() {
                return ResourceHelper.getResourcesByExtension((String)"txt");
            }

            KieContainer getKieContainer() {
                return ScenarioJunitActivatorTest.this.kieContainer;
            }

            Runner newRunner(KieContainer kieContainer, Simulation simulation) {
                return ScenarioJunitActivatorTest.this.runner;
            }
        };
    }
}

