/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ScenarioBeanUtil;

public enum BaseExpressionOperator {
    LIST_OF_CONDITION(0, new String[]{";"}){

        @Override
        protected Optional<String> match(String value) {
            return this.symbols.stream().filter(value::contains).findFirst();
        }

        @Override
        protected boolean eval(Object raw, Object resultValue, ClassLoader classLoader) {
            if (!(raw instanceof String) || !this.match((String)raw).isPresent()) {
                return false;
            }
            String rawValue = (String)raw;
            List results = Arrays.stream(rawValue.split((String)this.symbols.get(0))).map(elem -> 1.findOperator(elem.trim()).eval(elem.trim(), resultValue, classLoader)).collect(Collectors.toList());
            return results.stream().allMatch(a -> a);
        }
    }
    ,
    LIST_OF_VALUES(1, new String[]{"["}){

        @Override
        public boolean eval(Object rawValue, Object resultValue, ClassLoader classLoader) {
            List results = this.getValues(rawValue).stream().map(e -> EQUALS.eval(e, resultValue, classLoader)).collect(Collectors.toList());
            return results.stream().anyMatch(a -> a);
        }

        private List<String> getValues(Object raw) {
            if (!(raw instanceof String) || !this.match((String)raw).isPresent()) {
                return Collections.emptyList();
            }
            String rawValue = ((String)raw).trim();
            if (!rawValue.endsWith("]")) {
                throw new IllegalArgumentException("Malformed expression: " + rawValue);
            }
            return Stream.of(rawValue.substring(1, ((String)raw).length() - 1).split(",")).map(String::trim).collect(Collectors.toList());
        }
    }
    ,
    EQUALS(2, new String[]{"="}){

        @Override
        protected Object getValueForGiven(String className, String value, ClassLoader classLoader) {
            String returnValue = this.removeOperator(value);
            returnValue = "".equals(returnValue) && !this.match(value).isPresent() ? null : returnValue;
            return ScenarioBeanUtil.convertValue(className, returnValue, classLoader);
        }

        @Override
        public boolean eval(Object rawValue, Object resultValue, ClassLoader classLoader) {
            Object parsedResults = rawValue;
            if (parsedResults instanceof String) {
                parsedResults = this.getValueForGiven(resultValue.getClass().getCanonicalName(), (String)rawValue, classLoader);
            }
            if (parsedResults == null) {
                return resultValue == null;
            }
            if (BaseExpressionOperator.areComparable(resultValue, parsedResults)) {
                return ((Comparable)resultValue).compareTo(parsedResults) == 0;
            }
            return Objects.equals(resultValue, parsedResults);
        }
    }
    ,
    NOT_EQUALS(3, new String[]{"!", "!=", "<>"}){

        @Override
        public boolean eval(Object rawValue, Object resultValue, ClassLoader classLoader) {
            Object valueToTest = rawValue;
            BaseExpressionOperator operator = EQUALS;
            if (valueToTest instanceof String) {
                String rawStringValue = (String)valueToTest;
                valueToTest = this.removeOperator(rawStringValue);
                operator = 4.findOperator((String)valueToTest);
            }
            return !operator.eval(valueToTest, resultValue, classLoader);
        }
    }
    ,
    RANGE(4, new String[]{"<", ">", "<=", ">="}){

        @Override
        public boolean eval(Object raw, Object resultValue, ClassLoader classLoader) {
            if (!(raw instanceof String) || !this.match((String)raw).isPresent()) {
                return false;
            }
            String rawValue = (String)raw;
            String operator = this.match(rawValue).get();
            String cleanValue = this.removeOperator(rawValue);
            Object stepValue = ScenarioBeanUtil.convertValue(resultValue.getClass().getCanonicalName(), cleanValue, classLoader);
            if (!BaseExpressionOperator.areComparable(stepValue, resultValue)) {
                return false;
            }
            Comparable a = (Comparable)resultValue;
            Comparable b = (Comparable)stepValue;
            switch (operator) {
                case "<": {
                    return a.compareTo(b) < 0;
                }
                case ">": {
                    return a.compareTo(b) > 0;
                }
                case "<=": {
                    return a.compareTo(b) <= 0;
                }
                case ">=": {
                    return a.compareTo(b) >= 0;
                }
            }
            throw new IllegalStateException("This should not happen " + operator);
        }
    };

    final List<String> symbols;
    final int precedence;

    private BaseExpressionOperator(int precedence, String ... symbols) {
        this.precedence = precedence;
        this.symbols = Arrays.asList(symbols);
        this.symbols.sort((a, b) -> Integer.compare(a.length(), b.length()) * -1);
    }

    public static BaseExpressionOperator findOperator(String rawValue) {
        String value = rawValue.trim();
        List sortedOperators = Arrays.stream(BaseExpressionOperator.values()).sorted(Comparator.comparingInt(BaseExpressionOperator::getPrecedence)).collect(Collectors.toList());
        for (BaseExpressionOperator factMappingValueOperator : sortedOperators) {
            if (!factMappingValueOperator.match(value).isPresent()) continue;
            return factMappingValueOperator;
        }
        return EQUALS;
    }

    protected abstract boolean eval(Object var1, Object var2, ClassLoader var3);

    protected Object getValueForGiven(String className, String value, ClassLoader classLoader) {
        throw new IllegalStateException("This operator cannot be used into a Given clause");
    }

    protected Optional<String> match(String value) {
        value = value.trim();
        return this.symbols.stream().filter(value::startsWith).findFirst();
    }

    protected String removeOperator(String fullString) {
        Optional<String> operatorSymbol = this.match(fullString);
        String value = fullString;
        if (operatorSymbol.isPresent()) {
            String symbolToRemove = operatorSymbol.get();
            int index = value.indexOf(symbolToRemove);
            value = value.substring(index + symbolToRemove.length()).trim();
        }
        return value.trim();
    }

    private static boolean areComparable(Object a, Object b) {
        return a instanceof Comparable && b instanceof Comparable;
    }

    private int getPrecedence() {
        return this.precedence;
    }
}

