/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.fluent.ScenarioExecutableBuilder;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioAssumptionViolatedException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioInput;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioOutput;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.SingleFactValueResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ScenarioBeanUtil;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.runners.model.EachTestNotifier;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;

public class ScenarioRunnerHelper {
    private ScenarioRunnerHelper() {
    }

    public static List<ScenarioInput> extractGivenValues(SimulationDescriptor simulationDescriptor, List<FactMappingValue> factMappingValues, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator) {
        ArrayList<ScenarioInput> scenarioInput = new ArrayList<ScenarioInput>();
        Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = ScenarioRunnerHelper.groupByFactIdentifierAndFilter(factMappingValues, FactMappingType.GIVEN);
        for (Map.Entry<FactIdentifier, List<FactMappingValue>> entry : groupByFactIdentifier.entrySet()) {
            FactIdentifier factIdentifier = entry.getKey();
            Map<List<String>, Object> paramsForBean = ScenarioRunnerHelper.getParamsForBean(simulationDescriptor, factIdentifier, entry.getValue(), classLoader, expressionEvaluator);
            Object bean = ScenarioBeanUtil.fillBean(factIdentifier.getClassName(), paramsForBean, classLoader);
            scenarioInput.add(new ScenarioInput(factIdentifier, bean));
        }
        return scenarioInput;
    }

    public static List<ScenarioOutput> extractExpectedValues(List<FactMappingValue> factMappingValues) {
        ArrayList<ScenarioOutput> scenarioOutput = new ArrayList<ScenarioOutput>();
        Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = ScenarioRunnerHelper.groupByFactIdentifierAndFilter(factMappingValues, FactMappingType.EXPECTED);
        Set inputFacts = factMappingValues.stream().filter(elem -> FactMappingType.GIVEN.equals((Object)elem.getExpressionIdentifier().getType())).map(FactMappingValue::getFactIdentifier).collect(Collectors.toSet());
        Iterator<Map.Entry<FactIdentifier, List<FactMappingValue>>> iterator = groupByFactIdentifier.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FactIdentifier, List<FactMappingValue>> entry;
            FactIdentifier factIdentifier;
            scenarioOutput.add(new ScenarioOutput(factIdentifier, entry.getValue(), !inputFacts.contains(factIdentifier = (entry = iterator.next()).getKey())));
        }
        return scenarioOutput;
    }

    public static RequestContext executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluator expressionEvaluator, SimulationDescriptor simulationDescriptor) {
        ScenarioExecutableBuilder scenarioExecutableBuilder = ScenarioExecutableBuilder.createBuilder(kieContainer);
        scenarioRunnerData.getInputData().stream().map(ScenarioInput::getValue).forEach(scenarioExecutableBuilder::insert);
        scenarioRunnerData.getOutputData().stream().filter(ScenarioOutput::isNewFact).flatMap(output -> output.getExpectedResult().stream().map(factMappingValue -> new ScenarioResult(output.getFactIdentifier(), (FactMappingValue)factMappingValue))).forEach(scenarioResult -> {
            Class clazz = ScenarioBeanUtil.loadClass(scenarioResult.getFactIdentifier().getClassName(), kieContainer.getClassLoader());
            scenarioRunnerData.addResult((ScenarioResult)scenarioResult);
            scenarioExecutableBuilder.addInternalCondition(clazz, ScenarioRunnerHelper.createExtractorFunction(expressionEvaluator, scenarioResult.getFactMappingValue(), simulationDescriptor), (ScenarioResult)scenarioResult);
        });
        return scenarioExecutableBuilder.run();
    }

    public static void verifyConditions(SimulationDescriptor simulationDescriptor, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluator expressionEvaluator) {
        for (ScenarioInput input : scenarioRunnerData.getInputData()) {
            FactIdentifier factIdentifier = input.getFactIdentifier();
            List<ScenarioOutput> assertionOnFact = scenarioRunnerData.getOutputData().stream().filter(elem -> !elem.isNewFact()).filter(elem -> Objects.equals(elem.getFactIdentifier(), factIdentifier)).collect(Collectors.toList());
            if (assertionOnFact.size() < 1) continue;
            ScenarioRunnerHelper.getScenarioResultsFromGivenFacts(simulationDescriptor, assertionOnFact, input, expressionEvaluator).forEach(scenarioRunnerData::addResult);
        }
    }

    public static List<ScenarioResult> getScenarioResultsFromGivenFacts(SimulationDescriptor simulationDescriptor, List<ScenarioOutput> scenarioOutputsPerFact, ScenarioInput input, ExpressionEvaluator expressionEvaluator) {
        FactIdentifier factIdentifier = input.getFactIdentifier();
        Object factInstance = input.getValue();
        ArrayList<ScenarioResult> scenarioResults = new ArrayList<ScenarioResult>();
        for (ScenarioOutput scenarioOutput : scenarioOutputsPerFact) {
            if (scenarioOutput.isNewFact()) continue;
            Iterator<FactMappingValue> iterator = scenarioOutput.getExpectedResult().iterator();
            while (iterator.hasNext()) {
                FactMappingValue expectedResult;
                SingleFactValueResult resultValue = ScenarioRunnerHelper.createExtractorFunction(expressionEvaluator, expectedResult = iterator.next(), simulationDescriptor).apply(factInstance);
                expectedResult.setError(!resultValue.isSatisfied());
                scenarioResults.add(new ScenarioResult(factIdentifier, expectedResult, resultValue).setResult(resultValue.isSatisfied()));
            }
        }
        return scenarioResults;
    }

    public static void validateAssertion(List<ScenarioResult> scenarioResults, Scenario scenario, EachTestNotifier singleNotifier) {
        boolean scenarioFailed = false;
        for (ScenarioResult scenarioResult : scenarioResults) {
            if (scenarioResult.getResult()) continue;
            singleNotifier.addFailedAssumption((AssumptionViolatedException)new ScenarioAssumptionViolatedException(scenario, scenarioResult, "Scenario '" + scenario.getDescription() + "' has wrong assertion"));
            scenarioFailed = true;
        }
        if (scenarioFailed) {
            throw new ScenarioException("Scenario '" + scenario.getDescription() + "' failed");
        }
    }

    public static Map<List<String>, Object> getParamsForBean(SimulationDescriptor simulationDescriptor, FactIdentifier factIdentifier, List<FactMappingValue> factMappingValues, ClassLoader classLoader, ExpressionEvaluator expressionEvaluator) {
        HashMap<List<String>, Object> paramsForBean = new HashMap<List<String>, Object>();
        for (FactMappingValue factMappingValue : factMappingValues) {
            ExpressionIdentifier expressionIdentifier = factMappingValue.getExpressionIdentifier();
            FactMapping factMapping = (FactMapping)simulationDescriptor.getFactMapping(factIdentifier, expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
            List pathToField = factMapping.getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            try {
                Object value = expressionEvaluator.getValueForGiven(factMapping.getClassName(), factMappingValue.getRawValue(), classLoader);
                paramsForBean.put(pathToField, value);
            }
            catch (IllegalArgumentException e) {
                factMappingValue.setError(true);
                throw new ScenarioException(e.getMessage(), e);
            }
        }
        return paramsForBean;
    }

    public static Map<FactIdentifier, List<FactMappingValue>> groupByFactIdentifierAndFilter(List<FactMappingValue> factMappingValues, FactMappingType type) {
        HashMap<FactIdentifier, List<FactMappingValue>> groupByFactIdentifier = new HashMap<FactIdentifier, List<FactMappingValue>>();
        for (FactMappingValue factMappingValue : factMappingValues) {
            FactIdentifier factIdentifier = factMappingValue.getFactIdentifier();
            if (FactIdentifier.EMPTY.equals((Object)factIdentifier)) continue;
            ExpressionIdentifier expressionIdentifier = factMappingValue.getExpressionIdentifier();
            if (expressionIdentifier == null) {
                throw new IllegalArgumentException("ExpressionIdentifier malformed");
            }
            if (!Objects.equals(expressionIdentifier.getType(), type)) continue;
            groupByFactIdentifier.computeIfAbsent(factIdentifier, key -> new ArrayList()).add(factMappingValue);
        }
        return groupByFactIdentifier;
    }

    public static Function<Object, SingleFactValueResult> createExtractorFunction(ExpressionEvaluator expressionEvaluator, FactMappingValue expectedResult, SimulationDescriptor simulationDescriptor) {
        return objectToCheck -> {
            ExpressionIdentifier expressionIdentifier = expectedResult.getExpressionIdentifier();
            FactMapping factMapping = (FactMapping)simulationDescriptor.getFactMapping(expectedResult.getFactIdentifier(), expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
            List<String> pathToValue = factMapping.getExpressionElements().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            Object resultValue = ScenarioBeanUtil.navigateToObject(objectToCheck, pathToValue, false);
            try {
                return expressionEvaluator.evaluate(expectedResult.getRawValue(), resultValue) ? SingleFactValueResult.createResult(resultValue) : SingleFactValueResult.createErrorResult();
            }
            catch (Exception e) {
                expectedResult.setError(true);
                throw new ScenarioException(e.getMessage(), e);
            }
        };
    }
}

