/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.function.Function;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.BaseExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.kie.api.runtime.KieContainer;

public class ScenarioRunnerImpl
extends Runner {
    private final ClassLoader classLoader;
    private Function<ClassLoader, ExpressionEvaluator> expressionEvaluatorFactory = BaseExpressionEvaluator::new;
    private final Description desc;
    private final KieContainer kieContainer;
    private final SimulationDescriptor simulationDescriptor;
    private List<Scenario> scenarios;

    public ScenarioRunnerImpl(KieContainer kieContainer, Simulation simulation) {
        this(kieContainer, simulation.getSimulationDescriptor(), simulation.getUnmodifiableScenarios());
    }

    public ScenarioRunnerImpl(KieContainer kieContainer, SimulationDescriptor simulationDescriptor, List<Scenario> scenarios) {
        this.kieContainer = kieContainer;
        this.simulationDescriptor = simulationDescriptor;
        this.scenarios = scenarios;
        this.desc = ScenarioRunnerImpl.getDescriptionForSimulationDescriptor(simulationDescriptor);
        this.classLoader = kieContainer.getClassLoader();
    }

    public void run(RunNotifier notifier) {
        for (Scenario scenario : this.scenarios) {
            this.internalRunScenario(scenario, this.getSingleNotifier(notifier, scenario));
        }
    }

    public Description getDescription() {
        return this.desc;
    }

    private EachTestNotifier getSingleNotifier(RunNotifier notifier, Scenario scenario) {
        Description childDescription = Description.createTestDescription(((Object)((Object)this)).getClass(), (String)scenario.getDescription());
        this.desc.addChild(childDescription);
        return new EachTestNotifier(notifier, childDescription);
    }

    protected List<ScenarioResult> internalRunScenario(Scenario scenario, EachTestNotifier singleNotifier) {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        singleNotifier.fireTestStarted();
        try {
            ExpressionEvaluator expressionEvaluator = this.createExpressionEvaluator();
            ScenarioRunnerHelper.extractGivenValues(this.simulationDescriptor, scenario.getUnmodifiableFactMappingValues(), this.classLoader, expressionEvaluator).forEach(scenarioRunnerData::addInput);
            ScenarioRunnerHelper.extractExpectedValues(scenario.getUnmodifiableFactMappingValues()).forEach(scenarioRunnerData::addOutput);
            ScenarioRunnerHelper.executeScenario(this.kieContainer, scenarioRunnerData, expressionEvaluator, this.simulationDescriptor);
            ScenarioRunnerHelper.verifyConditions(this.simulationDescriptor, scenarioRunnerData, expressionEvaluator);
            ScenarioRunnerHelper.validateAssertion(scenarioRunnerData.getResultData(), scenario, singleNotifier);
        }
        catch (ScenarioException e) {
            singleNotifier.addFailure((Throwable)e);
        }
        catch (Throwable e) {
            singleNotifier.addFailure((Throwable)new IllegalStateException("Unexpected test error in scenario '" + scenario.getDescription() + "'", e));
        }
        singleNotifier.fireTestFinished();
        return scenarioRunnerData.getResultData();
    }

    public ExpressionEvaluator createExpressionEvaluator() {
        return this.expressionEvaluatorFactory.apply(this.classLoader);
    }

    public void setExpressionEvaluatorFactory(Function<ClassLoader, ExpressionEvaluator> expressionEvaluatorFactory) {
        this.expressionEvaluatorFactory = expressionEvaluatorFactory;
    }

    public static Description getDescriptionForSimulationDescriptor(SimulationDescriptor simulationDescriptor) {
        return Description.createSuiteDescription((String)"Test Scenarios (Preview) tests", (Annotation[])new Annotation[0]);
    }
}

