/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.util;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;

public class ResourceHelper {
    private ResourceHelper() {
    }

    static String[] getClassPathElements() {
        return System.getProperty("java.class.path", ".").split(System.getProperty("path.separator"));
    }

    public static Stream<String> getResourcesByExtension(String extension) {
        return Arrays.stream(ResourceHelper.getClassPathElements()).flatMap(elem -> ResourceHelper.internalGetResources(elem, Pattern.compile(".*\\." + extension + "$")));
    }

    static Stream<String> internalGetResources(String path, Pattern pattern) {
        File file = new File(path);
        if (!file.isDirectory()) {
            return Stream.empty();
        }
        return ResourceHelper.getResourcesFromDirectory(file, pattern);
    }

    public static Stream<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        if (directory == null || directory.listFiles() == null) {
            return Stream.empty();
        }
        return Arrays.stream(directory.listFiles()).flatMap(elem -> {
            if (elem.isDirectory()) {
                return ResourceHelper.getResourcesFromDirectory(elem, pattern);
            }
            try {
                String fileName = elem.getCanonicalPath();
                if (pattern.matcher(fileName).matches()) {
                    return Stream.of(fileName);
                }
            }
            catch (IOException e) {
                throw new ScenarioException("Impossible to access to resources", e);
            }
            return Stream.empty();
        });
    }
}

