/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioRunnerServiceImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.IndexedScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioRunnerImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.service.BuildInfo;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioRunnerImplServiceImplTest {
    @Mock
    private EventSourceMock<TestResultMessage> defaultTestResultMessageEventMock;
    @Mock
    private Runner runnerMock;
    @Mock
    private KieModuleService moduleServiceMock;
    @Mock
    private BuildInfoService buildInfoServiceMock;
    @Mock
    private BuildInfo buildInfoMock;
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private ModuleClassLoaderHelper classLoaderHelperMock;
    @Captor
    private ArgumentCaptor<TestResultMessage> testResultMessageArgumentCaptor;
    @InjectMocks
    private ScenarioRunnerServiceImpl scenarioRunnerService = new ScenarioRunnerServiceImpl();

    @Before
    public void setup() {
        Mockito.when((Object)this.classLoaderHelperMock.getModuleClassLoader((KieModule)Matchers.any())).thenReturn((Object)ClassLoader.getSystemClassLoader());
    }

    @Test
    public void runAllTests() throws Exception {
        this.scenarioRunnerService.runAllTests("test", (Path)Mockito.mock(Path.class));
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEventMock)).fire(Matchers.any());
    }

    @Test
    public void runTest() throws Exception {
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfoMock);
        Mockito.when((Object)this.buildInfoMock.getKieContainer()).thenReturn((Object)this.kieContainerMock);
        ScenarioSimulationModel scenarioSimulationModel = (ScenarioSimulationModel)Mockito.mock(ScenarioSimulationModel.class);
        Mockito.when((Object)scenarioSimulationModel.getSimulation()).thenReturn(Mockito.mock(Simulation.class));
        this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), scenarioSimulationModel);
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEventMock)).fire(Matchers.any());
    }

    @Test
    public void runAllTestsSpecifiedEvent() throws Exception {
        EventSourceMock customTestResultEvent = (EventSourceMock)Mockito.mock(EventSourceMock.class);
        this.scenarioRunnerService.setRunnerSupplier((kieContainer, simulation) -> this.runnerMock);
        this.scenarioRunnerService.runAllTests("test", (Path)Mockito.mock(Path.class), (Event)customTestResultEvent);
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEventMock, (VerificationMode)Mockito.never())).fire(Matchers.any());
        ((EventSourceMock)Mockito.verify((Object)customTestResultEvent)).fire(Matchers.any());
    }

    @Test
    public void runFailed() throws Exception {
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfoMock);
        Mockito.when((Object)this.buildInfoMock.getKieContainer()).thenReturn((Object)this.kieContainerMock);
        ScenarioSimulationModel scenarioSimulationModel = new ScenarioSimulationModel();
        Scenario scenario = scenarioSimulationModel.getSimulation().getScenarioByIndex(0);
        scenario.setDescription("Test Scenario");
        final String errorMessage = "Test Error";
        this.scenarioRunnerService.setRunnerSupplier((kieContainer, simulation) -> new ScenarioRunnerImpl((KieContainer)kieContainer, (Simulation)simulation){

            protected List<ScenarioResult> internalRunScenario(int index, Scenario scenario, RunNotifier runNotifier) {
                runNotifier.fireTestStarted(1.getDescriptionForScenario((Optional)this.getFileName(), (int)index, (Scenario)scenario));
                runNotifier.fireTestFailure(new Failure(1.getDescriptionForScenario((Optional)this.getFileName(), (int)index, (Scenario)scenario), (Throwable)new IndexedScenarioException(index, errorMessage)));
                return Collections.emptyList();
            }
        });
        this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), scenarioSimulationModel);
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEventMock, (VerificationMode)Mockito.times((int)1))).fire(this.testResultMessageArgumentCaptor.capture());
        TestResultMessage value = (TestResultMessage)this.testResultMessageArgumentCaptor.getValue();
        List failures = value.getFailures();
        Assert.assertEquals((long)1L, (long)failures.size());
        String testDescription = String.format("#%d: %s", 1, scenario.getDescription());
        String errorMessageFormatted = String.format("#%d: %s", 1, errorMessage);
        org.guvnor.common.services.shared.test.Failure failure = (org.guvnor.common.services.shared.test.Failure)failures.get(0);
        Assert.assertEquals((Object)errorMessageFormatted, (Object)failure.getMessage());
        Assert.assertTrue((boolean)failure.getDisplayName().startsWith(testDescription));
    }
}

