/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationXMLPersistence;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.project.datamodel.imports.Import;

public class ScenarioSimulationXMLPersistenceTest {
    ScenarioSimulationXMLPersistence instance = ScenarioSimulationXMLPersistence.getInstance();

    @Test
    public void noFQCNUsed() throws Exception {
        ScenarioSimulationModel simulationModel = new ScenarioSimulationModel();
        simulationModel.getImports().addImport(new Import("org.test.Test"));
        String xml = this.instance.marshal(simulationModel);
        Assert.assertFalse((boolean)xml.contains("org.drools.workbench.screens.scenariosimulation.model"));
        Assert.assertFalse((boolean)xml.contains("org.kie.soup.project.datamodel.imports"));
    }

    @Test
    public void versionAttributeExists() throws Exception {
        String xml = this.instance.marshal(new ScenarioSimulationModel());
        Assert.assertTrue((boolean)xml.startsWith("<ScenarioSimulationModel version=\"" + ScenarioSimulationXMLPersistence.getCurrentVersion() + "\">"));
    }

    @Test
    public void migrateIfNecessary_1_0_to_1_1() {
        String migrated = this.instance.migrateIfNecessary("<ScenarioSimulationModel version=\"1.0\">\n  <simulation>\n    <simulationDescriptor>\n      <factMappings>\n        <FactMapping>\n          <expressionElements>\n            <ExpressionElement>\n              <step>lengthYears</step>\n            </ExpressionElement>\n          </expressionElements>\n          <expressionIdentifier>\n            <name>1541680933813</name>\n            <type>EXPECTED</type>\n          </expressionIdentifier>\n          <factIdentifier>\n            <name>1541680933813</name>\n            <className>mortgages.mortgages.LoanApplication</className>\n          </factIdentifier>\n          <className>java.lang.Integer</className>\n          <factAlias>LoanApplication1</factAlias>\n          <expressionAlias>lengthYears</expressionAlias>\n        </FactMapping>\n      </factMappings>\n    </simulationDescriptor>\n    <scenarios>\n      <Scenario>\n        <factMappingValues>\n          <FactMappingValue/>\n        </factMappingValues>\n        <simulationDescriptor reference=\"../../../simulationDescriptor\"/>\n      </Scenario>\n    </scenarios>\n  </simulation>\n  <imports>\n    <imports/>\n  </imports>\n</ScenarioSimulationModel>");
        Assert.assertTrue((boolean)migrated.contains("EXPECT"));
        Assert.assertFalse((boolean)migrated.contains("EXPECTED"));
    }

    @Test
    public void migrateIfNecessary() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instance.migrateIfNecessary("<ScenarioSimulationModel version=\"9999999999.99999999999\">")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Version 9999999999.99999999999 of the file is not supported. Current version is " + ScenarioSimulationXMLPersistence.getCurrentVersion());
        String noMigrationNeeded = "<ScenarioSimulationModel version=\"" + ScenarioSimulationXMLPersistence.getCurrentVersion() + "\">";
        String afterMigration = this.instance.migrateIfNecessary(noMigrationNeeded);
        Assert.assertEquals((Object)noMigrationNeeded, (Object)afterMigration);
    }

    @Test
    public void extractVersion() {
        String version = this.instance.extractVersion("<ScenarioSimulationModel version=\"1.0\" version=\"1.1\">");
        Assert.assertEquals((Object)"1.0", (Object)version);
    }
}

