/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.expression;

import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.BaseExpressionOperator;
import org.junit.Assert;
import org.junit.Test;

public class BaseExpressionOperatorTest {
    private static final ClassLoader classLoader = BaseExpressionOperatorTest.class.getClassLoader();

    @Test
    public void getValueForGivenTest() {
        Arrays.stream(BaseExpressionOperator.values()).filter(e -> !BaseExpressionOperator.EQUALS.equals(e)).forEach(operator -> ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> operator.getValueForGiven(String.class.getCanonicalName(), " Test ", classLoader)).isInstanceOf(IllegalStateException.class)).hasMessage("This operator cannot be used into a Given clause"));
        Assert.assertEquals((Object)"Test", (Object)BaseExpressionOperator.EQUALS.getValueForGiven(String.class.getCanonicalName(), "= Test", classLoader));
        Assert.assertEquals((Object)"", (Object)BaseExpressionOperator.EQUALS.getValueForGiven(String.class.getCanonicalName(), "= ", classLoader));
        Assert.assertEquals(null, (Object)BaseExpressionOperator.EQUALS.getValueForGiven(String.class.getCanonicalName(), "", classLoader));
    }

    @Test
    public void findOperator() {
        String rawValue = "Test";
        Assert.assertEquals((Object)BaseExpressionOperator.EQUALS, (Object)BaseExpressionOperator.findOperator((String)rawValue));
        rawValue = " Test ";
        Assert.assertEquals((Object)BaseExpressionOperator.EQUALS, (Object)BaseExpressionOperator.findOperator((String)rawValue));
        rawValue = "= Test ";
        Assert.assertEquals((Object)BaseExpressionOperator.EQUALS, (Object)BaseExpressionOperator.findOperator((String)rawValue));
        rawValue = "!= Test ";
        Assert.assertEquals((Object)BaseExpressionOperator.NOT_EQUALS, (Object)BaseExpressionOperator.findOperator((String)rawValue));
    }

    @Test
    public void equalsTest() {
        MyTestClass test1 = new MyTestClass();
        MyTestClass test2 = new MyTestClass();
        MyComparableTestClass comparableTest1 = new MyComparableTestClass();
        Assert.assertTrue((boolean)BaseExpressionOperator.EQUALS.eval((Object)test1, (Object)test1, test1.getClass(), classLoader));
        Assert.assertFalse((boolean)BaseExpressionOperator.EQUALS.eval((Object)test1, (Object)test2, test1.getClass(), classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.EQUALS.eval((Object)comparableTest1, (Object)comparableTest1, comparableTest1.getClass(), classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.EQUALS.eval((Object)"1", (Object)1, Integer.TYPE, classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.EQUALS.eval(null, null, null, classLoader));
    }

    @Test
    public void notEqualsTest() {
        MyTestClass test1 = new MyTestClass();
        MyTestClass test2 = new MyTestClass();
        MyComparableTestClass comparableTest1 = new MyComparableTestClass();
        Assert.assertFalse((boolean)BaseExpressionOperator.NOT_EQUALS.eval((Object)test1, (Object)test1, test1.getClass(), classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.NOT_EQUALS.eval((Object)test1, (Object)test2, test1.getClass(), classLoader));
        Assert.assertFalse((boolean)BaseExpressionOperator.NOT_EQUALS.eval((Object)comparableTest1, (Object)comparableTest1, comparableTest1.getClass(), classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.NOT_EQUALS.eval((Object)"<> 1", (Object)2, Integer.TYPE, classLoader));
        Assert.assertFalse((boolean)BaseExpressionOperator.NOT_EQUALS.eval(null, null, null, classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.NOT_EQUALS.eval((Object)"! <1", (Object)2, Integer.TYPE, classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.NOT_EQUALS.eval((Object)"! [1, 3]", (Object)2, Integer.TYPE, classLoader));
    }

    @Test
    public void rangeTest() {
        Object o = new Object();
        Assert.assertFalse((boolean)BaseExpressionOperator.RANGE.eval(o, (Object)"", o.getClass(), classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.RANGE.eval((Object)">2", (Object)3, Integer.TYPE, classLoader));
    }

    @Test
    public void listOfValuesTest() {
        Object o = new Object();
        Assert.assertFalse((boolean)BaseExpressionOperator.LIST_OF_VALUES.eval(o, (Object)"", o.getClass(), classLoader));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BaseExpressionOperator.LIST_OF_VALUES.eval((Object)"[ 2", (Object)"", String.class, classLoader)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Malformed expression: [ 2");
        Assert.assertTrue((boolean)BaseExpressionOperator.LIST_OF_VALUES.eval((Object)"[ Test, Another Test]", (Object)"Another Test", String.class, classLoader));
    }

    @Test
    public void listOfConditionsTest() {
        Object o = new Object();
        Assert.assertFalse((boolean)BaseExpressionOperator.LIST_OF_CONDITION.eval(o, (Object)"", o.getClass(), classLoader));
        Assert.assertTrue((boolean)BaseExpressionOperator.LIST_OF_CONDITION.eval((Object)"=1; ![2, 3]; <10", (Object)1, Integer.TYPE, classLoader));
    }

    private class MyComparableTestClass
    implements Comparable<MyComparableTestClass> {
        private MyComparableTestClass() {
        }

        @Override
        public int compareTo(MyComparableTestClass o) {
            return 0;
        }
    }

    private class MyTestClass {
        private MyTestClass() {
        }
    }
}

