/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.BaseExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.Dispute;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.Person;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioInput;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioOutput;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.SingleFactValueResult;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScenarioRunnerHelperTest {
    private static final String NAME = "NAME";
    private static final double AMOUNT = 10.0;
    private static final String TEST_DESCRIPTION = "Test description";
    private static final ClassLoader classLoader = ScenarioRunnerHelperTest.class.getClassLoader();
    private static final ExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(classLoader);
    private Simulation simulation;
    private FactIdentifier personFactIdentifier;
    private ExpressionIdentifier firstNameGivenExpressionIdentifier;
    private FactMapping firstNameGivenFactMapping;
    private Scenario scenario1;
    private Scenario scenario2;
    private ExpressionIdentifier firstNameExpectedExpressionIdentifier;
    private FactMapping firstNameExpectedFactMapping;
    private FactIdentifier disputeFactIdentifier;
    private ExpressionIdentifier amountGivenExpressionIdentifier;
    private FactMapping amountNameGivenFactMapping;
    private ExpressionIdentifier amountExpectedExpressionIdentifier;
    private FactMapping amountNameExpectedFactMapping;
    private FactMappingValue amountNameExpectedFactMappingValue;

    @Before
    public void setup() {
        this.simulation = new Simulation();
        this.personFactIdentifier = FactIdentifier.create((String)"Fact 1", (String)Person.class.getCanonicalName());
        this.firstNameGivenExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Given", (FactMappingType)FactMappingType.GIVEN);
        this.firstNameGivenFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.firstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.disputeFactIdentifier = FactIdentifier.create((String)"Fact 2", (String)Dispute.class.getCanonicalName());
        this.amountGivenExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Given", (FactMappingType)FactMappingType.GIVEN);
        this.amountNameGivenFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.amountNameGivenFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.firstNameExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Expected", (FactMappingType)FactMappingType.EXPECT);
        this.firstNameExpectedFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier);
        this.firstNameExpectedFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.amountExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Expected", (FactMappingType)FactMappingType.EXPECT);
        this.amountNameExpectedFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier);
        this.amountNameExpectedFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.scenario1 = this.simulation.addScenario();
        this.scenario1.setDescription(TEST_DESCRIPTION);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        this.scenario2 = this.simulation.addScenario();
        this.scenario2.setDescription(TEST_DESCRIPTION);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)10.0);
        this.amountNameExpectedFactMappingValue = this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier, (Object)10.0);
    }

    @Test
    public void extractGivenValuesTest() {
        List scenario1Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario1.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenario1Inputs.size());
        List scenario2Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario2.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)2L, (long)scenario2Inputs.size());
    }

    @Test
    public void extractExpectedValuesTest() {
        List scenario1Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario1.getUnmodifiableFactMappingValues());
        Assert.assertEquals((long)1L, (long)scenario1Outputs.size());
        this.scenario2.addOrUpdateMappingValue(FactIdentifier.create((String)"TEST", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"TEST", (FactMappingType)FactMappingType.EXPECT), (Object)"TEST");
        List scenario2Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario2.getUnmodifiableFactMappingValues());
        Assert.assertEquals((long)3L, (long)scenario2Outputs.size());
        Assert.assertEquals((long)1L, (long)scenario2Outputs.stream().filter(ScenarioOutput::isNewFact).count());
    }

    @Test
    public void verifyConditionsTest() {
        List scenario1Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario1.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        List scenario1Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario1.getUnmodifiableFactMappingValues());
        ScenarioRunnerData scenarioRunnerData1 = new ScenarioRunnerData();
        scenario1Inputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData1).addInput(arg_0));
        scenario1Outputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData1).addOutput(arg_0));
        ScenarioRunnerHelper.verifyConditions((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (ScenarioRunnerData)scenarioRunnerData1, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenarioRunnerData1.getResultData().size());
        List scenario2Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario2.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        List scenario2Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario2.getUnmodifiableFactMappingValues());
        ScenarioRunnerData scenarioRunnerData2 = new ScenarioRunnerData();
        scenario2Inputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData2).addInput(arg_0));
        scenario2Outputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData2).addOutput(arg_0));
        ScenarioRunnerHelper.verifyConditions((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (ScenarioRunnerData)scenarioRunnerData2, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)2L, (long)scenarioRunnerData2.getResultData().size());
    }

    @Test
    public void getScenarioResultsTest() {
        List scenario1Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario1.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        List scenario1Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario1.getUnmodifiableFactMappingValues());
        Assert.assertTrue((scenario1Inputs.size() > 0 ? 1 : 0) != 0);
        ScenarioInput input1 = (ScenarioInput)scenario1Inputs.get(0);
        scenario1Outputs = scenario1Outputs.stream().filter(elem -> elem.getFactIdentifier().equals((Object)input1.getFactIdentifier())).collect(Collectors.toList());
        List scenario1Results = ScenarioRunnerHelper.getScenarioResultsFromGivenFacts((SimulationDescriptor)this.simulation.getSimulationDescriptor(), scenario1Outputs, (ScenarioInput)input1, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenario1Results.size());
        Assert.assertFalse((boolean)((FactMappingValue)((ScenarioOutput)scenario1Outputs.get(0)).getExpectedResult().get(0)).isError());
        List scenario2Inputs = ScenarioRunnerHelper.extractGivenValues((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (List)this.scenario2.getUnmodifiableFactMappingValues(), (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
        List scenario2Outputs = ScenarioRunnerHelper.extractExpectedValues((List)this.scenario2.getUnmodifiableFactMappingValues());
        Assert.assertTrue((scenario2Inputs.size() > 0 ? 1 : 0) != 0);
        ScenarioInput input2 = (ScenarioInput)scenario2Inputs.get(0);
        scenario2Outputs = scenario2Outputs.stream().filter(elem -> elem.getFactIdentifier().equals((Object)input2.getFactIdentifier())).collect(Collectors.toList());
        List scenario2Results = ScenarioRunnerHelper.getScenarioResultsFromGivenFacts((SimulationDescriptor)this.simulation.getSimulationDescriptor(), scenario2Outputs, (ScenarioInput)input2, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenario2Results.size());
        Assert.assertFalse((boolean)((FactMappingValue)((ScenarioOutput)scenario2Outputs.get(0)).getExpectedResult().get(0)).isError());
        List<ScenarioOutput> newFact = Collections.singletonList(new ScenarioOutput(this.personFactIdentifier, Collections.emptyList(), true));
        List scenario2NoResults = ScenarioRunnerHelper.getScenarioResultsFromGivenFacts((SimulationDescriptor)this.simulation.getSimulationDescriptor(), newFact, (ScenarioInput)input2, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertEquals((long)0L, (long)scenario2NoResults.size());
        Person person = new Person();
        person.setFirstName("ANOTHER STRING");
        ScenarioInput newInput = new ScenarioInput(this.personFactIdentifier, (Object)person);
        List scenario3Results = ScenarioRunnerHelper.getScenarioResultsFromGivenFacts((SimulationDescriptor)this.simulation.getSimulationDescriptor(), scenario1Outputs, (ScenarioInput)newInput, (ExpressionEvaluator)expressionEvaluator);
        Assert.assertTrue((boolean)((FactMappingValue)((ScenarioOutput)scenario1Outputs.get(0)).getExpectedResult().get(0)).isError());
        Assert.assertEquals((long)1L, (long)scenario3Results.size());
    }

    @Test
    public void validateAssertionTest() {
        ArrayList<ScenarioResult> scenarioFailResult = new ArrayList<ScenarioResult>();
        scenarioFailResult.add(new ScenarioResult(this.disputeFactIdentifier, this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE"));
        try {
            ScenarioRunnerHelper.validateAssertion(scenarioFailResult, (Scenario)this.scenario2);
            Assert.fail();
        }
        catch (ScenarioException scenarioException) {
            // empty catch block
        }
        ArrayList<ScenarioResult> scenarioSuccessResult = new ArrayList<ScenarioResult>();
        scenarioSuccessResult.add(new ScenarioResult(this.disputeFactIdentifier, this.amountNameExpectedFactMappingValue, this.amountNameExpectedFactMappingValue.getRawValue()).setResult(true));
        ScenarioRunnerHelper.validateAssertion(scenarioSuccessResult, (Scenario)this.scenario2);
    }

    @Test
    public void groupByFactIdentifierAndFilterTest() {
        Map scenario1Given = ScenarioRunnerHelper.groupByFactIdentifierAndFilter((List)this.scenario1.getUnmodifiableFactMappingValues(), (FactMappingType)FactMappingType.GIVEN);
        Map scenario1Expected = ScenarioRunnerHelper.groupByFactIdentifierAndFilter((List)this.scenario1.getUnmodifiableFactMappingValues(), (FactMappingType)FactMappingType.EXPECT);
        Map scenario2Given = ScenarioRunnerHelper.groupByFactIdentifierAndFilter((List)this.scenario2.getUnmodifiableFactMappingValues(), (FactMappingType)FactMappingType.GIVEN);
        Map scenario2Expected = ScenarioRunnerHelper.groupByFactIdentifierAndFilter((List)this.scenario2.getUnmodifiableFactMappingValues(), (FactMappingType)FactMappingType.EXPECT);
        Assert.assertEquals((long)1L, (long)scenario1Given.keySet().size());
        Assert.assertEquals((long)1L, (long)scenario1Expected.keySet().size());
        Assert.assertEquals((long)2L, (long)scenario2Given.keySet().size());
        Assert.assertEquals((long)2L, (long)scenario2Expected.keySet().size());
        Assert.assertEquals((long)1L, (long)((List)scenario1Given.get(this.personFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario1Expected.get(this.personFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario2Given.get(this.disputeFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario2Expected.get(this.disputeFactIdentifier)).size());
        Scenario scenario = new Scenario();
        scenario.addMappingValue(FactIdentifier.EMPTY, ExpressionIdentifier.DESCRIPTION, null);
        Assert.assertEquals((long)0L, (long)ScenarioRunnerHelper.groupByFactIdentifierAndFilter((List)scenario.getUnmodifiableFactMappingValues(), (FactMappingType)FactMappingType.GIVEN).size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void groupByFactIdentifierAndFilterFailTest() {
        ArrayList<FactMappingValue> fail = new ArrayList<FactMappingValue>();
        fail.add(new FactMappingValue());
        ScenarioRunnerHelper.groupByFactIdentifierAndFilter(fail, (FactMappingType)FactMappingType.GIVEN);
    }

    @Test
    public void createExtractorFunctionTest() {
        String personName = "Test";
        FactMappingValue factMappingValue = new FactMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)personName);
        Function extractorFunction = ScenarioRunnerHelper.createExtractorFunction((ExpressionEvaluator)expressionEvaluator, (FactMappingValue)factMappingValue, (SimulationDescriptor)this.simulation.getSimulationDescriptor());
        Person person = new Person();
        person.setFirstName(personName);
        Assert.assertTrue((boolean)((SingleFactValueResult)extractorFunction.apply(person)).isSatisfied());
        person.setFirstName("OtherString");
        Assert.assertFalse((boolean)((SingleFactValueResult)extractorFunction.apply(person)).isSatisfied());
        Function extractorFunction1 = ScenarioRunnerHelper.createExtractorFunction((ExpressionEvaluator)expressionEvaluator, (FactMappingValue)new FactMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, null), (SimulationDescriptor)this.simulation.getSimulationDescriptor());
        SingleFactValueResult nullValue = (SingleFactValueResult)extractorFunction1.apply(new Person());
        Assert.assertTrue((boolean)nullValue.isSatisfied());
        Assert.assertNull((Object)nullValue.getResult());
    }

    @Test
    public void getParamsForBeanTest() {
        ArrayList<FactMappingValue> factMappingValues = new ArrayList<FactMappingValue>();
        FactMappingValue factMappingValue = new FactMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)"NOT PARSABLE");
        factMappingValues.add(factMappingValue);
        try {
            ScenarioRunnerHelper.getParamsForBean((SimulationDescriptor)this.simulation.getSimulationDescriptor(), (FactIdentifier)this.disputeFactIdentifier, factMappingValues, (ClassLoader)classLoader, (ExpressionEvaluator)expressionEvaluator);
            Assert.fail();
        }
        catch (ScenarioException scenarioException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)factMappingValue.isError());
    }
}

