/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.ArrayList;
import java.util.function.BiFunction;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioRunnerImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.JunitRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioRunnerService;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class ScenarioRunnerServiceImpl
implements ScenarioRunnerService {
    @Inject
    private Event<TestResultMessage> defaultTestResultMessageEvent;
    @Inject
    private KieModuleService moduleService;
    @Inject
    private BuildInfoService buildInfoService;
    private BiFunction<KieContainer, Simulation, Runner> runnerSupplier = ScenarioRunnerImpl::new;

    public void runAllTests(String identifier, Path path) {
        this.defaultTestResultMessageEvent.fire((Object)new TestResultMessage(identifier, 1, 1L, new ArrayList()));
    }

    public void runAllTests(String identifier, Path path, Event<TestResultMessage> customTestResultEvent) {
        customTestResultEvent.fire((Object)new TestResultMessage(identifier, 1, 1L, new ArrayList()));
    }

    public ScenarioSimulationModel runTest(String identifier, Path path, ScenarioSimulationModel model) {
        KieModule kieModule = this.getKieModule(path);
        KieContainer kieContainer = this.getKieContainer(kieModule);
        Runner scenarioRunner = this.getRunnerSupplier().apply(kieContainer, model.getSimulation());
        ArrayList<Failure> failures = new ArrayList<Failure>();
        ArrayList<Failure> failureDetails = new ArrayList<Failure>();
        Result result = JunitRunnerHelper.runWithJunit(scenarioRunner, failures, failureDetails);
        this.defaultTestResultMessageEvent.fire((Object)new TestResultMessage(identifier, result.getRunCount(), result.getRunTime(), failures));
        return model;
    }

    protected KieModule getKieModule(Path path) {
        return (KieModule)this.moduleService.resolveModule(path);
    }

    protected KieContainer getKieContainer(KieModule kieModule) {
        return this.buildInfoService.getBuildInfo((Module)kieModule).getKieContainer();
    }

    public BiFunction<KieContainer, Simulation, Runner> getRunnerSupplier() {
        return this.runnerSupplier;
    }

    public void setRunnerSupplier(BiFunction<KieContainer, Simulation, Runner> runnerSupplier) {
        this.runnerSupplier = runnerSupplier;
    }
}

