/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationXMLPersistence;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioRunnerImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.SimulationWithFileName;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ResourceHelper;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.type.ScenarioSimulationResourceTypeDefinition;
import org.junit.runner.Description;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;

public class ScenarioJunitActivator
extends ParentRunner<SimulationWithFileName> {
    public static final String ACTIVATOR_CLASS_NAME = "ScenarioJunitActivatorTest";
    public static final Function<String, String> ACTIVATOR_CLASS_CODE = modulePackage -> String.format("package %s;\n/**\n* Do not remove this file\n*/\n@%s(%s.class)\npublic class %s {\n}", modulePackage, RunWith.class.getCanonicalName(), ScenarioJunitActivator.class.getCanonicalName(), ACTIVATOR_CLASS_NAME);

    public ScenarioJunitActivator(Class<?> testClass) throws InitializationError {
        super(testClass);
    }

    protected List<SimulationWithFileName> getChildren() {
        return this.getResources().map(elem -> {
            try {
                String rawFile = new Scanner(new File((String)elem)).useDelimiter("\\Z").next();
                return new SimulationWithFileName(this.getXmlReader().unmarshal(rawFile).getSimulation(), (String)elem);
            }
            catch (FileNotFoundException e) {
                throw new ScenarioException("File not found, this should not happen: " + elem, e);
            }
        }).collect(Collectors.toList());
    }

    protected Description describeChild(SimulationWithFileName child) {
        return ScenarioRunnerImpl.getDescriptionForSimulation(Optional.of(child.getFileName()), child.getSimulation());
    }

    protected void runChild(SimulationWithFileName child, RunNotifier notifier) {
        KieContainer kieClasspathContainer = this.getKieContainer();
        ScenarioRunnerImpl scenarioRunner = this.newRunner(kieClasspathContainer, child.getSimulation());
        scenarioRunner.setFileName(child.getFileName());
        scenarioRunner.run(notifier);
    }

    ScenarioSimulationXMLPersistence getXmlReader() {
        return ScenarioSimulationXMLPersistence.getInstance();
    }

    Stream<String> getResources() {
        ScenarioSimulationResourceTypeDefinition typeDefinition = new ScenarioSimulationResourceTypeDefinition();
        return ResourceHelper.getResourcesByExtension(typeDefinition.getSuffix());
    }

    KieContainer getKieContainer() {
        return KieServices.get().getKieClasspathContainer();
    }

    ScenarioRunnerImpl newRunner(KieContainer kieContainer, Simulation simulation) {
        return new ScenarioRunnerImpl(kieContainer, simulation);
    }
}

