/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.BaseExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.IndexedScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.kie.api.runtime.KieContainer;

public class ScenarioRunnerImpl
extends Runner {
    private final ClassLoader classLoader;
    private Function<ClassLoader, ExpressionEvaluator> expressionEvaluatorFactory = BaseExpressionEvaluator::new;
    private final Description desc;
    private final KieContainer kieContainer;
    private final SimulationDescriptor simulationDescriptor;
    private Map<Integer, Scenario> scenarios;
    private String fileName;

    public ScenarioRunnerImpl(KieContainer kieContainer, Simulation simulation) {
        this(kieContainer, simulation.getSimulationDescriptor(), ScenarioRunnerImpl.toScenarioMap(simulation), null);
    }

    public ScenarioRunnerImpl(KieContainer kieContainer, Simulation simulation, String fileName) {
        this(kieContainer, simulation.getSimulationDescriptor(), ScenarioRunnerImpl.toScenarioMap(simulation), fileName);
    }

    public ScenarioRunnerImpl(KieContainer kieContainer, SimulationDescriptor simulationDescriptor, Map<Integer, Scenario> scenarios, String fileName) {
        this.kieContainer = kieContainer;
        this.simulationDescriptor = simulationDescriptor;
        this.scenarios = scenarios;
        this.fileName = fileName;
        this.desc = ScenarioRunnerImpl.getDescriptionForSimulation(this.getFileName(), simulationDescriptor, scenarios);
        this.classLoader = kieContainer.getClassLoader();
    }

    public void run(RunNotifier notifier) {
        notifier.fireTestStarted(this.getDescription());
        for (Map.Entry<Integer, Scenario> integerScenarioEntry : this.scenarios.entrySet()) {
            Scenario scenario = integerScenarioEntry.getValue();
            Integer index = integerScenarioEntry.getKey();
            this.internalRunScenario(index, scenario, notifier);
        }
        notifier.fireTestStarted(this.getDescription());
    }

    public Description getDescription() {
        return this.desc;
    }

    protected List<ScenarioResult> internalRunScenario(int index, Scenario scenario, RunNotifier runNotifier) {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        try {
            runNotifier.fireTestStarted(ScenarioRunnerImpl.getDescriptionForScenario(this.getFileName(), index, scenario));
            ExpressionEvaluator expressionEvaluator = this.createExpressionEvaluator();
            ScenarioRunnerHelper.extractGivenValues(this.simulationDescriptor, scenario.getUnmodifiableFactMappingValues(), this.classLoader, expressionEvaluator).forEach(scenarioRunnerData::addInput);
            ScenarioRunnerHelper.extractExpectedValues(scenario.getUnmodifiableFactMappingValues()).forEach(scenarioRunnerData::addOutput);
            ScenarioRunnerHelper.executeScenario(this.kieContainer, scenarioRunnerData, expressionEvaluator, this.simulationDescriptor);
            ScenarioRunnerHelper.verifyConditions(this.simulationDescriptor, scenarioRunnerData, expressionEvaluator);
            ScenarioRunnerHelper.validateAssertion(scenarioRunnerData.getResultData(), scenario);
            runNotifier.fireTestFinished(ScenarioRunnerImpl.getDescriptionForScenario(this.getFileName(), index, scenario));
        }
        catch (ScenarioException e) {
            IndexedScenarioException indexedScenarioException = new IndexedScenarioException(index, (Throwable)e);
            indexedScenarioException.setFileName(this.fileName);
            runNotifier.fireTestFailure(new Failure(ScenarioRunnerImpl.getDescriptionForScenario(this.getFileName(), index, scenario), (Throwable)indexedScenarioException));
        }
        catch (Throwable e) {
            IndexedScenarioException indexedScenarioException = new IndexedScenarioException(index, "Unexpected test error in scenario '" + scenario.getDescription() + "'", e);
            indexedScenarioException.setFileName(this.fileName);
            runNotifier.fireTestFailure(new Failure(ScenarioRunnerImpl.getDescriptionForScenario(this.getFileName(), index, scenario), (Throwable)indexedScenarioException));
        }
        return scenarioRunnerData.getResultData();
    }

    public ExpressionEvaluator createExpressionEvaluator() {
        return this.expressionEvaluatorFactory.apply(this.classLoader);
    }

    public void setExpressionEvaluatorFactory(Function<ClassLoader, ExpressionEvaluator> expressionEvaluatorFactory) {
        this.expressionEvaluatorFactory = expressionEvaluatorFactory;
    }

    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public static Description getDescriptionForSimulation(Optional<String> filename, Simulation simulation) {
        return ScenarioRunnerImpl.getDescriptionForSimulation(filename, simulation.getSimulationDescriptor(), ScenarioRunnerImpl.toScenarioMap(simulation));
    }

    public static Description getDescriptionForSimulation(Optional<String> filename, SimulationDescriptor simulationDescriptor, Map<Integer, Scenario> scenarios) {
        Description suiteDescription = Description.createSuiteDescription((String)"Test Scenarios (Preview) tests", (Annotation[])new Annotation[0]);
        scenarios.forEach((index, scenario) -> suiteDescription.addChild(ScenarioRunnerImpl.getDescriptionForScenario(filename, index, scenario)));
        return suiteDescription;
    }

    public static Map<Integer, Scenario> toScenarioMap(Simulation simulation) {
        List scenarios = simulation.getUnmodifiableScenarios();
        HashMap<Integer, Scenario> indexToScenario = new HashMap<Integer, Scenario>();
        for (int index = 0; index < scenarios.size(); ++index) {
            indexToScenario.put(index + 1, (Scenario)scenarios.get(index));
        }
        return indexToScenario;
    }

    public static Description getDescriptionForScenario(Optional<String> className, int index, Scenario scenario) {
        return Description.createTestDescription((String)className.orElse(ScenarioRunnerImpl.class.getCanonicalName()), (String)String.format("#%d: %s", index, scenario.getDescription()), (Annotation[])new Annotation[0]);
    }
}

