/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractDMNTest;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.DMNSimulationCreationStrategy;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNSimulationCreationStrategyTest
extends AbstractDMNTest {
    private DMNSimulationCreationStrategy dmnSimulationCreationStrategy;

    @Override
    @Before
    public void init() {
        super.init();
        this.dmnSimulationCreationStrategy = (DMNSimulationCreationStrategy)Mockito.spy((Object)new DMNSimulationCreationStrategy(){});
    }

    @Test
    public void createSimulation() throws Exception {
        FactModelTuple factModelTuple = this.getFactModelTuple();
        Path pathMock = (Path)Mockito.mock(Path.class);
        String dmnFilePath = "test";
        ((DMNSimulationCreationStrategy)Mockito.doReturn((Object)factModelTuple).when((Object)this.dmnSimulationCreationStrategy)).getFactModelTuple((Path)Matchers.any(), (String)Matchers.any());
        Simulation retrieved = this.dmnSimulationCreationStrategy.createSimulation(pathMock, "test");
        Assert.assertNotNull((Object)retrieved);
    }

    private FactModelTuple getFactModelTuple() throws IOException {
        DMNType type;
        TreeMap<String, FactModelTree> visibleFacts = new TreeMap<String, FactModelTree>();
        TreeMap<String, FactModelTree> hiddenFacts = new TreeMap<String, FactModelTree>();
        for (InputDataNode input : this.dmnModelMock.getInputs()) {
            type = input.getType();
            visibleFacts.put(input.getName(), this.createFactModelTree(input.getName(), input.getName(), type, hiddenFacts, FactModelTree.Type.INPUT));
        }
        for (DecisionNode decision : this.dmnModelMock.getDecisions()) {
            type = decision.getResultType();
            visibleFacts.put(decision.getName(), this.createFactModelTree(decision.getName(), decision.getName(), type, hiddenFacts, FactModelTree.Type.DECISION));
        }
        return new FactModelTuple(visibleFacts, hiddenFacts);
    }

    private FactModelTree createFactModelTree(String name, String path, DMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType) {
        HashMap<String, String> simpleFields = new HashMap<String, String>();
        if (!type.isComposite()) {
            simpleFields.put("value", type.getName());
            FactModelTree simpleFactModelTree = new FactModelTree(name, "", simpleFields, fmType);
            simpleFactModelTree.setSimple(true);
            return simpleFactModelTree;
        }
        FactModelTree factModelTree = new FactModelTree(name, "", simpleFields, fmType);
        for (Map.Entry entry : type.getFields().entrySet()) {
            if (!((DMNType)entry.getValue()).isComposite()) {
                simpleFields.put((String)entry.getKey(), ((DMNType)entry.getValue()).getName());
                continue;
            }
            String expandableId = path + "." + (String)entry.getKey();
            factModelTree.addExpandableProperty((String)entry.getKey(), expandableId);
            hiddenFacts.put(expandableId, this.createFactModelTree((String)entry.getKey(), expandableId, (DMNType)entry.getValue(), hiddenFacts, FactModelTree.Type.UNDEFINED));
        }
        return factModelTree;
    }
}

