/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.List;
import java.util.TreeMap;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractDMNTest;
import org.drools.workbench.screens.scenariosimulation.backend.server.DMNTypeServiceImpl;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNTypeServiceImplTest
extends AbstractDMNTest {
    private DMNTypeServiceImpl dmnTypeServiceImpl;

    @Override
    @Before
    public void init() {
        super.init();
        this.dmnTypeServiceImpl = new DMNTypeServiceImpl(){

            public DMNModel getDMNModel(Path path, String stringPath) {
                return DMNTypeServiceImplTest.this.dmnModelMock;
            }
        };
    }

    @Test
    public void retrieveType() {
        FactModelTuple factModelTuple = this.dmnTypeServiceImpl.retrieveType((Path)Mockito.mock(Path.class), null);
        Assert.assertEquals((Object)"SIMPLE_TYPE_NAME", (Object)((FactModelTree)factModelTuple.getVisibleFacts().get("SIMPLE_TYPE_NAME")).getFactName());
        Assert.assertEquals((Object)"BASE_TYPE", ((FactModelTree)factModelTuple.getVisibleFacts().get("SIMPLE_TYPE_NAME")).getSimpleProperties().get("value"));
        Assert.assertTrue((boolean)((FactModelTree)factModelTuple.getVisibleFacts().get("SIMPLE_TYPE_NAME")).isSimple());
        Assert.assertEquals((Object)"SIMPLE_DECISION_TYPE_NAME", (Object)((FactModelTree)factModelTuple.getVisibleFacts().get("SIMPLE_DECISION_TYPE_NAME")).getFactName());
        Assert.assertEquals((Object)"BASE_TYPE", ((FactModelTree)factModelTuple.getVisibleFacts().get("SIMPLE_DECISION_TYPE_NAME")).getSimpleProperties().get("value"));
        Assert.assertTrue((boolean)((FactModelTree)factModelTuple.getVisibleFacts().get("SIMPLE_DECISION_TYPE_NAME")).isSimple());
        Assert.assertEquals((Object)"COMPLEX_DECISION_TYPE_NAME", (Object)((FactModelTree)factModelTuple.getVisibleFacts().get("COMPLEX_DECISION_TYPE_NAME")).getFactName());
        String hiddenKey = (String)((FactModelTree)factModelTuple.getVisibleFacts().get("COMPLEX_DECISION_TYPE_NAME")).getExpandableProperties().get("COMPLEX_DECISION_TYPE_NAME");
        Assert.assertEquals((Object)"BASE_TYPE", ((FactModelTree)factModelTuple.getHiddenFacts().get(hiddenKey)).getSimpleProperties().get("SIMPLE_DECISION_TYPE_NAME"));
    }

    @Test
    public void createFactModelTree() {
        SimpleTypeImpl simpleString = new SimpleTypeImpl(null, "string", null);
        FactModelTree simpleStringFactModelTree = this.dmnTypeServiceImpl.createFactModelTree("testProperty", "testProperty", (DMNType)simpleString, new TreeMap(), FactModelTree.Type.INPUT);
        Assert.assertEquals((long)1L, (long)simpleStringFactModelTree.getSimpleProperties().size());
        Assert.assertTrue((boolean)simpleStringFactModelTree.getSimpleProperties().containsKey("value"));
        Assert.assertEquals((Object)"string", simpleStringFactModelTree.getSimpleProperties().get("value"));
        SimpleTypeImpl simpleCollectionString = new SimpleTypeImpl(null, "string", null);
        simpleCollectionString.setCollection(true);
        TreeMap hiddenFactSimpleCollection = new TreeMap();
        FactModelTree simpleCollectionStringFactModelTree = this.dmnTypeServiceImpl.createFactModelTree("testProperty", "testProperty", (DMNType)simpleCollectionString, hiddenFactSimpleCollection, FactModelTree.Type.INPUT);
        Assert.assertEquals((long)1L, (long)simpleCollectionStringFactModelTree.getSimpleProperties().size());
        Assert.assertTrue((boolean)simpleCollectionStringFactModelTree.getSimpleProperties().containsKey("value"));
        Assert.assertEquals((Object)"string", simpleCollectionStringFactModelTree.getSimpleProperties().get("value"));
        CompositeTypeImpl person = new CompositeTypeImpl();
        CompositeTypeImpl phoneNumberCompositeCollection = new CompositeTypeImpl(null, "tPhoneNumber", null, true);
        phoneNumberCompositeCollection.addField("prefix", (DMNType)new SimpleTypeImpl(null, "string", null));
        phoneNumberCompositeCollection.addField("number", (DMNType)new SimpleTypeImpl(null, "string", null));
        CompositeTypeImpl detailsComposite = new CompositeTypeImpl(null, "tDetails", "tDetails");
        detailsComposite.addField("gender", (DMNType)new SimpleTypeImpl(null, "string", null));
        detailsComposite.addField("weight", (DMNType)new SimpleTypeImpl(null, "string", null));
        SimpleTypeImpl nameSimple = new SimpleTypeImpl(null, "string", null);
        SimpleTypeImpl friendsSimpleCollection = new SimpleTypeImpl(null, "string", null);
        friendsSimpleCollection.setCollection(true);
        person.addField("friends", (DMNType)friendsSimpleCollection);
        person.addField("phoneNumbers", (DMNType)phoneNumberCompositeCollection);
        person.addField("details", (DMNType)detailsComposite);
        person.addField("name", (DMNType)nameSimple);
        TreeMap hiddenFacts = new TreeMap();
        FactModelTree factModelTree = this.dmnTypeServiceImpl.createFactModelTree("testProperty", "testProperty", (DMNType)person, hiddenFacts, FactModelTree.Type.INPUT);
        Assert.assertEquals((long)3L, (long)factModelTree.getSimpleProperties().size());
        Assert.assertEquals((long)1L, (long)factModelTree.getExpandableProperties().size());
        Assert.assertEquals((Object)List.class.getCanonicalName(), factModelTree.getSimpleProperties().get("friends"));
        Assert.assertEquals((Object)List.class.getCanonicalName(), factModelTree.getSimpleProperties().get("phoneNumbers"));
        Assert.assertEquals((long)1L, (long)factModelTree.getGenericTypeInfo("friends").size());
    }

    @Test
    public void checkTypeSupport() {
        SimpleTypeImpl topLevelCollection = new SimpleTypeImpl(null, "string", null);
        topLevelCollection.setCollection(true);
        DMNTypeServiceImpl.ErrorHolder errorHolder = new DMNTypeServiceImpl.ErrorHolder();
        this.dmnTypeServiceImpl.checkTypeSupport((DMNType)topLevelCollection, errorHolder, "fieldName");
        Assert.assertEquals((long)1L, (long)errorHolder.getTopLevelCollection().size());
        Assert.assertEquals((long)0L, (long)errorHolder.getMultipleNestedObject().size());
        Assert.assertEquals((long)0L, (long)errorHolder.getMultipleNestedCollection().size());
        Assert.assertEquals((Object)"fieldName", errorHolder.getTopLevelCollection().get(0));
        CompositeTypeImpl person = new CompositeTypeImpl();
        SimpleTypeImpl numbers = new SimpleTypeImpl(null, "string", null);
        numbers.setCollection(true);
        CompositeTypeImpl phoneNumberCompositeCollection = new CompositeTypeImpl(null, "tPhoneNumber", null, true);
        phoneNumberCompositeCollection.addField("numbers", (DMNType)numbers);
        person.addField("phoneNumbers", (DMNType)phoneNumberCompositeCollection);
        errorHolder = new DMNTypeServiceImpl.ErrorHolder();
        this.dmnTypeServiceImpl.checkTypeSupport((DMNType)person, errorHolder, "fieldName");
        Assert.assertEquals((long)0L, (long)errorHolder.getTopLevelCollection().size());
        Assert.assertEquals((long)0L, (long)errorHolder.getMultipleNestedObject().size());
        Assert.assertEquals((long)1L, (long)errorHolder.getMultipleNestedCollection().size());
        Assert.assertEquals((Object)"fieldName.phoneNumbers.numbers", errorHolder.getMultipleNestedCollection().get(0));
        person = new CompositeTypeImpl();
        CompositeTypeImpl complexNumbers = new CompositeTypeImpl(null, "tPhoneNumber", null, false);
        phoneNumberCompositeCollection = new CompositeTypeImpl(null, "tPhoneNumber", null, true);
        phoneNumberCompositeCollection.addField("complexNumbers", (DMNType)complexNumbers);
        person.addField("phoneNumbers", (DMNType)phoneNumberCompositeCollection);
        errorHolder = new DMNTypeServiceImpl.ErrorHolder();
        this.dmnTypeServiceImpl.checkTypeSupport((DMNType)person, errorHolder, "fieldName");
        Assert.assertEquals((long)0L, (long)errorHolder.getTopLevelCollection().size());
        Assert.assertEquals((long)1L, (long)errorHolder.getMultipleNestedObject().size());
        Assert.assertEquals((long)0L, (long)errorHolder.getMultipleNestedCollection().size());
        Assert.assertEquals((Object)"fieldName.phoneNumbers.complexNumbers", errorHolder.getMultipleNestedObject().get(0));
    }
}

