/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.HashSet;
import javax.inject.Named;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioRunnerServiceImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationServiceImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ScenarioSimulationBuilder;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.metadata.MetadataServerSideService;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.services.backend.service.KieServiceOverviewLoader;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.backend.version.PathResolver;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioSimulationServiceImplTest {
    @Mock
    @Named(value="ioStrategy")
    private IOService ioServiceMock;
    @Mock
    private CommentedOptionFactory commentedOptionFactoryMock;
    @Mock
    private SaveAndRenameServiceImpl<ScenarioSimulationModel, Metadata> saveAndRenameServiceMock;
    @Mock
    private PathResolver pathResolverMock;
    @Mock
    protected KieServiceOverviewLoader overviewLoaderMock;
    @Mock
    protected MetadataServerSideService metadataServiceMock;
    @Mock
    private DeleteService deleteServiceMock;
    @Mock
    private RenameService renameServiceMock;
    @Mock
    private CopyService copyServiceMock;
    @Mock
    private User userMock;
    @Mock
    private ScenarioRunnerServiceImpl scenarioRunnerServiceMock;
    @Mock
    private POMService pomServiceMock;
    @Mock
    private Path activatorPathMock;
    @Mock
    private KieModuleService kieModuleServiceMock;
    @Mock
    private KieModule kieModuleMock;
    @Mock
    private POM projectPomMock;
    @Mock
    private GAV gavMock;
    @Mock
    private Dependencies dependenciesMock;
    @Mock
    private Package packageMock;
    @Mock
    private ScenarioSimulationBuilder scenarioSimulationBuilderMock;
    @InjectMocks
    private ScenarioSimulationServiceImpl service = new ScenarioSimulationServiceImpl((SessionInfo)Mockito.mock(SafeSessionInfo.class));
    private org.uberfire.backend.vfs.Path path = PathFactory.newPath((String)"contextPath", (String)"file:///contextPath");

    @Before
    public void setup() throws Exception {
        HashSet<Package> testPackages = new HashSet<Package>();
        Package testPackage = new Package(this.path, this.path, this.path, this.path, this.path, "Test", "", "");
        testPackages.add(testPackage);
        Mockito.when((Object)this.kieModuleServiceMock.resolveModule((org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)this.kieModuleMock);
        Mockito.when((Object)this.kieModuleServiceMock.resolvePackages((Module)Matchers.any(KieModule.class))).thenReturn(testPackages);
        Mockito.when((Object)this.kieModuleServiceMock.newPackage((Package)Matchers.any(), Matchers.anyString())).thenReturn((Object)testPackage);
        Mockito.when((Object)this.kieModuleServiceMock.resolveDefaultPackage((Module)Matchers.any())).thenReturn((Object)testPackage);
        Mockito.when((Object)this.ioServiceMock.exists(this.activatorPathMock)).thenReturn((Object)false);
        Mockito.when((Object)this.kieModuleServiceMock.resolveModule((org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)this.kieModuleMock);
        Mockito.when((Object)this.kieModuleMock.getPom()).thenReturn((Object)this.projectPomMock);
        Mockito.when((Object)this.projectPomMock.getGav()).thenReturn((Object)this.gavMock);
        Mockito.when((Object)this.gavMock.getGroupId()).thenReturn((Object)"Test");
        Mockito.when((Object)this.projectPomMock.getDependencies()).thenReturn((Object)this.dependenciesMock);
        Mockito.when((Object)this.ioServiceMock.exists((Path)Matchers.any(Path.class))).thenReturn((Object)false);
        Mockito.when((Object)this.packageMock.getPackageTestSrcPath()).thenReturn((Object)this.path);
        Mockito.when((Object)this.scenarioSimulationBuilderMock.createSimulation((org.uberfire.backend.vfs.Path)Matchers.any(), (ScenarioSimulationModel.Type)Matchers.any(), (String)Matchers.any())).thenReturn((Object)new Simulation());
        this.service.scenarioSimulationBuilder = this.scenarioSimulationBuilderMock;
    }

    @Test
    public void init() throws Exception {
        this.service.init();
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameServiceMock)).init((SupportsSaveAndRename)this.service);
    }

    @Test
    public void delete() throws Exception {
        this.service.delete(this.path, "Removing this");
        ((DeleteService)Mockito.verify((Object)this.deleteServiceMock)).delete(this.path, "Removing this");
    }

    @Test
    public void rename() throws Exception {
        this.service.rename(this.path, "newName.scesim", "comment");
        ((RenameService)Mockito.verify((Object)this.renameServiceMock)).rename(this.path, "newName.scesim", "comment");
    }

    @Test
    public void copy() throws Exception {
        this.service.copy(this.path, "newName.scesim", "comment");
        ((CopyService)Mockito.verify((Object)this.copyServiceMock)).copy(this.path, "newName.scesim", "comment");
    }

    @Test
    public void copyToDirectory() throws Exception {
        org.uberfire.backend.vfs.Path folder = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        this.service.copy(this.path, "newName.scesim", folder, "comment");
        ((CopyService)Mockito.verify((Object)this.copyServiceMock)).copy(this.path, "newName.scesim", folder, "comment");
    }

    @Test
    public void saveAndRename() throws Exception {
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        this.service.saveAndRename(this.path, "newName.scesim", metadata, model, "comment");
        ((SaveAndRenameServiceImpl)Mockito.verify(this.saveAndRenameServiceMock)).saveAndRename(this.path, "newName.scesim", (Object)metadata, (Object)model, "comment");
    }

    @Test
    public void save() throws Exception {
        org.uberfire.backend.vfs.Path returnPath = this.service.save(this.path, new ScenarioSimulationModel(), new Metadata(), "Commit comment");
        Assert.assertNotNull((Object)returnPath);
        ((IOService)Mockito.verify((Object)this.ioServiceMock)).write((Path)Matchers.any(Path.class), Matchers.anyString(), Matchers.anyMap(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
    }

    @Test
    public void createRULEScenario() throws Exception {
        ((IOService)Mockito.doReturn((Object)false).when((Object)this.ioServiceMock)).exists((Path)Matchers.any());
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        Assert.assertNull((Object)model.getSimulation());
        org.uberfire.backend.vfs.Path returnPath = this.service.create(this.path, "test.scesim", model, "Commit comment", ScenarioSimulationModel.Type.RULE, "default");
        Assert.assertNotNull((Object)returnPath);
        Assert.assertNotNull((Object)model.getSimulation());
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.times((int)2))).write((Path)Matchers.any(Path.class), Matchers.anyString(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
    }

    @Test
    public void createDMNScenario() throws Exception {
        ((IOService)Mockito.doReturn((Object)false).when((Object)this.ioServiceMock)).exists((Path)Matchers.any());
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        Assert.assertNull((Object)model.getSimulation());
        org.uberfire.backend.vfs.Path returnPath = this.service.create(this.path, "test.scesim", model, "Commit comment", ScenarioSimulationModel.Type.DMN, "test");
        Assert.assertNotNull((Object)returnPath);
        Assert.assertNotNull((Object)model.getSimulation());
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.times((int)2))).write((Path)Matchers.any(Path.class), Matchers.anyString(), new OpenOption[]{(OpenOption)Matchers.any(CommentedOption.class)});
    }

    @Test(expected=FileAlreadyExistsException.class)
    public void createFileExists() throws Exception {
        ((IOService)Mockito.doReturn((Object)true).when((Object)this.ioServiceMock)).exists((Path)Matchers.any());
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        this.service.create(this.path, "test.scesim", model, "Commit comment");
    }

    @Test
    public void runScenario() throws Exception {
        ((User)Mockito.doReturn((Object)"test userMock").when((Object)this.userMock)).getIdentifier();
        org.uberfire.backend.vfs.Path path = (org.uberfire.backend.vfs.Path)Mockito.mock(org.uberfire.backend.vfs.Path.class);
        ScenarioSimulationModel model = new ScenarioSimulationModel();
        this.service.runScenario(path, model);
        ((ScenarioRunnerServiceImpl)Mockito.verify((Object)this.scenarioRunnerServiceMock)).runTest("test userMock", path, model);
    }

    @Test
    public void createActivatorIfNotExistTest() {
        this.service.createActivatorIfNotExist(this.path);
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.times((int)1))).write((Path)Matchers.any(Path.class), Matchers.anyString(), new OpenOption[]{(OpenOption)Matchers.any(OpenOption.class)});
        Mockito.reset((Object[])new IOService[]{this.ioServiceMock});
        Mockito.when((Object)this.ioServiceMock.exists((Path)Matchers.any())).thenReturn((Object)true);
        this.service.createActivatorIfNotExist(this.path);
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.never())).write((Path)Matchers.any(Path.class), Matchers.anyString(), new OpenOption[]{(OpenOption)Matchers.any(OpenOption.class)});
    }

    @Test
    public void getOrCreateJunitActivatorPackageTest() {
        this.service.getOrCreateJunitActivatorPackage(this.kieModuleMock);
        ((KieModuleService)Mockito.verify((Object)this.kieModuleServiceMock, (VerificationMode)Mockito.times((int)1))).newPackage((Package)Matchers.any(), Matchers.anyString());
        Mockito.reset((Object[])new KieModuleService[]{this.kieModuleServiceMock});
        Mockito.when((Object)this.kieModuleServiceMock.resolveDefaultPackage((Module)Matchers.any())).thenReturn((Object)this.packageMock);
        Mockito.when((Object)this.kieModuleServiceMock.resolvePackage((org.uberfire.backend.vfs.Path)Matchers.any())).thenReturn((Object)this.packageMock);
        this.service.getOrCreateJunitActivatorPackage(this.kieModuleMock);
        ((KieModuleService)Mockito.verify((Object)this.kieModuleServiceMock, (VerificationMode)Mockito.never())).newPackage((Package)Matchers.any(), Matchers.anyString());
    }

    @Test
    public void removeOldActivatorIfExistsTest() {
        this.service.removeOldActivatorIfExists(this.kieModuleMock);
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.times((int)1))).deleteIfExists((Path)Matchers.any(), new DeleteOption[0]);
        Mockito.reset((Object[])new IOService[]{this.ioServiceMock});
        Mockito.when((Object)this.kieModuleServiceMock.resolvePackages((Module)Matchers.any(KieModule.class))).thenReturn(new HashSet());
        this.service.removeOldActivatorIfExists(this.kieModuleMock);
        ((IOService)Mockito.verify((Object)this.ioServiceMock, (VerificationMode)Mockito.never())).deleteIfExists((Path)Matchers.any(), new DeleteOption[0]);
    }

    @Test
    public void ensureDependenciesTest() {
        this.service.ensureDependencies(this.kieModuleMock);
        ((POMService)Mockito.verify((Object)this.pomServiceMock, (VerificationMode)Mockito.times((int)1))).save((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class), Matchers.any(POM.class), (Metadata)Matchers.any(Metadata.class), Matchers.anyString());
        Mockito.reset((Object[])new POMService[]{this.pomServiceMock});
        Mockito.when((Object)this.dependenciesMock.containsDependency((GAV)Matchers.any())).thenReturn((Object)true);
        this.service.ensureDependencies(this.kieModuleMock);
        ((POMService)Mockito.verify((Object)this.pomServiceMock, (VerificationMode)Mockito.never())).save((org.uberfire.backend.vfs.Path)Matchers.any(org.uberfire.backend.vfs.Path.class), Matchers.any(POM.class), (Metadata)Matchers.any(Metadata.class), Matchers.anyString());
    }

    @Test
    public void editPomIfNecessaryTest() {
        String groupId = "groupId";
        String artifactId = "artifactId";
        String version = "version";
        GAV gav = new GAV(groupId, artifactId, version);
        Dependencies dependencies = new Dependencies();
        Assert.assertTrue((boolean)this.service.editPomIfNecessary(dependencies, gav));
        Assert.assertFalse((boolean)this.service.editPomIfNecessary(dependencies, gav));
    }

    @Test
    public void getActivatorPathTest() {
        Assert.assertTrue((boolean)this.service.getActivatorPath(this.packageMock).endsWith("ScenarioJunitActivatorTest.java"));
    }
}

