/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.enterprise.context.ApplicationScoped;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractKieContainerService;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.DMNSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class DMNTypeServiceImpl
extends AbstractKieContainerService
implements DMNTypeService {
    public FactModelTuple retrieveType(Path path, String dmnPath) {
        DMNType type;
        DMNModel dmnModel = this.getDMNModel(path, dmnPath);
        TreeMap<String, FactModelTree> visibleFacts = new TreeMap<String, FactModelTree>();
        TreeMap<String, FactModelTree> hiddenFacts = new TreeMap<String, FactModelTree>();
        ErrorHolder errorHolder = new ErrorHolder();
        for (InputDataNode input : dmnModel.getInputs()) {
            type = input.getType();
            this.checkTypeSupport(type, errorHolder, input.getName());
            visibleFacts.put(input.getName(), this.createFactModelTree(input.getName(), input.getName(), type, hiddenFacts, FactModelTree.Type.INPUT));
        }
        for (DecisionNode decision : dmnModel.getDecisions()) {
            type = decision.getResultType();
            this.checkTypeSupport(type, errorHolder, decision.getName());
            visibleFacts.put(decision.getName(), this.createFactModelTree(decision.getName(), decision.getName(), type, hiddenFacts, FactModelTree.Type.DECISION));
        }
        FactModelTuple factModelTuple = new FactModelTuple(visibleFacts, hiddenFacts);
        errorHolder.getTopLevelCollection().forEach(arg_0 -> ((FactModelTuple)factModelTuple).addTopLevelCollectionError(arg_0));
        errorHolder.getMultipleNestedCollection().forEach(arg_0 -> ((FactModelTuple)factModelTuple).addMultipleNestedCollectionError(arg_0));
        errorHolder.getMultipleNestedObject().forEach(arg_0 -> ((FactModelTuple)factModelTuple).addMultipleNestedObjectError(arg_0));
        return factModelTuple;
    }

    public DMNModel getDMNModel(Path path, String dmnPath) {
        return DMNSimulationUtils.extractDMNModel(this.getDMNRuntime(path), dmnPath);
    }

    public DMNRuntime getDMNRuntime(Path path) {
        KieContainer kieContainer = this.getKieContainer(path);
        return DMNSimulationUtils.extractDMNRuntime(kieContainer);
    }

    protected FactModelTree createFactModelTree(String name, String path, DMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType) {
        return this.createFactModelTree(name, path, type, hiddenFacts, fmType, false);
    }

    protected FactModelTree createFactModelTree(String name, String path, DMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType, boolean collectionRecursion) {
        if (!type.isComposite()) {
            if (!type.isCollection() || collectionRecursion) {
                return this.createSimpleFact(name, type.getName(), fmType);
            }
            HashMap<String, String> simpleFields = new HashMap<String, String>();
            HashMap<String, List<String>> genericTypeInfoMap = new HashMap<String, List<String>>();
            String genericKey = this.populateGeneric(simpleFields, genericTypeInfoMap, path, type.getName(), type.getName());
            FactModelTree fact = this.createSimpleFact(name, type.getName(), fmType);
            hiddenFacts.put(genericKey, fact);
            return fact;
        }
        HashMap<String, String> simpleFields = new HashMap<String, String>();
        HashMap<String, List<String>> genericTypeInfoMap = new HashMap<String, List<String>>();
        FactModelTree factModelTree = new FactModelTree(name, "", simpleFields, genericTypeInfoMap, fmType);
        for (Map.Entry entry : type.getFields().entrySet()) {
            String expandableId = path + "." + (String)entry.getKey();
            if (((DMNType)entry.getValue()).isCollection()) {
                String genericKey = this.populateGeneric(simpleFields, genericTypeInfoMap, path, ((DMNType)entry.getValue()).getName(), (String)entry.getKey());
                FactModelTree fact = this.createFactModelTree((String)entry.getKey(), expandableId, (DMNType)entry.getValue(), hiddenFacts, FactModelTree.Type.UNDEFINED, true);
                hiddenFacts.put(genericKey, fact);
                continue;
            }
            if (!((DMNType)entry.getValue()).isComposite()) {
                simpleFields.put((String)entry.getKey(), ((DMNType)entry.getValue()).getName());
                continue;
            }
            factModelTree.addExpandableProperty((String)entry.getKey(), expandableId);
            hiddenFacts.put(expandableId, this.createFactModelTree((String)entry.getKey(), expandableId, (DMNType)entry.getValue(), hiddenFacts, FactModelTree.Type.UNDEFINED));
        }
        return factModelTree;
    }

    private FactModelTree createSimpleFact(String name, String type, FactModelTree.Type fmType) {
        HashMap<String, String> simpleFields = new HashMap<String, String>();
        HashMap genericTypeInfoMap = new HashMap();
        FactModelTree simpleFactModelTree = new FactModelTree(name, "", simpleFields, genericTypeInfoMap, fmType);
        simpleFields.put("value", type);
        simpleFactModelTree.setSimple(true);
        return simpleFactModelTree;
    }

    private String populateGeneric(Map<String, String> simpleFields, Map<String, List<String>> genericTypeInfoMap, String path, String type, String name) {
        String genericKey = path + "." + type;
        genericTypeInfoMap.put(name, Collections.singletonList(genericKey));
        simpleFields.put(name, List.class.getCanonicalName());
        return genericKey;
    }

    protected void checkTypeSupport(DMNType type, ErrorHolder errorHolder, String path) {
        if (type.isCollection()) {
            errorHolder.getTopLevelCollection().add(path);
        }
        this.visitType(type, false, errorHolder, path);
    }

    private void visitType(DMNType type, boolean alreadyInCollection, ErrorHolder errorHolder, String path) {
        if (type.isComposite()) {
            for (Map.Entry entry : type.getFields().entrySet()) {
                String name = (String)entry.getKey();
                DMNType nestedType = (DMNType)entry.getValue();
                String nestedPath = path + "." + name;
                if (alreadyInCollection && nestedType.isCollection()) {
                    errorHolder.getMultipleNestedCollection().add(nestedPath);
                }
                if (alreadyInCollection && nestedType.isComposite()) {
                    errorHolder.getMultipleNestedObject().add(nestedPath);
                }
                this.visitType(nestedType, alreadyInCollection || nestedType.isCollection(), errorHolder, nestedPath);
            }
        }
    }

    static class ErrorHolder {
        List<String> topLevelCollection = new ArrayList<String>();
        List<String> multipleNestedObject = new ArrayList<String>();
        List<String> multipleNestedCollection = new ArrayList<String>();

        ErrorHolder() {
        }

        public List<String> getTopLevelCollection() {
            return this.topLevelCollection;
        }

        public List<String> getMultipleNestedObject() {
            return this.multipleNestedObject;
        }

        public List<String> getMultipleNestedCollection() {
            return this.multipleNestedCollection;
        }
    }
}

