/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.ArrayList;
import java.util.function.BiFunction;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractKieContainerService;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.AbstractScenarioRunner;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.JunitRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioRunnerService;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.kie.api.runtime.KieContainer;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class ScenarioRunnerServiceImpl
extends AbstractKieContainerService
implements ScenarioRunnerService {
    @Inject
    private Event<TestResultMessage> defaultTestResultMessageEvent;
    private BiFunction<KieContainer, Simulation, AbstractScenarioRunner> runnerSupplier = null;

    public void runAllTests(String identifier, Path path) {
        this.defaultTestResultMessageEvent.fire((Object)new TestResultMessage(identifier, 1, 1L, new ArrayList()));
    }

    public void runAllTests(String identifier, Path path, Event<TestResultMessage> customTestResultEvent) {
        customTestResultEvent.fire((Object)new TestResultMessage(identifier, 1, 1L, new ArrayList()));
    }

    public ScenarioSimulationModel runTest(String identifier, Path path, ScenarioSimulationModel model) {
        KieContainer kieContainer = this.getKieContainer(path);
        Runner scenarioRunner = this.getOrCreateRunnerSupplier(model.getSimulation()).apply(kieContainer, model.getSimulation());
        ArrayList<Failure> failures = new ArrayList<Failure>();
        ArrayList<Failure> failureDetails = new ArrayList<Failure>();
        Result result = JunitRunnerHelper.runWithJunit(scenarioRunner, failures, failureDetails);
        this.defaultTestResultMessageEvent.fire((Object)new TestResultMessage(identifier, result.getRunCount(), result.getRunTime(), failures));
        return model;
    }

    public BiFunction<KieContainer, Simulation, AbstractScenarioRunner> getOrCreateRunnerSupplier(Simulation simulation) {
        if (this.runnerSupplier != null) {
            return this.runnerSupplier;
        }
        return AbstractScenarioRunner.getSpecificRunnerProvider(simulation);
    }

    public void setRunnerSupplier(BiFunction<KieContainer, Simulation, AbstractScenarioRunner> runnerSupplier) {
        this.runnerSupplier = runnerSupplier;
    }
}

