/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.expression;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.utils.ScenarioSimulationSharedUtils;

public abstract class AbstractExpressionEvaluator
implements ExpressionEvaluator {
    protected boolean internalEvaluate(Object rawExpression, Object resultValue, Class<?> resultClass) {
        if (resultClass != null && ScenarioSimulationSharedUtils.isCollection((String)resultClass.getCanonicalName())) {
            return this.verifyResult(rawExpression, resultValue, resultClass);
        }
        return this.internalUnaryEvaluation((String)rawExpression, resultValue, resultClass, false);
    }

    protected Object internalGetValueForGiven(String className, List<String> genericClasses, String raw) {
        if (ScenarioSimulationSharedUtils.isCollection((String)className)) {
            return this.convertResult(raw, className, genericClasses);
        }
        return this.internalLiteralEvaluate(raw, className);
    }

    protected Object convertResult(String rawString, String className, List<String> genericClasses) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = objectMapper.readTree(rawString);
            if (jsonNode.isArray()) {
                return this.createAndFillList((ArrayNode)jsonNode, new ArrayList<Object>(), className, genericClasses);
            }
            if (jsonNode.isObject()) {
                return this.createAndFillObject((ObjectNode)jsonNode, this.createObject(className, genericClasses), className, genericClasses);
            }
            throw new IllegalArgumentException("Malformed raw data");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Malformed raw data", e);
        }
    }

    protected List<Object> createAndFillList(ArrayNode json, List<Object> toReturn, String className, List<String> genericClasses) {
        for (JsonNode node : json) {
            String genericClassName = ScenarioSimulationSharedUtils.isMap((String)className) ? className : genericClasses.get(genericClasses.size() - 1);
            Object listElement = this.createObject(genericClassName, genericClasses);
            Object returnedObject = this.createAndFillObject((ObjectNode)node, listElement, genericClassName, genericClasses);
            toReturn.add(returnedObject);
        }
        return toReturn;
    }

    protected Object createAndFillObject(ObjectNode json, Object toReturn, String className, List<String> genericClasses) {
        Iterator fields = json.fields();
        int numberOfFields = json.size();
        while (fields.hasNext()) {
            Map.Entry<String, List<String>> fieldDescriptor;
            Map.Entry element = (Map.Entry)fields.next();
            String key = (String)element.getKey();
            JsonNode jsonNode = (JsonNode)element.getValue();
            if (numberOfFields == 1 && "value".equals(key)) {
                return this.internalLiteralEvaluate(jsonNode.textValue(), genericClasses.get(0));
            }
            if (jsonNode.isArray()) {
                ArrayList<Object> nestedList = new ArrayList<Object>();
                Map.Entry<String, List<String>> fieldDescriptor2 = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
                List<Object> returnedList = this.createAndFillList((ArrayNode)jsonNode, nestedList, fieldDescriptor2.getKey(), fieldDescriptor2.getValue());
                this.setField(toReturn, key, returnedList);
                continue;
            }
            if (jsonNode.isObject()) {
                fieldDescriptor = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
                Object nestedObject = this.createObject(fieldDescriptor.getKey(), fieldDescriptor.getValue());
                Object returnedObject = this.createAndFillObject((ObjectNode)jsonNode, nestedObject, fieldDescriptor.getKey(), fieldDescriptor.getValue());
                this.setField(toReturn, key, returnedObject);
                continue;
            }
            if (jsonNode.textValue() == null || jsonNode.textValue().isEmpty()) continue;
            fieldDescriptor = this.getFieldClassNameAndGenerics(toReturn, key, className, genericClasses);
            this.setField(toReturn, key, this.internalLiteralEvaluate(jsonNode.textValue(), fieldDescriptor.getKey()));
        }
        return toReturn;
    }

    protected boolean verifyResult(Object rawValue, Object resultRaw, Class<?> resultClass) {
        if (!(resultRaw instanceof List) && !(resultRaw instanceof Map)) {
            throw new IllegalArgumentException("A list was expected");
        }
        if (!(rawValue instanceof String)) {
            throw new IllegalArgumentException("Malformed raw data");
        }
        String raw = (String)rawValue;
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode jsonNode = objectMapper.readTree(raw);
            if (jsonNode.isArray()) {
                return this.verifyList((ArrayNode)jsonNode, (List)resultRaw, resultClass);
            }
            if (jsonNode.isObject()) {
                return this.verifyObject((ObjectNode)jsonNode, resultRaw, resultClass);
            }
            throw new IllegalArgumentException("Malformed raw data");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Malformed raw data", e);
        }
    }

    protected boolean verifyList(ArrayNode json, List resultRaw, Class<?> resultClass) {
        for (JsonNode node : json) {
            boolean success = false;
            for (Object result : resultRaw) {
                if (!this.verifyObject((ObjectNode)node, result, resultClass)) continue;
                success = true;
            }
            if (success) continue;
            return false;
        }
        return true;
    }

    protected boolean verifyObject(ObjectNode json, Object result, Class<?> resultClass) {
        Iterator fields = json.fields();
        int numberOfFields = json.size();
        while (fields.hasNext()) {
            Map.Entry element = (Map.Entry)fields.next();
            String key = (String)element.getKey();
            JsonNode jsonNode = (JsonNode)element.getValue();
            if (numberOfFields == 1 && "value".equals(key)) {
                return this.internalUnaryEvaluation(jsonNode.textValue(), result, result.getClass(), true);
            }
            Object fieldValue = this.extractFieldValue(result, key);
            if (!(jsonNode.isArray() ? !this.verifyList((ArrayNode)jsonNode, (List)fieldValue, fieldValue.getClass()) : (jsonNode.isObject() ? !this.verifyObject((ObjectNode)jsonNode, fieldValue, fieldValue.getClass()) : !this.internalUnaryEvaluation(jsonNode.textValue(), fieldValue, fieldValue.getClass(), true)))) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean internalUnaryEvaluation(String var1, Object var2, Class<?> var3, boolean var4);

    protected abstract Object internalLiteralEvaluate(String var1, String var2);

    protected abstract Object extractFieldValue(Object var1, String var2);

    protected abstract Object createObject(String var1, List<String> var2);

    protected abstract void setField(Object var1, String var2, Object var3);

    protected abstract Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object var1, String var2, String var3, List<String> var4);
}

