/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.fluent.DMNScenarioExecutableBuilder;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.AbstractRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ResultWrapper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioExpect;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioGiven;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNResult;

public class DMNScenarioRunnerHelper
extends AbstractRunnerHelper {
    @Override
    public RequestContext executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluator expressionEvaluator, SimulationDescriptor simulationDescriptor) {
        if (!ScenarioSimulationModel.Type.DMN.equals((Object)simulationDescriptor.getType())) {
            throw new ScenarioException("Impossible to run a not-DMN simulation with DMN runner");
        }
        DMNScenarioExecutableBuilder executableBuilder = DMNScenarioExecutableBuilder.createBuilder(kieContainer);
        executableBuilder.setActiveModel(simulationDescriptor.getDmnFilePath());
        for (ScenarioGiven input : scenarioRunnerData.getGivens()) {
            executableBuilder.setValue(input.getFactIdentifier().getName(), input.getValue());
        }
        return executableBuilder.run();
    }

    @Override
    public void verifyConditions(SimulationDescriptor simulationDescriptor, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluator expressionEvaluator, RequestContext requestContext) {
        DMNResult dmnResult = (DMNResult)requestContext.getOutput(DMNScenarioExecutableBuilder.DMN_RESULT);
        for (ScenarioExpect output : scenarioRunnerData.getExpects()) {
            FactIdentifier factIdentifier = output.getFactIdentifier();
            String decisionName = factIdentifier.getName();
            DMNDecisionResult decisionResult = dmnResult.getDecisionResultByName(decisionName);
            if (decisionResult == null) {
                throw new ScenarioException("DMN execution has not generated a decision result with name " + decisionName);
            }
            for (FactMappingValue expectedResult : output.getExpectedResult()) {
                ExpressionIdentifier expressionIdentifier = expectedResult.getExpressionIdentifier();
                FactMapping factMapping = (FactMapping)simulationDescriptor.getFactMapping(factIdentifier, expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
                ScenarioResult scenarioResult = this.fillResult(expectedResult, factIdentifier, () -> this.getSingleFactValueResult(factMapping, expectedResult, decisionResult, expressionEvaluator));
                scenarioRunnerData.addResult(scenarioResult);
            }
        }
    }

    protected ResultWrapper getSingleFactValueResult(FactMapping factMapping, FactMappingValue expectedResult, DMNDecisionResult decisionResult, ExpressionEvaluator expressionEvaluator) {
        Object resultRaw = decisionResult.getResult();
        if (!DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED.equals((Object)decisionResult.getEvaluationStatus())) {
            return ResultWrapper.createErrorResult();
        }
        for (ExpressionElement expressionElement : factMapping.getExpressionElementsWithoutClass()) {
            if (!(resultRaw instanceof Map)) {
                throw new ScenarioException("Wrong resultRaw structure because it is not a complex type as expected");
            }
            Map result = (Map)resultRaw;
            resultRaw = result.get(expressionElement.getStep());
        }
        Class<?> resultClass = resultRaw != null ? resultRaw.getClass() : null;
        try {
            return expressionEvaluator.evaluate(expectedResult.getRawValue(), resultRaw, resultClass) ? ResultWrapper.createResult(resultRaw) : ResultWrapper.createErrorResult();
        }
        catch (Exception e) {
            expectedResult.setError(true);
            throw new ScenarioException(e.getMessage(), e);
        }
    }

    @Override
    public Object createObject(String className, Map<List<String>, Object> params, ClassLoader classLoader) {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        for (Map.Entry<List<String>, Object> listObjectEntry : params.entrySet()) {
            List<String> allSteps = listObjectEntry.getKey();
            List<String> steps = allSteps.subList(0, allSteps.size() - 1);
            String lastStep = allSteps.get(allSteps.size() - 1);
            Map<String, Object> targetMap = toReturn;
            for (String step : steps) {
                targetMap = (Map)targetMap.computeIfAbsent(step, k -> new HashMap());
            }
            targetMap.put(lastStep, listObjectEntry.getValue());
        }
        return toReturn;
    }
}

