/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.expression;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.AbstractExpressionEvaluator;
import org.junit.Assert;
import org.junit.Test;

public class AbstractExpressionEvaluatorTest {
    JsonNodeFactory factory = JsonNodeFactory.instance;
    AbstractExpressionEvaluator expressionEvaluatorMock = new AbstractExpressionEvaluator(){

        public boolean evaluate(Object rawExpression, Object resultValue, Class<?> resultClass) {
            throw new UnsupportedOperationException();
        }

        public Object getValueForGiven(String className, List<String> genericClasses, Object raw) {
            throw new UnsupportedOperationException();
        }

        protected Object extractFieldValue(Object result, String fieldName) {
            return result;
        }

        protected boolean internalUnaryEvaluation(String rawExpression, Object resultValue, Class<?> resultClass, boolean skipEmptyString) {
            return true;
        }

        protected Object internalLiteralEvaluate(String raw, String className) {
            return raw;
        }

        protected Object createObject(String className, List<String> genericClasses) {
            return new HashMap();
        }

        protected void setField(Object toReturn, String fieldName, Object fieldValue) {
            ((Map)toReturn).put(fieldName, fieldValue);
        }

        protected Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object element, String fieldName, String className, List<String> genericClasses) {
            return new AbstractMap.SimpleEntry<String, List<String>>("", Collections.singletonList(""));
        }
    };

    @Test
    public void convertList() {
        ArrayNode jsonNodes = new ArrayNode(this.factory);
        ObjectNode objectNode = new ObjectNode(this.factory);
        objectNode.put("value", "data");
        jsonNodes.add((JsonNode)objectNode);
        List objects = this.expressionEvaluatorMock.createAndFillList(jsonNodes, new ArrayList(), List.class.getCanonicalName(), Collections.singletonList(String.class.getCanonicalName()));
        Assert.assertEquals((Object)"data", objects.get(0));
    }

    @Test
    public void convertObject() {
        ObjectNode objectNode = new ObjectNode(this.factory);
        objectNode.put("age", "1");
        Object result = this.expressionEvaluatorMock.createAndFillObject(objectNode, new HashMap(), Map.class.getCanonicalName(), Collections.singletonList(String.class.getCanonicalName()));
        Assert.assertTrue((boolean)(result instanceof Map));
        Map resultMap = (Map)result;
        Assert.assertEquals((Object)"1", resultMap.get("age"));
        objectNode.removeAll();
        ObjectNode nestedObject = new ObjectNode(this.factory);
        objectNode.set("nested", (JsonNode)nestedObject);
        nestedObject.put("field", "fieldValue");
        result = this.expressionEvaluatorMock.createAndFillObject(objectNode, new HashMap(), String.class.getCanonicalName(), Collections.emptyList());
        Assert.assertTrue((boolean)(result instanceof Map));
        resultMap = (Map)result;
        Assert.assertEquals((long)1L, (long)resultMap.size());
        Map nested = (Map)resultMap.get("nested");
        Assert.assertEquals((long)1L, (long)nested.size());
        Assert.assertEquals((Object)"fieldValue", nested.get("field"));
        objectNode.removeAll();
        ArrayNode jsonNodes = new ArrayNode(this.factory);
        objectNode.set("listField", (JsonNode)jsonNodes);
        jsonNodes.add((JsonNode)nestedObject);
        result = this.expressionEvaluatorMock.createAndFillObject(objectNode, new HashMap(), String.class.getCanonicalName(), Collections.emptyList());
        Assert.assertTrue((boolean)(result instanceof Map));
        resultMap = (Map)result;
        Assert.assertEquals((long)1L, (long)resultMap.size());
        List nestedList = (List)resultMap.get("listField");
        Assert.assertEquals((long)1L, (long)nestedList.size());
        Assert.assertEquals((Object)"fieldValue", ((Map)nestedList.get(0)).get("field"));
    }
}

