/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.expression;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.AbstractExpressionEvaluator;
import org.kie.dmn.feel.FEEL;
import org.kie.dmn.feel.lang.EvaluationContext;
import org.kie.dmn.feel.lang.impl.EvaluationContextImpl;
import org.kie.dmn.feel.lang.impl.FEELEventListenersManager;

public class DMNFeelExpressionEvaluator
extends AbstractExpressionEvaluator {
    private final FEEL feel = FEEL.newInstance();
    private final ClassLoader classLoader;

    public DMNFeelExpressionEvaluator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public boolean evaluate(Object rawExpression, Object resultValue, Class<?> resultClass) {
        if (rawExpression != null && !(rawExpression instanceof String)) {
            throw new IllegalArgumentException("Raw expression should be a string");
        }
        return this.internalEvaluate(rawExpression, resultValue, resultClass);
    }

    @Override
    public Object getValueForGiven(String className, List<String> genericClasses, Object raw) {
        if (!(raw instanceof String)) {
            return raw;
        }
        return this.internalGetValueForGiven(className, genericClasses, (String)raw);
    }

    private EvaluationContext newEvaluationContext() {
        return new EvaluationContextImpl(this.classLoader, new FEELEventListenersManager());
    }

    @Override
    protected Object internalLiteralEvaluate(String raw, String className) {
        EvaluationContext evaluationContext = this.newEvaluationContext();
        return this.feel.evaluate(raw, evaluationContext);
    }

    @Override
    protected boolean internalUnaryEvaluation(String rawExpression, Object resultValue, Class<?> resultClass, boolean skipEmptyString) {
        if (rawExpression != null && skipEmptyString && rawExpression.isEmpty()) {
            return true;
        }
        EvaluationContext evaluationContext = this.newEvaluationContext();
        List unaryTests = this.feel.evaluateUnaryTests(rawExpression);
        if (unaryTests.size() < 1) {
            throw new IllegalArgumentException("Impossible to parse the expression '" + rawExpression + "'");
        }
        return unaryTests.stream().allMatch(unaryTest -> (Boolean)unaryTest.apply((Object)evaluationContext, resultValue));
    }

    @Override
    protected Object extractFieldValue(Object result, String fieldName) {
        return ((Map)result).get(fieldName);
    }

    @Override
    protected Object createObject(String className, List<String> genericClasses) {
        return new HashMap();
    }

    @Override
    protected void setField(Object toReturn, String fieldName, Object fieldValue) {
        Map returnMap = (Map)toReturn;
        returnMap.put(fieldName, fieldValue);
    }

    @Override
    protected Map.Entry<String, List<String>> getFieldClassNameAndGenerics(Object element, String fieldName, String className, List<String> genericClasses) {
        return new AbstractMap.SimpleEntry<String, List<String>>("", Collections.singletonList(""));
    }
}

