/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.fluent.RuleScenarioExecutableBuilder;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.AbstractRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ResultWrapper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioExpect;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioGiven;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ScenarioBeanUtil;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ScenarioBeanWrapper;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionElement;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;

public class RuleScenarioRunnerHelper
extends AbstractRunnerHelper {
    private final SimulationDescriptor simulationDescriptor;

    public RuleScenarioRunnerHelper(SimulationDescriptor simulationDescriptor) {
        this.simulationDescriptor = simulationDescriptor;
    }

    @Override
    public RequestContext executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluator expressionEvaluator, SimulationDescriptor simulationDescriptor) {
        if (!ScenarioSimulationModel.Type.RULE.equals((Object)simulationDescriptor.getType())) {
            throw new ScenarioException("Impossible to run a not-RULE simulation with RULE runner");
        }
        RuleScenarioExecutableBuilder ruleScenarioExecutableBuilder = RuleScenarioExecutableBuilder.createBuilder(kieContainer);
        scenarioRunnerData.getGivens().stream().map(ScenarioGiven::getValue).forEach(ruleScenarioExecutableBuilder::insert);
        scenarioRunnerData.getExpects().stream().filter(ScenarioExpect::isNewFact).flatMap(output -> output.getExpectedResult().stream().map(factMappingValue -> new ScenarioResult(output.getFactIdentifier(), (FactMappingValue)factMappingValue))).forEach(scenarioResult -> {
            Class clazz = ScenarioBeanUtil.loadClass(scenarioResult.getFactIdentifier().getClassName(), kieContainer.getClassLoader());
            scenarioRunnerData.addResult((ScenarioResult)scenarioResult);
            ruleScenarioExecutableBuilder.addInternalCondition(clazz, this.createExtractorFunction(expressionEvaluator, scenarioResult.getFactMappingValue(), simulationDescriptor), (ScenarioResult)scenarioResult);
        });
        return ruleScenarioExecutableBuilder.run();
    }

    @Override
    public void verifyConditions(SimulationDescriptor simulationDescriptor, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluator expressionEvaluator, RequestContext requestContext) {
        for (ScenarioGiven input : scenarioRunnerData.getGivens()) {
            FactIdentifier factIdentifier = input.getFactIdentifier();
            List<ScenarioExpect> assertionOnFact = scenarioRunnerData.getExpects().stream().filter(elem -> !elem.isNewFact()).filter(elem -> Objects.equals(elem.getFactIdentifier(), factIdentifier)).collect(Collectors.toList());
            if (assertionOnFact.size() < 1) continue;
            this.getScenarioResultsFromGivenFacts(simulationDescriptor, assertionOnFact, input, expressionEvaluator).forEach(scenarioRunnerData::addResult);
        }
    }

    protected List<ScenarioResult> getScenarioResultsFromGivenFacts(SimulationDescriptor simulationDescriptor, List<ScenarioExpect> scenarioOutputsPerFact, ScenarioGiven input, ExpressionEvaluator expressionEvaluator) {
        FactIdentifier factIdentifier = input.getFactIdentifier();
        Object factInstance = input.getValue();
        ArrayList<ScenarioResult> scenarioResults = new ArrayList<ScenarioResult>();
        for (ScenarioExpect scenarioExpect : scenarioOutputsPerFact) {
            if (scenarioExpect.isNewFact()) continue;
            for (FactMappingValue expectedResult : scenarioExpect.getExpectedResult()) {
                ScenarioResult scenarioResult = this.fillResult(expectedResult, factIdentifier, () -> this.createExtractorFunction(expressionEvaluator, expectedResult, simulationDescriptor).apply(factInstance));
                scenarioResults.add(scenarioResult);
            }
        }
        return scenarioResults;
    }

    protected Function<Object, ResultWrapper> createExtractorFunction(ExpressionEvaluator expressionEvaluator, FactMappingValue expectedResult, SimulationDescriptor simulationDescriptor) {
        return objectToCheck -> {
            ExpressionIdentifier expressionIdentifier = expectedResult.getExpressionIdentifier();
            FactMapping factMapping = (FactMapping)simulationDescriptor.getFactMapping(expectedResult.getFactIdentifier(), expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
            List<String> pathToValue = factMapping.getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList());
            ScenarioBeanWrapper<?> scenarioBeanWrapper = ScenarioBeanUtil.navigateToObject(objectToCheck, pathToValue, false);
            Object resultValue = scenarioBeanWrapper.getBean();
            try {
                return expressionEvaluator.evaluate(expectedResult.getRawValue(), resultValue, scenarioBeanWrapper.getBeanClass()) ? ResultWrapper.createResult(resultValue) : ResultWrapper.createErrorResult();
            }
            catch (Exception e) {
                expectedResult.setError(true);
                throw new ScenarioException(e.getMessage(), e);
            }
        };
    }

    @Override
    public Object createObject(String className, Map<List<String>, Object> params, ClassLoader classLoader) {
        return ScenarioBeanUtil.fillBean(className, params, classLoader);
    }
}

