/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationXMLPersistence;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ResourceHelper;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.junit.Assert;
import org.junit.Test;
import org.kie.soup.project.datamodel.imports.Import;

public class ScenarioSimulationXMLPersistenceTest {
    ScenarioSimulationXMLPersistence instance = ScenarioSimulationXMLPersistence.getInstance();

    @Test
    public void noFQCNUsed() throws Exception {
        ScenarioSimulationModel simulationModel = new ScenarioSimulationModel();
        simulationModel.getImports().addImport(new Import("org.test.Test"));
        String xml = this.instance.marshal(simulationModel);
        Assert.assertFalse((boolean)xml.contains("org.drools.workbench.screens.scenariosimulation.model"));
        Assert.assertFalse((boolean)xml.contains("org.kie.soup.project.datamodel.imports"));
    }

    @Test
    public void versionAttributeExists() throws Exception {
        String xml = this.instance.marshal(new ScenarioSimulationModel());
        Assert.assertTrue((boolean)xml.startsWith("<ScenarioSimulationModel version=\"" + ScenarioSimulationXMLPersistence.getCurrentVersion() + "\">"));
    }

    @Test
    public void migrateIfNecessary_1_0_to_1_1() throws Exception {
        String toMigrate = this.getFileContent("scesim-1-0.scesim");
        String migrated = this.instance.migrateIfNecessary(toMigrate);
        Assert.assertTrue((boolean)toMigrate.contains("<ScenarioSimulationModel version=\"1.0\">"));
        Assert.assertFalse((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.0\">"));
        Assert.assertTrue((boolean)migrated.contains("EXPECT"));
        Assert.assertFalse((boolean)migrated.contains("EXPECTED"));
    }

    @Test
    public void migrateIfNecessary_1_1_to_1_2() throws Exception {
        String toMigrate = this.getFileContent("scesim-1-1.scesim");
        String migrated = this.instance.migrateIfNecessary(toMigrate);
        Assert.assertTrue((boolean)toMigrate.contains("<ScenarioSimulationModel version=\"1.1\">"));
        Assert.assertFalse((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.1\">"));
        Assert.assertTrue((boolean)migrated.contains("dmoSession></dmoSession>"));
        Assert.assertTrue((boolean)migrated.contains("<type>RULE</type>"));
    }

    @Test
    public void migrateIfNecessary_1_2_to_1_3() throws Exception {
        String toMigrate = this.getFileContent("scesim-1-2.scesim");
        String migrated = this.instance.migrateIfNecessary(toMigrate);
        Assert.assertTrue((boolean)toMigrate.contains("<ScenarioSimulationModel version=\"1.2\">"));
        Assert.assertFalse((boolean)migrated.contains("<ScenarioSimulationModel version=\"1.2\">"));
        for (FactMapping factMapping : this.instance.unmarshal(migrated, false).getSimulation().getSimulationDescriptor().getUnmodifiableFactMappings()) {
            Assert.assertTrue((factMapping.getExpressionElements().size() >= 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void migrateIfNecessary() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.instance.migrateIfNecessary("<ScenarioSimulationModel version=\"9999999999.99999999999\">")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Version 9999999999.99999999999 of the file is not supported. Current version is " + ScenarioSimulationXMLPersistence.getCurrentVersion());
        String noMigrationNeeded = "<ScenarioSimulationModel version=\"" + ScenarioSimulationXMLPersistence.getCurrentVersion() + "\">";
        String afterMigration = this.instance.migrateIfNecessary(noMigrationNeeded);
        Assert.assertEquals((Object)noMigrationNeeded, (Object)afterMigration);
    }

    @Test
    public void extractVersion() {
        String version = this.instance.extractVersion("<ScenarioSimulationModel version=\"1.0\" version=\"1.1\">");
        Assert.assertEquals((Object)"1.0", (Object)version);
    }

    @Test
    public void unmarshalRULE() throws Exception {
        String toUnmarshal = this.getFileContent("scesim-rule.scesim");
        ScenarioSimulationModel retrieved = ScenarioSimulationXMLPersistence.getInstance().unmarshal(toUnmarshal);
        Assert.assertEquals((Object)retrieved.getSimulation().getSimulationDescriptor().getType(), (Object)ScenarioSimulationModel.Type.RULE);
        Assert.assertNotNull((Object)retrieved.getSimulation().getSimulationDescriptor().getDmoSession());
        Assert.assertNull((Object)retrieved.getSimulation().getSimulationDescriptor().getDmnFilePath());
    }

    @Test
    public void unmarshalDMN() throws Exception {
        String toUnmarshal = this.getFileContent("scesim-dmn.scesim");
        ScenarioSimulationModel retrieved = ScenarioSimulationXMLPersistence.getInstance().unmarshal(toUnmarshal);
        Assert.assertEquals((Object)retrieved.getSimulation().getSimulationDescriptor().getType(), (Object)ScenarioSimulationModel.Type.DMN);
        Assert.assertNotNull((Object)retrieved.getSimulation().getSimulationDescriptor().getDmnFilePath());
        Assert.assertNull((Object)retrieved.getSimulation().getSimulationDescriptor().getDmoSession());
    }

    private String getFileContent(String fileName) throws IOException {
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        String filePath = ResourceHelper.getResourcesByExtension((String)extension).filter(path -> path.endsWith(fileName)).findFirst().orElse(null);
        Assert.assertNotNull((Object)filePath);
        File sourceFile = new File(filePath);
        Assert.assertTrue((boolean)sourceFile.exists());
        return new String(Files.readAllBytes(sourceFile.toPath()));
    }
}

