/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.expression;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.BaseExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.ListMapClass;
import org.junit.Assert;
import org.junit.Test;

public class BaseExpressionEvaluatorTest {
    private static final ClassLoader classLoader = BaseExpressionEvaluatorTest.class.getClassLoader();

    @Test
    public void getValueForGiven() {
        BaseExpressionEvaluator baseExpressionEvaluator = new BaseExpressionEvaluator(classLoader);
        Object raw = new Object();
        Assert.assertEquals((Object)raw, (Object)baseExpressionEvaluator.getValueForGiven(Object.class.getCanonicalName(), Collections.emptyList(), raw));
        raw = "SimpleString";
        Assert.assertEquals((Object)raw, (Object)baseExpressionEvaluator.getValueForGiven(String.class.getCanonicalName(), Collections.emptyList(), raw));
        raw = "= SimpleString";
        Assert.assertEquals((Object)"SimpleString", (Object)baseExpressionEvaluator.getValueForGiven(String.class.getCanonicalName(), Collections.emptyList(), raw));
        Assert.assertNull((Object)baseExpressionEvaluator.getValueForGiven(String.class.getCanonicalName(), Collections.emptyList(), null));
    }

    @Test
    public void expressionTest() {
        BaseExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(classLoader);
        String listJsonString = "[{\"name\": \"John\"}, {\"name\": \"John\", \"names\" : [{\"value\": \"Anna\"}, {\"value\": \"Mario\"}]}]";
        List parsedValue = (List)expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assert.assertEquals((long)2L, (long)parsedValue.size());
        Assert.assertEquals((long)2L, (long)((ListMapClass)parsedValue.get(1)).getNames().size());
        Assert.assertTrue((boolean)((ListMapClass)parsedValue.get(1)).getNames().contains("Anna"));
        String mapJsonString = "{\"first\": {\"name\": \"John\"}}";
        Map parsedMap = (Map)expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)"John", (Object)((ListMapClass)parsedMap.get("first")).getName());
        mapJsonString = "{\"first\": {\"siblings\": [{\"name\" : \"John\"}]}}";
        parsedMap = (Map)expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)"John", (Object)((ListMapClass)parsedMap.get("first")).getSiblings().get(0).getName());
        mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"1\"}}}";
        parsedMap = (Map)expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Collections.singletonList(ListMapClass.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)1, (Object)((ListMapClass)parsedMap.get("first")).getPhones().get("number"));
    }
}

