/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.BaseExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.Dispute;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.Person;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.RuleScenarioRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ResultWrapper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioExpect;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioGiven;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RuleScenarioRunnerHelperTest {
    private static final String NAME = "NAME";
    private static final double AMOUNT = 10.0;
    private static final String TEST_DESCRIPTION = "Test description";
    private static final ClassLoader classLoader = RuleScenarioRunnerHelperTest.class.getClassLoader();
    private static final ExpressionEvaluator expressionEvaluator = new BaseExpressionEvaluator(classLoader);
    private static final RuleScenarioRunnerHelper runnerHelper = new RuleScenarioRunnerHelper(null);
    private Simulation simulation;
    private FactIdentifier personFactIdentifier;
    private ExpressionIdentifier firstNameGivenExpressionIdentifier;
    private FactMapping firstNameGivenFactMapping;
    private Scenario scenario1;
    private Scenario scenario2;
    private ExpressionIdentifier firstNameExpectedExpressionIdentifier;
    private FactMapping firstNameExpectedFactMapping;
    private FactIdentifier disputeFactIdentifier;
    private ExpressionIdentifier amountGivenExpressionIdentifier;
    private FactMapping amountNameGivenFactMapping;
    private ExpressionIdentifier amountExpectedExpressionIdentifier;
    private FactMapping amountNameExpectedFactMapping;
    private FactMappingValue amountNameExpectedFactMappingValue;

    @Before
    public void setup() {
        this.simulation = new Simulation();
        this.personFactIdentifier = FactIdentifier.create((String)"Fact 1", (String)Person.class.getCanonicalName());
        this.firstNameGivenExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Given", (FactMappingType)FactMappingType.GIVEN);
        this.firstNameGivenFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.firstNameGivenFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.disputeFactIdentifier = FactIdentifier.create((String)"Fact 2", (String)Dispute.class.getCanonicalName());
        this.amountGivenExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Given", (FactMappingType)FactMappingType.GIVEN);
        this.amountNameGivenFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.amountNameGivenFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameGivenFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.firstNameExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Expected", (FactMappingType)FactMappingType.EXPECT);
        this.firstNameExpectedFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier);
        this.firstNameExpectedFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameExpectedFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.amountExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Expected", (FactMappingType)FactMappingType.EXPECT);
        this.amountNameExpectedFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier);
        this.amountNameExpectedFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameExpectedFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.scenario1 = this.simulation.addScenario();
        this.scenario1.setDescription(TEST_DESCRIPTION);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        this.scenario2 = this.simulation.addScenario();
        this.scenario2.setDescription(TEST_DESCRIPTION);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)NAME);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)NAME);
        this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)10.0);
        this.amountNameExpectedFactMappingValue = this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier, (Object)10.0);
    }

    @Test
    public void extractGivenValuesTest() {
        List scenario1Inputs = runnerHelper.extractGivenValues(this.simulation.getSimulationDescriptor(), this.scenario1.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenario1Inputs.size());
        List scenario2Inputs = runnerHelper.extractGivenValues(this.simulation.getSimulationDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluator);
        Assert.assertEquals((long)2L, (long)scenario2Inputs.size());
    }

    @Test
    public void extractExpectedValuesTest() {
        List scenario1Outputs = runnerHelper.extractExpectedValues(this.scenario1.getUnmodifiableFactMappingValues());
        Assert.assertEquals((long)1L, (long)scenario1Outputs.size());
        this.scenario2.addOrUpdateMappingValue(FactIdentifier.create((String)"TEST", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"TEST", (FactMappingType)FactMappingType.EXPECT), (Object)"TEST");
        List scenario2Outputs = runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        Assert.assertEquals((long)3L, (long)scenario2Outputs.size());
        Assert.assertEquals((long)1L, (long)scenario2Outputs.stream().filter(ScenarioExpect::isNewFact).count());
    }

    @Test
    public void verifyConditionsTest() {
        List scenario1Inputs = runnerHelper.extractGivenValues(this.simulation.getSimulationDescriptor(), this.scenario1.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluator);
        List scenario1Outputs = runnerHelper.extractExpectedValues(this.scenario1.getUnmodifiableFactMappingValues());
        ScenarioRunnerData scenarioRunnerData1 = new ScenarioRunnerData();
        scenario1Inputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData1).addGiven(arg_0));
        scenario1Outputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData1).addExpect(arg_0));
        runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData1, expressionEvaluator, null);
        Assert.assertEquals((long)1L, (long)scenarioRunnerData1.getResults().size());
        List scenario2Inputs = runnerHelper.extractGivenValues(this.simulation.getSimulationDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluator);
        List scenario2Outputs = runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        ScenarioRunnerData scenarioRunnerData2 = new ScenarioRunnerData();
        scenario2Inputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData2).addGiven(arg_0));
        scenario2Outputs.forEach(arg_0 -> ((ScenarioRunnerData)scenarioRunnerData2).addExpect(arg_0));
        runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData2, expressionEvaluator, null);
        Assert.assertEquals((long)2L, (long)scenarioRunnerData2.getResults().size());
    }

    @Test
    public void getScenarioResultsTest() {
        List scenario1Inputs = runnerHelper.extractGivenValues(this.simulation.getSimulationDescriptor(), this.scenario1.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluator);
        List scenario1Outputs = runnerHelper.extractExpectedValues(this.scenario1.getUnmodifiableFactMappingValues());
        Assert.assertTrue((scenario1Inputs.size() > 0 ? 1 : 0) != 0);
        ScenarioGiven input1 = (ScenarioGiven)scenario1Inputs.get(0);
        scenario1Outputs = scenario1Outputs.stream().filter(elem -> elem.getFactIdentifier().equals((Object)input1.getFactIdentifier())).collect(Collectors.toList());
        List scenario1Results = runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getSimulationDescriptor(), scenario1Outputs, input1, expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenario1Results.size());
        Assert.assertFalse((boolean)((FactMappingValue)((ScenarioExpect)scenario1Outputs.get(0)).getExpectedResult().get(0)).isError());
        List scenario2Inputs = runnerHelper.extractGivenValues(this.simulation.getSimulationDescriptor(), this.scenario2.getUnmodifiableFactMappingValues(), classLoader, expressionEvaluator);
        List scenario2Outputs = runnerHelper.extractExpectedValues(this.scenario2.getUnmodifiableFactMappingValues());
        Assert.assertTrue((scenario2Inputs.size() > 0 ? 1 : 0) != 0);
        ScenarioGiven input2 = (ScenarioGiven)scenario2Inputs.get(0);
        scenario2Outputs = scenario2Outputs.stream().filter(elem -> elem.getFactIdentifier().equals((Object)input2.getFactIdentifier())).collect(Collectors.toList());
        List scenario2Results = runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getSimulationDescriptor(), scenario2Outputs, input2, expressionEvaluator);
        Assert.assertEquals((long)1L, (long)scenario2Results.size());
        Assert.assertFalse((boolean)((FactMappingValue)((ScenarioExpect)scenario2Outputs.get(0)).getExpectedResult().get(0)).isError());
        List<ScenarioExpect> newFact = Collections.singletonList(new ScenarioExpect(this.personFactIdentifier, Collections.emptyList(), true));
        List scenario2NoResults = runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getSimulationDescriptor(), newFact, input2, expressionEvaluator);
        Assert.assertEquals((long)0L, (long)scenario2NoResults.size());
        Person person = new Person();
        person.setFirstName("ANOTHER STRING");
        ScenarioGiven newInput = new ScenarioGiven(this.personFactIdentifier, (Object)person);
        List scenario3Results = runnerHelper.getScenarioResultsFromGivenFacts(this.simulation.getSimulationDescriptor(), scenario1Outputs, newInput, expressionEvaluator);
        Assert.assertTrue((boolean)((FactMappingValue)((ScenarioExpect)scenario1Outputs.get(0)).getExpectedResult().get(0)).isError());
        Assert.assertEquals((long)1L, (long)scenario3Results.size());
    }

    @Test
    public void validateAssertionTest() {
        ArrayList<ScenarioResult> scenarioFailResult = new ArrayList<ScenarioResult>();
        scenarioFailResult.add(new ScenarioResult(this.disputeFactIdentifier, this.amountNameExpectedFactMappingValue, (Object)"SOMETHING_ELSE"));
        try {
            runnerHelper.validateAssertion(scenarioFailResult, this.scenario2);
            Assert.fail();
        }
        catch (ScenarioException scenarioException) {
            // empty catch block
        }
        ArrayList<ScenarioResult> scenarioSuccessResult = new ArrayList<ScenarioResult>();
        scenarioSuccessResult.add(new ScenarioResult(this.disputeFactIdentifier, this.amountNameExpectedFactMappingValue, this.amountNameExpectedFactMappingValue.getRawValue()).setResult(true));
        runnerHelper.validateAssertion(scenarioSuccessResult, this.scenario2);
    }

    @Test
    public void groupByFactIdentifierAndFilterTest() {
        Map scenario1Given = runnerHelper.groupByFactIdentifierAndFilter(this.scenario1.getUnmodifiableFactMappingValues(), FactMappingType.GIVEN);
        Map scenario1Expected = runnerHelper.groupByFactIdentifierAndFilter(this.scenario1.getUnmodifiableFactMappingValues(), FactMappingType.EXPECT);
        Map scenario2Given = runnerHelper.groupByFactIdentifierAndFilter(this.scenario2.getUnmodifiableFactMappingValues(), FactMappingType.GIVEN);
        Map scenario2Expected = runnerHelper.groupByFactIdentifierAndFilter(this.scenario2.getUnmodifiableFactMappingValues(), FactMappingType.EXPECT);
        Assert.assertEquals((long)1L, (long)scenario1Given.keySet().size());
        Assert.assertEquals((long)1L, (long)scenario1Expected.keySet().size());
        Assert.assertEquals((long)2L, (long)scenario2Given.keySet().size());
        Assert.assertEquals((long)2L, (long)scenario2Expected.keySet().size());
        Assert.assertEquals((long)1L, (long)((List)scenario1Given.get(this.personFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario1Expected.get(this.personFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario2Given.get(this.disputeFactIdentifier)).size());
        Assert.assertEquals((long)1L, (long)((List)scenario2Expected.get(this.disputeFactIdentifier)).size());
        Scenario scenario = new Scenario();
        scenario.addMappingValue(FactIdentifier.EMPTY, ExpressionIdentifier.DESCRIPTION, null);
        Assert.assertEquals((long)0L, (long)runnerHelper.groupByFactIdentifierAndFilter(scenario.getUnmodifiableFactMappingValues(), FactMappingType.GIVEN).size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void groupByFactIdentifierAndFilterFailTest() {
        ArrayList<FactMappingValue> fail = new ArrayList<FactMappingValue>();
        FactMappingValue factMappingValue = new FactMappingValue();
        factMappingValue.setRawValue((Object)"TEST");
        fail.add(factMappingValue);
        runnerHelper.groupByFactIdentifierAndFilter(fail, FactMappingType.GIVEN);
    }

    @Test
    public void createExtractorFunctionTest() {
        String personName = "Test";
        FactMappingValue factMappingValue = new FactMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)personName);
        Function extractorFunction = runnerHelper.createExtractorFunction(expressionEvaluator, factMappingValue, this.simulation.getSimulationDescriptor());
        Person person = new Person();
        person.setFirstName(personName);
        Assert.assertTrue((boolean)((ResultWrapper)extractorFunction.apply(person)).isSatisfied());
        person.setFirstName("OtherString");
        Assert.assertFalse((boolean)((ResultWrapper)extractorFunction.apply(person)).isSatisfied());
        Function extractorFunction1 = runnerHelper.createExtractorFunction(expressionEvaluator, new FactMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, null), this.simulation.getSimulationDescriptor());
        ResultWrapper nullValue = (ResultWrapper)extractorFunction1.apply(new Person());
        Assert.assertTrue((boolean)nullValue.isSatisfied());
        Assert.assertNull((Object)nullValue.getResult());
    }

    @Test
    public void getParamsForBeanTest() {
        ArrayList<FactMappingValue> factMappingValues = new ArrayList<FactMappingValue>();
        FactMappingValue factMappingValue = new FactMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)"NOT PARSABLE");
        factMappingValues.add(factMappingValue);
        try {
            runnerHelper.getParamsForBean(this.simulation.getSimulationDescriptor(), this.disputeFactIdentifier, factMappingValues, expressionEvaluator);
            Assert.fail();
        }
        catch (ScenarioException scenarioException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)factMappingValue.isError());
    }

    @Test
    public void directMappingTest() {
        HashMap paramsToSet = new HashMap();
        paramsToSet.put(Collections.emptyList(), "Test");
        Assert.assertEquals((Object)"Test", (Object)runnerHelper.getDirectMapping(paramsToSet).getResult());
        paramsToSet.clear();
        paramsToSet.put(Collections.emptyList(), 1);
        Assert.assertEquals((Object)1, (Object)runnerHelper.getDirectMapping(paramsToSet).getResult());
        paramsToSet.clear();
        paramsToSet.put(Collections.emptyList(), null);
        Assert.assertNull((Object)runnerHelper.getDirectMapping(paramsToSet).getResult());
    }
}

