/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.util.List;
import java.util.stream.Stream;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationXMLPersistence;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.AbstractScenarioRunner;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioJunitActivator;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.SimulationWithFileName;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ResourceHelper;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.kie.api.runtime.KieContainer;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioJunitActivatorTest {
    @Mock
    private ScenarioSimulationXMLPersistence xmlReaderMock;
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private AbstractScenarioRunner runnerMock;
    @Mock
    private Simulation simulationMock;
    @Mock
    private SimulationWithFileName simulationWithFileNameMock;
    @Mock
    private ScenarioSimulationModel scenarioSimulationModelMock;
    @Mock
    private RunNotifier runNotifierMock;

    @Before
    public void setup() {
        Mockito.when((Object)this.xmlReaderMock.unmarshal((String)Matchers.any())).thenReturn((Object)this.scenarioSimulationModelMock);
        Mockito.when((Object)this.scenarioSimulationModelMock.getSimulation()).thenReturn((Object)this.simulationMock);
    }

    @Test
    public void getChildrenTest() throws InitializationError {
        List children = this.getScenarioJunitActivator().getChildren();
        Assert.assertEquals((long)1L, (long)children.size());
    }

    @Test
    public void runChildTest() throws InitializationError {
        this.getScenarioJunitActivator().runChild(this.simulationWithFileNameMock, this.runNotifierMock);
        ((AbstractScenarioRunner)Mockito.verify((Object)this.runnerMock, (VerificationMode)Mockito.times((int)1))).run(this.runNotifierMock);
    }

    private ScenarioJunitActivator getScenarioJunitActivator() throws InitializationError {
        return new ScenarioJunitActivator(ScenarioJunitActivator.class){

            ScenarioSimulationXMLPersistence getXmlReader() {
                return ScenarioJunitActivatorTest.this.xmlReaderMock;
            }

            Stream<String> getResources() {
                return ResourceHelper.getResourcesByExtension((String)"txt");
            }

            KieContainer getKieContainer() {
                return ScenarioJunitActivatorTest.this.kieContainerMock;
            }

            AbstractScenarioRunner newRunner(KieContainer kieContainer, Simulation simulation, String path) {
                return ScenarioJunitActivatorTest.this.runnerMock;
            }
        };
    }
}

