/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioSimulationXMLPersistence;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioJunitActivator;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ScenarioSimulationBuilder;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioRunnerService;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.drools.workbench.screens.scenariosimulation.type.ScenarioSimulationResourceTypeDefinition;
import org.guvnor.common.services.backend.config.SafeSessionInfo;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.guvnor.common.services.project.model.Dependencies;
import org.guvnor.common.services.project.model.Dependency;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.service.POMService;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.DataModelOracleUtilities;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.workbench.events.ResourceOpenedEvent;

@Service
@ApplicationScoped
public class ScenarioSimulationServiceImpl
extends KieService<ScenarioSimulationModelContent>
implements ScenarioSimulationService {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private CopyService copyService;
    @Inject
    private DeleteService deleteService;
    @Inject
    private RenameService renameService;
    @Inject
    private Event<ResourceOpenedEvent> resourceOpenedEvent;
    @Inject
    private ScenarioSimulationResourceTypeDefinition resourceTypeDefinition;
    @Inject
    private CommentedOptionFactory commentedOptionFactory;
    @Inject
    private SaveAndRenameServiceImpl<ScenarioSimulationModel, Metadata> saveAndRenameService;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private ScenarioRunnerService scenarioRunnerService;
    @Inject
    private User user;
    @Inject
    private POMService pomService;
    @Inject
    private KieModuleService kieModuleService;
    @Inject
    protected ScenarioSimulationBuilder scenarioSimulationBuilder;
    private SafeSessionInfo safeSessionInfo;
    private Properties props = new Properties();
    private static final String KIE_VERSION = "kie.version";
    private static final String junitActivatorPackageName = "testscenario";

    public ScenarioSimulationServiceImpl() {
        String propertyFileName = "kie.properties";
        try {
            this.props.load(ScenarioSimulationServiceImpl.class.getClassLoader().getResourceAsStream(propertyFileName));
        }
        catch (IOException e) {
            throw new IllegalStateException("Impossible to retrieve property file " + propertyFileName, e);
        }
    }

    @Inject
    public ScenarioSimulationServiceImpl(SessionInfo sessionInfo) {
        String propertyFileName = "kie.properties";
        try {
            this.props.load(ScenarioSimulationServiceImpl.class.getClassLoader().getResourceAsStream(propertyFileName));
        }
        catch (IOException e) {
            throw new IllegalStateException("Impossible to retrieve property file " + propertyFileName, e);
        }
        this.safeSessionInfo = new SafeSessionInfo(sessionInfo);
    }

    @PostConstruct
    public void init() {
        this.saveAndRenameService.init((SupportsSaveAndRename)this);
    }

    public Map<Integer, Scenario> runScenario(org.uberfire.backend.vfs.Path path, SimulationDescriptor simulationDescriptor, Map<Integer, Scenario> scenarioMap) {
        return this.scenarioRunnerService.runTest(this.user.getIdentifier(), path, simulationDescriptor, scenarioMap);
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, ScenarioSimulationModel content, String comment) {
        return this.create(context, fileName, content, comment, ScenarioSimulationModel.Type.RULE, "default");
    }

    public org.uberfire.backend.vfs.Path create(org.uberfire.backend.vfs.Path context, String fileName, ScenarioSimulationModel content, String comment, ScenarioSimulationModel.Type type, String value) {
        try {
            content.setSimulation(this.scenarioSimulationBuilder.createSimulation(context, type, value));
            Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
            org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
            if (this.ioService.exists(nioPath)) {
                throw new FileAlreadyExistsException(nioPath.toString());
            }
            this.ioService.write(nioPath, ScenarioSimulationXMLPersistence.getInstance().marshal(content), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            this.createActivatorIfNotExist(context);
            return newPath;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public ScenarioSimulationModel load(org.uberfire.backend.vfs.Path path) {
        try {
            String content = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
            return ScenarioSimulationXMLPersistence.getInstance().unmarshal(content);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected ScenarioSimulationModelContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        PackageDataModelOracle oracle = this.dataModelService.getDataModel(path);
        PackageDataModelOracleBaselinePayload dataModel = new PackageDataModelOracleBaselinePayload();
        HashSet consumedFQCNs = new HashSet();
        consumedFQCNs.addAll(oracle.getPackageGlobals().values());
        consumedFQCNs.addAll(oracle.getModuleCollectionTypes().entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (String)entry.getKey()).collect(Collectors.toSet()));
        DataModelOracleUtilities.populateDataModel((PackageDataModelOracle)oracle, (PackageDataModelOracleBaselinePayload)dataModel, consumedFQCNs);
        this.resourceOpenedEvent.fire((Object)new ResourceOpenedEvent(path, (SessionInfo)this.safeSessionInfo));
        return new ScenarioSimulationModelContent(this.load(path), overview, dataModel);
    }

    public org.uberfire.backend.vfs.Path save(org.uberfire.backend.vfs.Path resource, ScenarioSimulationModel content, Metadata metadata, String comment) {
        try {
            Metadata currentMetadata = this.metadataService.getMetadata(resource);
            this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)resource), ScenarioSimulationXMLPersistence.getInstance().marshal(content), this.metadataService.setUpAttributes(resource, metadata), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption(comment)});
            this.fireMetadataSocialEvents(resource, currentMetadata, metadata);
            this.createActivatorIfNotExist(resource);
            return resource;
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            this.deleteService.delete(path, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.renameService.rename(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String comment) {
        try {
            return this.copyService.copy(path, newName, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, org.uberfire.backend.vfs.Path targetDirectory, String comment) {
        try {
            return this.copyService.copy(path, newName, targetDirectory, comment);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public org.uberfire.backend.vfs.Path saveAndRename(org.uberfire.backend.vfs.Path path, String newFileName, Metadata metadata, ScenarioSimulationModel content, String comment) {
        return this.saveAndRenameService.saveAndRename(path, newFileName, (Object)metadata, (Object)content, comment);
    }

    protected void createActivatorIfNotExist(org.uberfire.backend.vfs.Path context) {
        KieModule kieModule = (KieModule)this.kieModuleService.resolveModule(context);
        Package junitActivatorPackage = this.getOrCreateJunitActivatorPackage(kieModule);
        Path activatorPath = this.getActivatorPath(junitActivatorPackage);
        if (!this.ioService.exists(activatorPath)) {
            this.ioService.write(activatorPath, ScenarioJunitActivator.ACTIVATOR_CLASS_CODE.apply(junitActivatorPackageName), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption("")});
            this.removeOldActivatorIfExists(kieModule);
        }
        this.ensureDependencies(kieModule);
    }

    protected Package getOrCreateJunitActivatorPackage(KieModule kieModule) {
        Package rootPackage = this.kieModuleService.resolveDefaultPackage((Module)kieModule);
        org.uberfire.backend.vfs.Path junitActivatorPackagePath = Paths.convert((Path)this.getJunitActivatorPackagePath(rootPackage));
        Package junitActivatorPackage = this.kieModuleService.resolvePackage(junitActivatorPackagePath);
        if (junitActivatorPackage == null) {
            junitActivatorPackage = this.kieModuleService.newPackage(rootPackage, junitActivatorPackageName);
        }
        return junitActivatorPackage;
    }

    protected void removeOldActivatorIfExists(KieModule kieModule) {
        String targetPackageName = kieModule.getPom().getGav().getGroupId();
        Optional<Package> packageFound = this.kieModuleService.resolvePackages((Module)kieModule).stream().filter(elem -> targetPackageName.equals(elem.getPackageName())).findFirst();
        packageFound.ifPresent(pkg -> {
            Path oldActivatorPath = this.getActivatorPath((Package)pkg);
            this.ioService.deleteIfExists(oldActivatorPath, new DeleteOption[0]);
        });
    }

    protected void ensureDependencies(KieModule module) {
        POM projectPom = module.getPom();
        Dependencies dependencies = projectPom.getDependencies();
        String kieVersion = this.props.getProperty(KIE_VERSION);
        boolean toSave = false;
        org.uberfire.backend.vfs.Path modulePomXMLPath = module.getPomXMLPath();
        for (GAV gav : this.getDependencies(kieVersion)) {
            toSave |= this.editPomIfNecessary(dependencies, gav);
        }
        if (toSave) {
            this.pomService.save(modulePomXMLPath, (Object)projectPom, null, "");
        }
    }

    protected boolean editPomIfNecessary(Dependencies dependencies, GAV gav) {
        Dependency scenarioDependency = new Dependency(gav);
        scenarioDependency.setScope("test");
        if (!dependencies.containsDependency(gav)) {
            dependencies.add(scenarioDependency);
            return true;
        }
        return false;
    }

    protected Path getActivatorPath(Package rootModulePackage) {
        return this.internalGetPath(rootModulePackage, "ScenarioJunitActivatorTest.java");
    }

    protected Path getJunitActivatorPackagePath(Package rootModulePackage) {
        return this.internalGetPath(rootModulePackage, junitActivatorPackageName);
    }

    protected List<GAV> getDependencies(String kieVersion) {
        return Arrays.asList(new GAV("org.drools", "drools-wb-scenario-simulation-editor-api", kieVersion), new GAV("org.drools", "drools-wb-scenario-simulation-editor-backend", kieVersion), new GAV("org.drools", "drools-compiler", kieVersion), new GAV("org.kie", "kie-dmn-feel", kieVersion), new GAV("org.kie", "kie-dmn-api", kieVersion), new GAV("org.kie", "kie-dmn-core", kieVersion));
    }

    private Path internalGetPath(Package pkg, String path) {
        Path packagePath = Paths.convert((org.uberfire.backend.vfs.Path)pkg.getPackageTestSrcPath());
        return packagePath.resolve(path);
    }
}

