/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.fluent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.drools.workbench.screens.scenariosimulation.backend.server.fluent.FactCheckerHandle;
import org.drools.workbench.screens.scenariosimulation.backend.server.fluent.ValidateFactCommand;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ResultWrapper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.RequestContext;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.builder.fluent.ExecutableBuilder;
import org.kie.internal.builder.fluent.KieSessionFluent;

public class RuleScenarioExecutableBuilder {
    public static String DEFAULT_APPLICATION = "defaultApplication";
    private final KieSessionFluent kieSessionFluent;
    private final ExecutableBuilder executableBuilder;
    private final Map<FactIdentifier, List<FactCheckerHandle>> internalConditions = new HashMap<FactIdentifier, List<FactCheckerHandle>>();
    private static BiFunction<String, KieContainer, KieContainer> forcePseudoClock = (sessionName, kc) -> {
        KieSessionModel kieSessionModel = kc.getKieSessionModel(sessionName);
        kieSessionModel.setClockType(ClockTypeOption.get((String)"pseudo"));
        return kc;
    };

    private RuleScenarioExecutableBuilder(KieContainer kieContainer, String name) {
        this.executableBuilder = ExecutableBuilder.create();
        this.kieSessionFluent = ((ExecutableBuilder)this.executableBuilder.newApplicationContext(name)).setKieContainer(kieContainer).newSessionCustomized(null, forcePseudoClock);
    }

    private RuleScenarioExecutableBuilder(KieContainer kieContainer) {
        this(kieContainer, DEFAULT_APPLICATION);
    }

    public static RuleScenarioExecutableBuilder createBuilder(KieContainer kieContainer, String name) {
        return new RuleScenarioExecutableBuilder(kieContainer, name);
    }

    public static RuleScenarioExecutableBuilder createBuilder(KieContainer kieContainer) {
        return new RuleScenarioExecutableBuilder(kieContainer);
    }

    public void addInternalCondition(Class<?> clazz, Function<Object, ResultWrapper> checkFunction, ScenarioResult scenarioResult) {
        this.internalConditions.computeIfAbsent(scenarioResult.getFactIdentifier(), key -> new ArrayList()).add(new FactCheckerHandle(clazz, checkFunction, scenarioResult));
    }

    public void insert(Object element) {
        this.kieSessionFluent.insert(element);
    }

    public RequestContext run() {
        Objects.requireNonNull(this.executableBuilder, "Executable builder is null, please invoke create(KieContainer, )");
        this.kieSessionFluent.fireAllRules();
        this.internalConditions.values().forEach(factToCheck -> {
            KieSessionFluent cfr_ignored_0 = (KieSessionFluent)this.kieSessionFluent.addCommand((ExecutableCommand)new ValidateFactCommand((List<FactCheckerHandle>)factToCheck));
        });
        ((ExecutableBuilder)this.kieSessionFluent.dispose()).end();
        return (RequestContext)ExecutableRunner.create().execute(this.executableBuilder.getExecutable());
    }
}

