/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.AbstractRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.DMNScenarioRunner;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.IndexedScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.RuleScenarioRunner;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioRunnerProvider;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.kie.api.runtime.KieContainer;

public abstract class AbstractScenarioRunner
extends Runner {
    protected final ClassLoader classLoader;
    protected final Function<ClassLoader, ExpressionEvaluator> expressionEvaluatorFactory;
    protected final Description desc;
    protected final KieContainer kieContainer;
    protected final SimulationDescriptor simulationDescriptor;
    protected Map<Integer, Scenario> scenarios;
    protected String fileName;

    public AbstractScenarioRunner(KieContainer kieContainer, Simulation simulation, String fileName, Function<ClassLoader, ExpressionEvaluator> expressionEvaluatorFactory) {
        this(kieContainer, simulation.getSimulationDescriptor(), simulation.getScenarioMap(), fileName, expressionEvaluatorFactory);
    }

    public AbstractScenarioRunner(KieContainer kieContainer, SimulationDescriptor simulationDescriptor, Map<Integer, Scenario> scenarios, String fileName, Function<ClassLoader, ExpressionEvaluator> expressionEvaluatorFactory) {
        this.kieContainer = kieContainer;
        this.simulationDescriptor = simulationDescriptor;
        this.scenarios = scenarios;
        this.fileName = fileName;
        this.desc = AbstractScenarioRunner.getDescriptionForSimulation(this.getFileName(), simulationDescriptor, scenarios);
        this.classLoader = kieContainer.getClassLoader();
        this.expressionEvaluatorFactory = expressionEvaluatorFactory;
    }

    public void run(RunNotifier notifier) {
        notifier.fireTestStarted(this.getDescription());
        for (Map.Entry<Integer, Scenario> integerScenarioEntry : this.scenarios.entrySet()) {
            Scenario scenario = integerScenarioEntry.getValue();
            Integer index = integerScenarioEntry.getKey();
            this.singleRunScenario(index, scenario, notifier);
        }
        notifier.fireTestStarted(this.getDescription());
    }

    public Description getDescription() {
        return this.desc;
    }

    protected List<ScenarioResult> singleRunScenario(int index, Scenario scenario, RunNotifier runNotifier) {
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        Description descriptionForScenario = AbstractScenarioRunner.getDescriptionForScenario(this.getFileName(), index, scenario);
        runNotifier.fireTestStarted(descriptionForScenario);
        try {
            this.internalRunScenario(scenario, scenarioRunnerData);
        }
        catch (ScenarioException e) {
            IndexedScenarioException indexedScenarioException = new IndexedScenarioException(index, (Throwable)e);
            indexedScenarioException.setFileName(this.fileName);
            runNotifier.fireTestFailure(new Failure(descriptionForScenario, (Throwable)indexedScenarioException));
        }
        catch (Throwable e) {
            IndexedScenarioException indexedScenarioException = new IndexedScenarioException(index, "Unexpected test error in scenario '" + scenario.getDescription() + "'", e);
            indexedScenarioException.setFileName(this.fileName);
            runNotifier.fireTestFailure(new Failure(descriptionForScenario, (Throwable)indexedScenarioException));
        }
        runNotifier.fireTestFinished(descriptionForScenario);
        return scenarioRunnerData.getResults();
    }

    protected void internalRunScenario(Scenario scenario, ScenarioRunnerData scenarioRunnerData) {
        ExpressionEvaluator expressionEvaluator = this.createExpressionEvaluator();
        this.newRunnerHelper(this.getSimulationDescriptor()).run(this.getKieContainer(), this.getSimulationDescriptor(), scenario, expressionEvaluator, this.getClassLoader(), scenarioRunnerData);
    }

    public ExpressionEvaluator createExpressionEvaluator() {
        return this.expressionEvaluatorFactory.apply(this.classLoader);
    }

    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public KieContainer getKieContainer() {
        return this.kieContainer;
    }

    public SimulationDescriptor getSimulationDescriptor() {
        return this.simulationDescriptor;
    }

    public static Description getDescriptionForSimulation(Optional<String> filename, Simulation simulation) {
        return AbstractScenarioRunner.getDescriptionForSimulation(filename, simulation.getSimulationDescriptor(), simulation.getScenarioMap());
    }

    public static Description getDescriptionForSimulation(Optional<String> filename, SimulationDescriptor simulationDescriptor, Map<Integer, Scenario> scenarios) {
        Description suiteDescription = Description.createSuiteDescription((String)"Test Scenarios (Preview) tests", (Annotation[])new Annotation[0]);
        scenarios.forEach((index, scenario) -> suiteDescription.addChild(AbstractScenarioRunner.getDescriptionForScenario(filename, index, scenario)));
        return suiteDescription;
    }

    public static Description getDescriptionForScenario(Optional<String> className, int index, Scenario scenario) {
        return Description.createTestDescription((String)className.orElse(AbstractScenarioRunner.class.getCanonicalName()), (String)String.format("#%d: %s", index, scenario.getDescription()), (Annotation[])new Annotation[0]);
    }

    public static ScenarioRunnerProvider getSpecificRunnerProvider(SimulationDescriptor simulationDescriptor) {
        if (ScenarioSimulationModel.Type.RULE.equals((Object)simulationDescriptor.getType())) {
            return RuleScenarioRunner::new;
        }
        if (ScenarioSimulationModel.Type.DMN.equals((Object)simulationDescriptor.getType())) {
            return DMNScenarioRunner::new;
        }
        throw new IllegalArgumentException("Impossible to run simulation of type " + simulationDescriptor.getType());
    }

    protected abstract AbstractRunnerHelper newRunnerHelper(SimulationDescriptor var1);
}

