/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.SimulationCreationStrategy;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.drools.workbench.screens.scenariosimulation.utils.ScenarioSimulationSharedUtils;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class DMNSimulationCreationStrategy
implements SimulationCreationStrategy {
    @Inject
    protected DMNTypeService dmnTypeService;

    @Override
    public Simulation createSimulation(Path context, String dmnFilePath) throws Exception {
        FactModelTuple factModelTuple = this.getFactModelTuple(context, dmnFilePath);
        Simulation toReturn = new Simulation();
        SimulationDescriptor simulationDescriptor = toReturn.getSimulationDescriptor();
        simulationDescriptor.setType(ScenarioSimulationModel.Type.DMN);
        simulationDescriptor.setDmnFilePath(dmnFilePath);
        Scenario scenario = this.createScenario(toReturn, simulationDescriptor);
        int row = toReturn.getUnmodifiableScenarios().indexOf(scenario);
        AtomicInteger id = new AtomicInteger(1);
        Collection visibleFactTrees = factModelTuple.getVisibleFacts().values();
        SortedMap hiddenValues = factModelTuple.getHiddenFacts();
        visibleFactTrees.stream().sorted((a, b) -> {
            FactModelTree.Type bType;
            FactModelTree.Type aType = a.getType();
            return aType.equals((Object)(bType = b.getType())) ? 0 : (FactModelTree.Type.INPUT.equals((Object)aType) ? -1 : 1);
        }).forEach(factModelTree -> {
            FactIdentifier factIdentifier = new FactIdentifier(factModelTree.getFactName(), factModelTree.getFactName());
            FactMappingExtractor factMappingExtractor = new FactMappingExtractor(factIdentifier, row, id, DMNSimulationCreationStrategy.convert(factModelTree.getType()), simulationDescriptor, scenario);
            this.addToScenario(factMappingExtractor, (FactModelTree)factModelTree, (List<String>)new ArrayList<String>(), hiddenValues);
        });
        return toReturn;
    }

    protected FactModelTuple getFactModelTuple(Path context, String dmnFilePath) throws Exception {
        return this.dmnTypeService.retrieveType(context, dmnFilePath);
    }

    private void addToScenario(FactMappingExtractor factMappingExtractor, FactModelTree factModelTree, List<String> previousSteps, Map<String, FactModelTree> hiddenValues) {
        if (factModelTree.isSimple()) {
            String factType = (String)factModelTree.getSimpleProperties().get("value");
            factMappingExtractor.getFactMapping(factModelTree, "value", previousSteps, factType);
        } else {
            for (Map.Entry entry : factModelTree.getSimpleProperties().entrySet()) {
                String factName = (String)entry.getKey();
                String factType = (String)entry.getValue();
                FactMapping factMapping = factMappingExtractor.getFactMapping(factModelTree, factName, previousSteps, factType);
                if (ScenarioSimulationSharedUtils.isList((String)factType)) {
                    factMapping.setGenericTypes(factModelTree.getGenericTypeInfo(factName));
                }
                factMapping.addExpressionElement(factName, factType);
            }
            for (Map.Entry entry : factModelTree.getExpandableProperties().entrySet()) {
                String factType = (String)entry.getValue();
                FactModelTree nestedModelTree = hiddenValues.get(factType);
                if (previousSteps.isEmpty()) {
                    previousSteps.add(factModelTree.getFactName());
                }
                previousSteps.add((String)entry.getKey());
                this.addToScenario(factMappingExtractor, nestedModelTree, previousSteps, hiddenValues);
            }
        }
    }

    private static FactMappingType convert(FactModelTree.Type modelTreeType) {
        switch (modelTreeType) {
            case INPUT: {
                return FactMappingType.GIVEN;
            }
            case DECISION: {
                return FactMappingType.EXPECT;
            }
        }
        throw new IllegalArgumentException("Impossible to map");
    }

    private static class FactMappingExtractor {
        private final FactIdentifier factIdentifier;
        private final int row;
        private final AtomicInteger id;
        private final FactMappingType type;
        private final SimulationDescriptor simulationDescriptor;
        private final Scenario scenario;

        public FactMappingExtractor(FactIdentifier factIdentifier, int row, AtomicInteger id, FactMappingType type, SimulationDescriptor simulationDescriptor, Scenario scenario) {
            this.factIdentifier = factIdentifier;
            this.row = row;
            this.id = id;
            this.type = type;
            this.simulationDescriptor = simulationDescriptor;
            this.scenario = scenario;
        }

        public FactMapping getFactMapping(FactModelTree factModelTree, String propertyName, List<String> previousSteps, String factType) {
            String factAlias = previousSteps.size() > 0 ? previousSteps.get(0) : factModelTree.getFactName();
            ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)(this.row + "|" + this.id.getAndIncrement()), (FactMappingType)this.type);
            FactMapping factMapping = this.simulationDescriptor.addFactMapping(factAlias, this.factIdentifier, expressionIdentifier);
            ArrayList<String> localPreviousStep = new ArrayList<String>(previousSteps);
            localPreviousStep.add(propertyName);
            String expressionAlias = String.join((CharSequence)".", localPreviousStep.size() > 1 ? localPreviousStep.subList(1, localPreviousStep.size()) : localPreviousStep);
            factMapping.setExpressionAlias(expressionAlias);
            previousSteps.forEach(step -> factMapping.addExpressionElement(step, factType));
            if (previousSteps.isEmpty()) {
                factMapping.addExpressionElement(factModelTree.getFactName(), factType);
            }
            this.scenario.addMappingValue(this.factIdentifier, expressionIdentifier, null);
            return factMapping;
        }
    }
}

