/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.ImportExportServiceImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.importexport.ScenarioCsvImportExport;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportType;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ImportExportServiceImplTest {
    @Mock
    ScenarioCsvImportExport scenarioCsvImportExportMock;
    @Mock
    Simulation simulationMock;
    ImportExportServiceImpl importExportService;

    @Before
    public void setup() {
        this.importExportService = new ImportExportServiceImpl(){
            {
                this.scenarioCsvImportExport = ImportExportServiceImplTest.this.scenarioCsvImportExportMock;
            }
        };
    }

    @Test
    public void exportSimulation() throws IOException {
        this.importExportService.exportSimulation(ImportExportType.CSV, this.simulationMock);
        ((ScenarioCsvImportExport)Mockito.verify((Object)this.scenarioCsvImportExportMock, (VerificationMode)Mockito.times((int)1))).exportData((Simulation)Matchers.eq((Object)this.simulationMock));
        Mockito.when((Object)this.scenarioCsvImportExportMock.exportData((Simulation)Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException()});
        Assertions.assertThatThrownBy(() -> this.importExportService.exportSimulation(ImportExportType.CSV, this.simulationMock)).isInstanceOf(GenericPortableException.class);
    }

    @Test
    public void importSimulation() throws IOException {
        String raw = "";
        this.importExportService.importSimulation(ImportExportType.CSV, (Object)raw, this.simulationMock);
        ((ScenarioCsvImportExport)Mockito.verify((Object)this.scenarioCsvImportExportMock, (VerificationMode)Mockito.times((int)1))).importData((String)Matchers.eq((Object)raw), (Simulation)Matchers.eq((Object)this.simulationMock));
        Mockito.when((Object)this.scenarioCsvImportExportMock.importData(Matchers.anyString(), (Simulation)Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException()});
        Assertions.assertThatThrownBy(() -> this.importExportService.importSimulation(ImportExportType.CSV, (Object)raw, this.simulationMock)).isInstanceOf(GenericPortableException.class);
    }
}

