/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.backend.runner.AbstractScenarioRunner;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunner;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioLoader;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioRunnerServiceImpl;
import org.drools.workbench.screens.scenariosimulation.model.SimulationRunResult;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.service.BuildInfo;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioRunnerServiceImplTest {
    @Mock
    ScenarioLoader scenarioLoader;
    @Mock
    private AbstractScenarioRunner runnerMock;
    @Mock
    private KieModuleService moduleServiceMock;
    @Mock
    private BuildInfoService buildInfoServiceMock;
    @Mock
    private BuildInfo buildInfoMock;
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private ModuleClassLoaderHelper classLoaderHelperMock;
    @InjectMocks
    private ScenarioRunnerServiceImpl scenarioRunnerService = new ScenarioRunnerServiceImpl();

    @Before
    public void setup() {
        Mockito.when((Object)this.classLoaderHelperMock.getModuleClassLoader((KieModule)Matchers.any())).thenReturn((Object)ClassLoader.getSystemClassLoader());
    }

    @Test
    public void runAllTests() throws Exception {
        List testResultMessages = this.scenarioRunnerService.runAllTests("test", (Path)Mockito.mock(Path.class));
        Assert.assertNotNull((Object)testResultMessages);
    }

    @Test
    public void runTest() throws Exception {
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfoMock);
        Mockito.when((Object)this.buildInfoMock.getKieContainer()).thenReturn((Object)this.kieContainerMock);
        Simulation simulation = new Simulation();
        simulation.getSimulationDescriptor().setType(ScenarioSimulationModel.Type.RULE);
        SimulationRunResult test = this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), simulation.getSimulationDescriptor(), simulation.getScenarioWithIndex());
        Assert.assertNotNull((Object)test.getTestResultMessage());
        Assert.assertNotNull((Object)test.getScenarioWithIndex());
        Assert.assertNotNull((Object)test.getSimulationRunMetadata());
        Mockito.when((Object)this.runnerMock.getLastRunResultMetadata()).thenReturn(Optional.empty());
        this.scenarioRunnerService.setRunnerSupplier((kieContainer, simulationDescriptor, scenarios) -> this.runnerMock);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), simulation.getSimulationDescriptor(), simulation.getScenarioWithIndex())).isInstanceOf(IllegalStateException.class)).hasMessage("SimulationRunMetadata should be available after a run");
    }

    @Test
    public void runTestWithScenarios() throws Exception {
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfoMock);
        Mockito.when((Object)this.buildInfoMock.getKieContainer()).thenReturn((Object)this.kieContainerMock);
        SimulationDescriptor simulationDescriptor = new SimulationDescriptor();
        simulationDescriptor.setType(ScenarioSimulationModel.Type.RULE);
        ArrayList scenarios = new ArrayList();
        SimulationRunResult test = this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), simulationDescriptor, scenarios);
        Assert.assertNotNull((Object)test.getTestResultMessage());
        Assert.assertNotNull((Object)test.getScenarioWithIndex());
        Assert.assertNotNull((Object)test.getSimulationRunMetadata());
    }

    @Test
    public void runFailed() throws Exception {
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfoMock);
        Mockito.when((Object)this.buildInfoMock.getKieContainer()).thenReturn((Object)this.kieContainerMock);
        Simulation simulation = new Simulation();
        simulation.addScenario();
        Scenario scenario = simulation.getScenarioByIndex(0);
        scenario.setDescription("Test Scenario");
        final String errorMessage = "Test Error";
        this.scenarioRunnerService.setRunnerSupplier((kieContainer, simulationDescriptor, scenarios) -> new RuleScenarioRunner(kieContainer, simulationDescriptor, scenarios, ""){

            protected void internalRunScenario(ScenarioWithIndex scenarioWithIndex, ScenarioRunnerData scenarioRunnerData) {
                throw new ScenarioException(errorMessage);
            }
        });
        SimulationRunResult test = this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), simulation.getSimulationDescriptor(), simulation.getScenarioWithIndex());
        TestResultMessage value = test.getTestResultMessage();
        List failures = value.getFailures();
        Assert.assertEquals((long)1L, (long)failures.size());
        String testDescription = String.format("#%d: %s", 1, scenario.getDescription());
        String errorMessageFormatted = String.format("#%d: %s()", 1, errorMessage);
        Failure failure = (Failure)failures.get(0);
        Assert.assertEquals((Object)errorMessageFormatted, (Object)failure.getMessage());
        Assert.assertEquals((long)1L, (long)value.getRunCount());
        Assert.assertTrue((boolean)failure.getDisplayName().startsWith(testDescription));
    }

    @Test
    public void kieContainerTest() {
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfoMock);
        Mockito.when((Object)this.buildInfoMock.getKieContainer()).thenReturn(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scenarioRunnerService.getKieContainer((Path)Mockito.mock(Path.class))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Retrieving KieContainer has failed. Fix all compilation errors within the project and build the project again.");
    }
}

