/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioValidationService;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioValidationServiceTest {
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private Path pathMock;

    @Test
    public void validateSimulationStructure() {
        Simulation simulation = new Simulation();
        ScenarioValidationService scenarioValidationServiceSpy = (ScenarioValidationService)Mockito.spy((Object)new ScenarioValidationService(){

            protected List<FactMappingValidationError> validateDMN(Simulation simulation, KieContainer kieContainer) {
                return Collections.emptyList();
            }

            protected List<FactMappingValidationError> validateRULE(Simulation simulation, KieContainer kieContainer) {
                return Collections.emptyList();
            }

            protected KieContainer getKieContainer(Path path) {
                return ScenarioValidationServiceTest.this.kieContainerMock;
            }
        });
        simulation.getSimulationDescriptor().setType(ScenarioSimulationModel.Type.DMN);
        scenarioValidationServiceSpy.validateSimulationStructure(simulation, this.pathMock);
        ((ScenarioValidationService)Mockito.verify((Object)scenarioValidationServiceSpy, (VerificationMode)Mockito.never())).validateDMN((Simulation)Matchers.eq((Object)simulation), (KieContainer)Matchers.eq((Object)this.kieContainerMock));
        ((ScenarioValidationService)Mockito.verify((Object)scenarioValidationServiceSpy, (VerificationMode)Mockito.never())).validateRULE((Simulation)Matchers.eq((Object)simulation), (KieContainer)Matchers.eq((Object)this.kieContainerMock));
        Mockito.reset((Object[])new ScenarioValidationService[]{scenarioValidationServiceSpy});
        FactMapping sampleFactMapping = simulation.getSimulationDescriptor().addFactMapping(FactIdentifier.create((String)"sample", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"sample", (FactMappingType)FactMappingType.GIVEN));
        sampleFactMapping.addExpressionElement("sample", String.class.getCanonicalName());
        simulation.getSimulationDescriptor().setType(ScenarioSimulationModel.Type.DMN);
        scenarioValidationServiceSpy.validateSimulationStructure(simulation, this.pathMock);
        ((ScenarioValidationService)Mockito.verify((Object)scenarioValidationServiceSpy, (VerificationMode)Mockito.timeout((long)1L))).validateDMN((Simulation)Matchers.eq((Object)simulation), (KieContainer)Matchers.eq((Object)this.kieContainerMock));
        Mockito.reset((Object[])new ScenarioValidationService[]{scenarioValidationServiceSpy});
        simulation.getSimulationDescriptor().setType(ScenarioSimulationModel.Type.RULE);
        scenarioValidationServiceSpy.validateSimulationStructure(simulation, this.pathMock);
        ((ScenarioValidationService)Mockito.verify((Object)scenarioValidationServiceSpy, (VerificationMode)Mockito.timeout((long)1L))).validateRULE((Simulation)Matchers.eq((Object)simulation), (KieContainer)Matchers.eq((Object)this.kieContainerMock));
        simulation.getSimulationDescriptor().setType(null);
        Assertions.assertThatThrownBy(() -> scenarioValidationServiceSpy.validateSimulationStructure(simulation, this.pathMock)).isInstanceOf(IllegalArgumentException.class);
    }
}

