/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.downloadreport;

import java.io.IOException;
import java.util.Random;
import java.util.stream.IntStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.drools.scenariosimulation.api.model.AuditLog;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.workbench.screens.scenariosimulation.backend.server.downloadreport.ScenarioCsvDownloadReport;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioCsvDownloadReportTest {
    private static final String[] HEADER_COLUMNS = new String[]{"Scenario index", "Scenario", "Result index", "Result", "Level"};
    private final ScenarioCsvDownloadReport scenarioCsvDownloadReport = new ScenarioCsvDownloadReport();

    @Test
    public void getReport() throws IOException {
        AuditLog auditLog = new AuditLog();
        IntStream.range(0, 6).forEach(index -> auditLog.addAuditLogLine(this.getAuditLogLine()));
        String retrieved = this.scenarioCsvDownloadReport.getReport(auditLog);
        Assert.assertNotNull((Object)retrieved);
        String[] retrievedLines = retrieved.split("\r\n");
        this.commonCheckHeader(retrievedLines[0]);
        for (int i = 1; i < retrievedLines.length; ++i) {
            this.commonCheckRetrievedString(retrievedLines[i], (AuditLogLine)auditLog.getAuditLogLines().get(i - 1));
        }
    }

    @Test
    public void printAuditLogLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        AuditLogLine auditLogLine = this.getAuditLogLine();
        this.scenarioCsvDownloadReport.printAuditLogLine(auditLogLine, printer);
        String retrieved = stringBuilder.toString();
        this.commonCheckRetrievedString(retrieved, auditLogLine);
    }

    @Test
    public void generateHeader() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        this.scenarioCsvDownloadReport.generateHeader(printer);
        String retrieved = stringBuilder.toString();
        this.commonCheckHeader(retrieved);
    }

    private void commonCheckHeader(String toCheck) {
        Assert.assertNotNull((Object)toCheck);
        toCheck = toCheck.replace("\r\n", "");
        String[] retrievedColumns = toCheck.split(",");
        Assert.assertEquals((long)HEADER_COLUMNS.length, (long)retrievedColumns.length);
        for (int i = 0; i < retrievedColumns.length; ++i) {
            Assert.assertEquals((Object)HEADER_COLUMNS[i], (Object)retrievedColumns[i]);
        }
    }

    private void commonCheckRetrievedString(String toCheck, AuditLogLine auditLogLine) {
        Assert.assertNotNull((Object)toCheck);
        toCheck = toCheck.replace("\r\n", "");
        Assert.assertTrue((boolean)toCheck.contains(String.valueOf(auditLogLine.getScenarioIndex())));
        toCheck = toCheck.replaceFirst(String.valueOf(auditLogLine.getScenarioIndex()), "");
        String fieldToCheck = auditLogLine.getScenario();
        if (fieldToCheck.contains(",")) {
            fieldToCheck = "\"" + fieldToCheck + "\"";
        }
        Assert.assertTrue((boolean)toCheck.contains(fieldToCheck));
        toCheck = toCheck.replaceFirst(fieldToCheck, "");
        Assert.assertTrue((boolean)toCheck.contains(String.valueOf(auditLogLine.getExecutionIndex())));
        toCheck = toCheck.replaceFirst(String.valueOf(auditLogLine.getExecutionIndex()), "");
        fieldToCheck = auditLogLine.getMessage();
        if (fieldToCheck.contains(",")) {
            fieldToCheck = "\"" + fieldToCheck + "\"";
        }
        Assert.assertTrue((boolean)toCheck.contains(fieldToCheck));
        toCheck = toCheck.replaceFirst(fieldToCheck, "");
        fieldToCheck = auditLogLine.getLevel();
        if (fieldToCheck.contains(",")) {
            fieldToCheck = "\"" + fieldToCheck + "\"";
        }
        Assert.assertTrue((boolean)toCheck.contains(fieldToCheck));
        toCheck = toCheck.replaceFirst(fieldToCheck, "");
        Assert.assertEquals((Object)",,,,", (Object)toCheck);
    }

    private CSVPrinter getCSVPrinter(StringBuilder stringBuilder) throws IOException {
        return new CSVPrinter((Appendable)stringBuilder, CSVFormat.DEFAULT);
    }

    private AuditLogLine getAuditLogLine() {
        Random random = new Random();
        return new AuditLogLine(random.nextInt(3), "sce,nario-" + random.nextInt(5), random.nextInt(6), "Ru,le-" + random.nextInt(), "INFO");
    }
}

