/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.RULEScenarioValidation;
import org.drools.workbench.screens.scenariosimulation.backend.server.SampleBean;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RULEScenarioValidationTest {
    @Mock
    private KieContainer kieContainerMock;

    @Before
    public void init() {
        Mockito.when((Object)this.kieContainerMock.getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
        Mockito.when((Object)this.kieContainerMock.getClassLoader()).thenReturn((Object)Thread.currentThread().getContextClassLoader());
    }

    @Test
    public void validate() {
        RULEScenarioValidation validation = new RULEScenarioValidation();
        Simulation test0 = new Simulation();
        test0.getSimulationDescriptor().addFactMapping(FactIdentifier.DESCRIPTION, ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.OTHER));
        test0.getSimulationDescriptor().addFactMapping(FactIdentifier.EMPTY, ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        List errorsTest0 = validation.validate(test0, this.kieContainerMock);
        this.checkResult(errorsTest0, new String[0]);
        Simulation test1 = new Simulation();
        test1.getSimulationDescriptor().addFactMapping(FactIdentifier.create((String)"mySimpleType", (String)Integer.TYPE.getCanonicalName()), ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        List errorsTest1 = validation.validate(test1, this.kieContainerMock);
        this.checkResult(errorsTest1, new String[0]);
        FactMapping mySimpleType = test1.getSimulationDescriptor().addFactMapping(FactIdentifier.create((String)"mySimpleType", (String)"notValidClass"), ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        mySimpleType.addExpressionElement("notValidClass", "notValidClass");
        errorsTest1 = validation.validate(test1, this.kieContainerMock);
        this.checkResult(errorsTest1, "Impossible to load class notValidClass");
        Simulation test2 = new Simulation();
        FactIdentifier myFactIdentifier = FactIdentifier.create((String)"mySimpleType", (String)SampleBean.class.getCanonicalName());
        FactMapping nameFM = test2.getSimulationDescriptor().addFactMapping(myFactIdentifier, ExpressionIdentifier.create((String)"name", (FactMappingType)FactMappingType.GIVEN));
        nameFM.addExpressionElement("SampleBean", String.class.getCanonicalName());
        nameFM.addExpressionElement("name", String.class.getCanonicalName());
        FactMapping parentFM = test2.getSimulationDescriptor().addFactMapping(myFactIdentifier, ExpressionIdentifier.create((String)"parent", (FactMappingType)FactMappingType.EXPECT));
        parentFM.addExpressionElement("SampleBean", SampleBean.class.getCanonicalName());
        parentFM.addExpressionElement("parent", SampleBean.class.getCanonicalName());
        List errorsTest2 = validation.validate(test2, this.kieContainerMock);
        this.checkResult(errorsTest2, new String[0]);
        parentFM.addExpressionElement("notExisting", String.class.getCanonicalName());
        errorsTest2 = validation.validate(test2, this.kieContainerMock);
        this.checkResult(errorsTest2, "Impossible to find field with name 'notExisting' in class org.drools.workbench.screens.scenariosimulation.backend.server.SampleBean");
        FactMapping nameWrongTypeFM = test2.getSimulationDescriptor().addFactMapping(myFactIdentifier, ExpressionIdentifier.create((String)"parent2", (FactMappingType)FactMappingType.EXPECT));
        nameWrongTypeFM.addExpressionElement("SampleBean", Integer.class.getCanonicalName());
        nameWrongTypeFM.addExpressionElement("name", Integer.class.getCanonicalName());
        errorsTest2 = validation.validate(test2, this.kieContainerMock);
        this.checkResult(errorsTest2, "Impossible to find field with name 'notExisting' in class org.drools.workbench.screens.scenariosimulation.backend.server.SampleBean", "Field type has changed: old 'java.lang.Integer', current 'java.lang.String'");
        Simulation test3 = new Simulation();
        FactMapping topLevelListFM = test3.getSimulationDescriptor().addFactMapping(FactIdentifier.create((String)"mySimpleType", (String)List.class.getCanonicalName()), ExpressionIdentifier.create((String)"name", (FactMappingType)FactMappingType.GIVEN));
        topLevelListFM.addExpressionElement("List", List.class.getCanonicalName());
        topLevelListFM.setGenericTypes(Collections.singletonList(String.class.getCanonicalName()));
        FactMapping addressesFM = test3.getSimulationDescriptor().addFactMapping(myFactIdentifier, ExpressionIdentifier.create((String)"addresses", (FactMappingType)FactMappingType.EXPECT));
        addressesFM.addExpressionElement("SampleBean", List.class.getCanonicalName());
        addressesFM.addExpressionElement("addresses", List.class.getCanonicalName());
        addressesFM.setGenericTypes(Collections.singletonList(String.class.getCanonicalName()));
        List errorsTest3 = validation.validate(test3, this.kieContainerMock);
        this.checkResult(errorsTest3, new String[0]);
    }

    private void checkResult(List<FactMappingValidationError> validationErrors, String ... expectedErrors) {
        if (expectedErrors.length == 0) {
            Assert.assertEquals((long)0L, (long)validationErrors.size());
        }
        for (String expectedError : expectedErrors) {
            Assert.assertTrue((String)("Expected error: '" + expectedError + "' not found"), (boolean)validationErrors.stream().anyMatch(validationError -> Objects.equals(expectedError, validationError.getErrorMessage())));
        }
    }
}

