/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.enterprise.context.ApplicationScoped;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.util.DMNSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractKieContainerService;
import org.drools.workbench.screens.scenariosimulation.backend.server.exceptions.WrongDMNTypeException;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.DMNUtils;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.kie.dmn.feel.lang.Type;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.uberfire.backend.vfs.Path;

@Service
@ApplicationScoped
public class DMNTypeServiceImpl
extends AbstractKieContainerService
implements DMNTypeService {
    public FactModelTuple retrieveFactModelTuple(Path path, String dmnPath) {
        DMNType type;
        DMNModel dmnModel = this.getDMNModel(path, dmnPath);
        TreeMap<String, FactModelTree> visibleFacts = new TreeMap<String, FactModelTree>();
        TreeMap<String, FactModelTree> hiddenFacts = new TreeMap<String, FactModelTree>();
        ErrorHolder errorHolder = new ErrorHolder();
        for (InputDataNode input : dmnModel.getInputs()) {
            type = input.getType();
            this.checkTypeSupport(type, false, errorHolder, input.getName());
            try {
                visibleFacts.put(input.getName(), this.createTopLevelFactModelTree(input.getName(), type, hiddenFacts, FactModelTree.Type.INPUT));
            }
            catch (WrongDMNTypeException e) {
                throw ExceptionUtilities.handleException((Exception)e);
            }
        }
        for (DecisionNode decision : dmnModel.getDecisions()) {
            type = decision.getResultType();
            this.checkTypeSupport(type, false, errorHolder, decision.getName());
            try {
                visibleFacts.put(decision.getName(), this.createTopLevelFactModelTree(decision.getName(), type, hiddenFacts, FactModelTree.Type.DECISION));
            }
            catch (WrongDMNTypeException e) {
                throw ExceptionUtilities.handleException((Exception)e);
            }
        }
        FactModelTuple factModelTuple = new FactModelTuple(visibleFacts, hiddenFacts);
        errorHolder.getMultipleNestedCollection().forEach(arg_0 -> ((FactModelTuple)factModelTuple).addMultipleNestedCollectionError(arg_0));
        errorHolder.getMultipleNestedObject().forEach(arg_0 -> ((FactModelTuple)factModelTuple).addMultipleNestedObjectError(arg_0));
        return factModelTuple;
    }

    public void initializeNameAndNamespace(Simulation simulation, Path path, String dmnPath) {
        DMNModel dmnModel = this.getDMNModel(path, dmnPath);
        simulation.getSimulationDescriptor().setDmnName(dmnModel.getName());
        simulation.getSimulationDescriptor().setDmnNamespace(dmnModel.getNamespace());
    }

    public DMNModel getDMNModel(Path path, String dmnPath) {
        return DMNSimulationUtils.extractDMNModel((DMNRuntime)this.getDMNRuntime(path), (String)dmnPath);
    }

    public DMNRuntime getDMNRuntime(Path path) {
        KieContainer kieContainer = this.getKieContainer(path);
        return DMNSimulationUtils.extractDMNRuntime((KieContainer)kieContainer);
    }

    protected FactModelTree createTopLevelFactModelTree(String factName, DMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType) throws WrongDMNTypeException {
        return this.isToBeManagedAsCollection((BaseDMNTypeImpl)type) ? this.createFactModelTreeForCollection(new HashMap<String, List<String>>(), factName, type, hiddenFacts, fmType) : this.createFactModelTreeForNoCollection(new HashMap<String, List<String>>(), factName, factName, type.getName(), type, hiddenFacts, fmType);
    }

    protected FactModelTree createFactModelTreeForCollection(Map<String, List<String>> genericTypeInfoMap, String factName, DMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType) throws WrongDMNTypeException {
        if (!type.isCollection() && !this.isToBeManagedAsCollection((BaseDMNTypeImpl)type)) {
            throw new WrongDMNTypeException();
        }
        this.populateGeneric(genericTypeInfoMap, "value", type.getName());
        FactModelTree toReturn = this.createFactModelTreeForSimple(genericTypeInfoMap, factName, List.class.getCanonicalName(), fmType);
        FactModelTree genericFactModelTree = this.createFactModelTreeForGenericType(new HashMap<String, List<String>>(), type.getName(), type.getName(), type.getName(), type, hiddenFacts, fmType);
        hiddenFacts.put(type.getName(), genericFactModelTree);
        return toReturn;
    }

    protected FactModelTree createFactModelTreeForNoCollection(Map<String, List<String>> genericTypeInfoMap, String factName, String propertyName, String fullPropertyPath, DMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType) throws WrongDMNTypeException {
        if (type.isCollection() && this.isToBeManagedAsCollection((BaseDMNTypeImpl)type)) {
            throw new WrongDMNTypeException();
        }
        return this.isToBeManagedAsComposite((BaseDMNTypeImpl)type) ? this.createFactModelTreeForComposite(genericTypeInfoMap, propertyName, fullPropertyPath, type, hiddenFacts, fmType) : this.createFactModelTreeForSimple(genericTypeInfoMap, factName, type.getName(), fmType);
    }

    protected FactModelTree createFactModelTreeForGenericType(Map<String, List<String>> genericTypeInfoMap, String factName, String propertyName, String fullPropertyPath, DMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType) throws WrongDMNTypeException {
        return type.isComposite() ? this.createFactModelTreeForComposite(genericTypeInfoMap, propertyName, fullPropertyPath, type, hiddenFacts, fmType) : this.createFactModelTreeForSimple(genericTypeInfoMap, factName, type.getName(), fmType);
    }

    protected FactModelTree createFactModelTreeForSimple(Map<String, List<String>> genericTypeInfoMap, String factName, String propertyClass, FactModelTree.Type fmType) {
        HashMap simpleProperties = new HashMap();
        FactModelTree simpleFactModelTree = new FactModelTree(factName, "", simpleProperties, genericTypeInfoMap, fmType);
        simpleFactModelTree.addSimpleProperty("value", propertyClass);
        simpleFactModelTree.setSimple(true);
        return simpleFactModelTree;
    }

    protected FactModelTree createFactModelTreeForComposite(Map<String, List<String>> genericTypeInfoMap, String name, String fullPropertyPath, DMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType) throws WrongDMNTypeException {
        if (!type.isComposite() && !this.isToBeManagedAsComposite((BaseDMNTypeImpl)type)) {
            throw new WrongDMNTypeException();
        }
        HashMap simpleFields = new HashMap();
        FactModelTree toReturn = new FactModelTree(name, "", simpleFields, genericTypeInfoMap, fmType);
        for (Map.Entry entry : type.getFields().entrySet()) {
            FactModelTree fact;
            String expandablePropertyName = fullPropertyPath + "." + (String)entry.getKey();
            if (this.isToBeManagedAsCollection((BaseDMNTypeImpl)entry.getValue())) {
                fact = this.createFactModelTreeForCollection(new HashMap<String, List<String>>(), (String)entry.getKey(), (DMNType)entry.getValue(), hiddenFacts, FactModelTree.Type.UNDEFINED);
                simpleFields.put(entry.getKey(), List.class.getCanonicalName());
                genericTypeInfoMap.put((String)entry.getKey(), fact.getGenericTypeInfo("value"));
                continue;
            }
            if (((DMNType)entry.getValue()).isComposite()) {
                fact = this.createFactModelTreeForNoCollection(genericTypeInfoMap, (String)entry.getKey(), "value", expandablePropertyName, (DMNType)entry.getValue(), hiddenFacts, FactModelTree.Type.UNDEFINED);
                hiddenFacts.put(((DMNType)entry.getValue()).getName(), fact);
                toReturn.addExpandableProperty((String)entry.getKey(), ((DMNType)entry.getValue()).getName());
                continue;
            }
            simpleFields.put(entry.getKey(), ((DMNType)entry.getValue()).getName());
        }
        return toReturn;
    }

    private boolean isToBeManagedAsCollection(BaseDMNTypeImpl type) {
        Type feelType;
        boolean toReturn = type.isCollection();
        if (toReturn && (feelType = DMNUtils.getRootType(type)) instanceof BuiltInType && feelType.equals(BuiltInType.UNKNOWN)) {
            toReturn = false;
        }
        return toReturn;
    }

    private boolean isToBeManagedAsComposite(BaseDMNTypeImpl type) {
        Type feelType;
        boolean toReturn = type.isComposite();
        if (toReturn && (feelType = DMNUtils.getRootType(type)) instanceof BuiltInType && feelType.equals(BuiltInType.CONTEXT)) {
            toReturn = false;
        }
        return toReturn;
    }

    private String populateGeneric(Map<String, List<String>> genericTypeInfoMap, String fullPropertyPath, String type) {
        String genericKey = fullPropertyPath;
        genericTypeInfoMap.put(fullPropertyPath, Collections.singletonList(type));
        return genericKey;
    }

    protected void checkTypeSupport(DMNType type, boolean alreadyInCollection, ErrorHolder errorHolder, String fullPropertyPath) {
        if (type.isComposite()) {
            for (Map.Entry entry : type.getFields().entrySet()) {
                String name = (String)entry.getKey();
                DMNType nestedType = (DMNType)entry.getValue();
                String nestedPath = fullPropertyPath + "." + name;
                if (alreadyInCollection && nestedType.isCollection()) {
                    errorHolder.getMultipleNestedCollection().add(nestedPath);
                }
                if (alreadyInCollection && nestedType.isComposite()) {
                    errorHolder.getMultipleNestedObject().add(nestedPath);
                }
                this.checkTypeSupport(nestedType, alreadyInCollection || nestedType.isCollection(), errorHolder, nestedPath);
            }
        }
    }

    static class ErrorHolder {
        Set<String> multipleNestedObject = new TreeSet<String>();
        Set<String> multipleNestedCollection = new TreeSet<String>();

        ErrorHolder() {
        }

        public Set<String> getMultipleNestedObject() {
            return this.multipleNestedObject;
        }

        public Set<String> getMultipleNestedCollection() {
            return this.multipleNestedCollection;
        }
    }
}

