/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.util;

import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.DMNSimulationSettingsCreationStrategy;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.RULESimulationSettingsCreationStrategy;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.ScenarioSimulationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioSimulationBuilderTest {
    private final String VALUE = "VALUE";
    @Mock
    private Simulation dmnSimulationMock;
    @Mock
    private Simulation ruleSimulationMock;
    @Mock
    private Background dmnBackgroundMock;
    @Mock
    private Background ruleBackgroundMock;
    @Mock
    private Settings dmnSettingsMock;
    @Mock
    private Settings ruleSettingsMock;
    @Mock
    private RULESimulationSettingsCreationStrategy ruleSimulationCreationStrategyMock;
    @Mock
    private DMNSimulationSettingsCreationStrategy dmnSimulationCreationStrategyMock;
    @Mock
    private Path contextMock;
    private ScenarioSimulationBuilder scenarioSimulationBuilder;

    @Before
    public void setup() throws Exception {
        this.scenarioSimulationBuilder = new ScenarioSimulationBuilder();
        this.scenarioSimulationBuilder.dmnSimulationCreationStrategy = this.dmnSimulationCreationStrategyMock;
        this.scenarioSimulationBuilder.ruleSimulationCreationStrategy = this.ruleSimulationCreationStrategyMock;
        ((RULESimulationSettingsCreationStrategy)Mockito.doReturn((Object)this.ruleBackgroundMock).when((Object)this.ruleSimulationCreationStrategyMock)).createBackground((Path)Matchers.eq((Object)this.contextMock), (String)Matchers.eq((Object)"VALUE"));
        ((DMNSimulationSettingsCreationStrategy)Mockito.doReturn((Object)this.dmnBackgroundMock).when((Object)this.dmnSimulationCreationStrategyMock)).createBackground((Path)Matchers.eq((Object)this.contextMock), (String)Matchers.eq((Object)"VALUE"));
        ((RULESimulationSettingsCreationStrategy)Mockito.doReturn((Object)this.ruleSimulationMock).when((Object)this.ruleSimulationCreationStrategyMock)).createSimulation((Path)Matchers.eq((Object)this.contextMock), (String)Matchers.eq((Object)"VALUE"));
        ((DMNSimulationSettingsCreationStrategy)Mockito.doReturn((Object)this.dmnSimulationMock).when((Object)this.dmnSimulationCreationStrategyMock)).createSimulation((Path)Matchers.eq((Object)this.contextMock), (String)Matchers.eq((Object)"VALUE"));
        ((RULESimulationSettingsCreationStrategy)Mockito.doReturn((Object)this.ruleSettingsMock).when((Object)this.ruleSimulationCreationStrategyMock)).createSettings((Path)Matchers.eq((Object)this.contextMock), (String)Matchers.eq((Object)"VALUE"));
        ((DMNSimulationSettingsCreationStrategy)Mockito.doReturn((Object)this.dmnSettingsMock).when((Object)this.dmnSimulationCreationStrategyMock)).createSettings((Path)Matchers.eq((Object)this.contextMock), (String)Matchers.eq((Object)"VALUE"));
    }

    @Test
    public void createSimulation() throws Exception {
        Simulation simulationRetrieved = this.scenarioSimulationBuilder.createSimulation(this.contextMock, ScenarioSimulationModel.Type.RULE, "VALUE");
        Assert.assertNotNull((Object)simulationRetrieved);
        Assert.assertEquals((Object)this.ruleSimulationMock, (Object)simulationRetrieved);
        simulationRetrieved = this.scenarioSimulationBuilder.createSimulation(this.contextMock, ScenarioSimulationModel.Type.DMN, "VALUE");
        Assert.assertNotNull((Object)simulationRetrieved);
        Assert.assertEquals((Object)this.dmnSimulationMock, (Object)simulationRetrieved);
    }

    @Test
    public void createBackground() throws Exception {
        Background backgroundRetrieved = this.scenarioSimulationBuilder.createBackground(this.contextMock, ScenarioSimulationModel.Type.RULE, "VALUE");
        Assert.assertNotNull((Object)backgroundRetrieved);
        Assert.assertEquals((Object)this.ruleBackgroundMock, (Object)backgroundRetrieved);
        backgroundRetrieved = this.scenarioSimulationBuilder.createBackground(this.contextMock, ScenarioSimulationModel.Type.DMN, "VALUE");
        Assert.assertNotNull((Object)backgroundRetrieved);
        Assert.assertEquals((Object)this.dmnBackgroundMock, (Object)backgroundRetrieved);
    }

    @Test
    public void createSettings() throws Exception {
        Settings settingsRetrieved = this.scenarioSimulationBuilder.createSettings(this.contextMock, ScenarioSimulationModel.Type.RULE, "VALUE");
        Assert.assertNotNull((Object)settingsRetrieved);
        Assert.assertEquals((Object)this.ruleSettingsMock, (Object)settingsRetrieved);
        settingsRetrieved = this.scenarioSimulationBuilder.createSettings(this.contextMock, ScenarioSimulationModel.Type.DMN, "VALUE");
        Assert.assertNotNull((Object)settingsRetrieved);
        Assert.assertEquals((Object)this.dmnSettingsMock, (Object)settingsRetrieved);
    }
}

