/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.AbstractScesimModel;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.ImportExportServiceImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.importexport.ScenarioCsvImportExport;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportType;
import org.guvnor.common.services.shared.exceptions.GenericPortableException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ImportExportServiceImplTest {
    @Mock
    private ScenarioCsvImportExport scenarioCsvImportExportMock;
    @Mock
    private Simulation simulationMock;
    private ImportExportServiceImpl importExportService;

    @Before
    public void setup() {
        this.importExportService = new ImportExportServiceImpl(){
            {
                this.scenarioCsvImportExport = ImportExportServiceImplTest.this.scenarioCsvImportExportMock;
            }
        };
    }

    @Test
    public void exportScesimModel() throws IOException {
        this.importExportService.exportScesimModel(ImportExportType.CSV, (AbstractScesimModel)this.simulationMock);
        ((ScenarioCsvImportExport)Mockito.verify((Object)this.scenarioCsvImportExportMock, (VerificationMode)Mockito.times((int)1))).exportData((AbstractScesimModel)Matchers.eq((Object)this.simulationMock));
        Mockito.when((Object)this.scenarioCsvImportExportMock.exportData((AbstractScesimModel)Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException()});
        Assertions.assertThatThrownBy(() -> this.importExportService.exportScesimModel(ImportExportType.CSV, (AbstractScesimModel)this.simulationMock)).isInstanceOf(GenericPortableException.class);
    }

    @Test
    public void importScesimModel() throws IOException {
        String raw = "";
        this.importExportService.importScesimModel(ImportExportType.CSV, (Object)raw, (AbstractScesimModel)this.simulationMock);
        ((ScenarioCsvImportExport)Mockito.verify((Object)this.scenarioCsvImportExportMock, (VerificationMode)Mockito.times((int)1))).importData((String)Matchers.eq((Object)raw), (AbstractScesimModel)Matchers.eq((Object)this.simulationMock));
        Mockito.when((Object)this.scenarioCsvImportExportMock.importData(Matchers.anyString(), (AbstractScesimModel)Matchers.any())).thenThrow(new Throwable[]{new IllegalStateException()});
        Assertions.assertThatThrownBy(() -> this.importExportService.importScesimModel(ImportExportType.CSV, (Object)raw, (AbstractScesimModel)this.simulationMock)).isInstanceOf(GenericPortableException.class);
    }
}

