/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractDMNTest;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.DMNSimulationSettingsCreationStrategy;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNSimulationSettingsCreationStrategyTest
extends AbstractDMNTest {
    private DMNSimulationSettingsCreationStrategy dmnSimulationCreationStrategy;
    @Mock
    protected DMNTypeService dmnTypeServiceMock;

    @Override
    @Before
    public void init() {
        super.init();
        this.dmnSimulationCreationStrategy = (DMNSimulationSettingsCreationStrategy)Mockito.spy((Object)new DMNSimulationSettingsCreationStrategy(){
            {
                this.dmnTypeService = DMNSimulationSettingsCreationStrategyTest.this.dmnTypeServiceMock;
            }
        });
    }

    @Test
    public void createSimulation() throws Exception {
        FactModelTuple factModelTuple = this.getFactModelTuple();
        Path pathMock = (Path)Mockito.mock(Path.class);
        String dmnFilePath = "test";
        ((DMNSimulationSettingsCreationStrategy)Mockito.doReturn((Object)factModelTuple).when((Object)this.dmnSimulationCreationStrategy)).getFactModelTuple((Path)Matchers.any(), (String)Matchers.any());
        Simulation retrieved = this.dmnSimulationCreationStrategy.createSimulation(pathMock, "test");
        Assert.assertNotNull((Object)retrieved);
        ((DMNTypeService)Mockito.verify((Object)this.dmnTypeServiceMock, (VerificationMode)Mockito.never())).initializeNameAndNamespace((Settings)Matchers.any(Settings.class), (Path)Matchers.eq((Object)pathMock), (String)Matchers.eq((Object)"test"));
    }

    @Test
    public void createBackground() throws Exception {
        FactModelTuple factModelTuple = this.getFactModelTuple();
        Path pathMock = (Path)Mockito.mock(Path.class);
        String dmnFilePath = "test";
        ((DMNSimulationSettingsCreationStrategy)Mockito.doReturn((Object)factModelTuple).when((Object)this.dmnSimulationCreationStrategy)).getFactModelTuple((Path)Matchers.any(), (String)Matchers.any());
        Background retrieved = this.dmnSimulationCreationStrategy.createBackground(pathMock, "test");
        Assert.assertNotNull((Object)retrieved);
        ((DMNTypeService)Mockito.verify((Object)this.dmnTypeServiceMock, (VerificationMode)Mockito.never())).initializeNameAndNamespace((Settings)Matchers.any(Settings.class), (Path)Matchers.eq((Object)pathMock), (String)Matchers.eq((Object)"test"));
        Assert.assertFalse((boolean)retrieved.getScesimModelDescriptor().getUnmodifiableFactMappings().stream().anyMatch(elem -> FactMappingType.OTHER.equals((Object)elem.getExpressionIdentifier().getType())));
        Assert.assertTrue((boolean)retrieved.getScesimModelDescriptor().getUnmodifiableFactMappings().stream().allMatch(elem -> FactMappingType.GIVEN.equals((Object)elem.getExpressionIdentifier().getType())));
    }

    @Test
    public void createSettings() throws Exception {
        String dmnFilePath = "test";
        Path pathMock = (Path)Mockito.mock(Path.class);
        Settings retrieved = this.dmnSimulationCreationStrategy.createSettings(pathMock, "test");
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)ScenarioSimulationModel.Type.DMN, (Object)retrieved.getType());
        Assert.assertEquals((Object)"test", (Object)retrieved.getDmnFilePath());
    }

    @Test
    public void createSimulationCornerCases() throws Exception {
        this.verifySimulationCreated(false, false);
        this.verifySimulationCreated(true, false);
        this.verifySimulationCreated(false, true);
    }

    @Test
    public void addToScenarioRecursive() {
        FactMapping factMappingMock = (FactMapping)Mockito.mock(FactMapping.class);
        DMNSimulationSettingsCreationStrategy.FactMappingExtractor factMappingExtractorMock = (DMNSimulationSettingsCreationStrategy.FactMappingExtractor)Mockito.mock(DMNSimulationSettingsCreationStrategy.FactMappingExtractor.class);
        Mockito.when((Object)factMappingExtractorMock.getFactMapping((FactModelTree)Matchers.any(), Matchers.anyString(), (List)Matchers.any(), Matchers.anyString())).thenReturn((Object)factMappingMock);
        HashMap<String, FactModelTree> hiddenFacts = new HashMap<String, FactModelTree>();
        FactModelTree factModelTree = new FactModelTree("myFact", "", new HashMap(), Collections.emptyMap());
        factModelTree.addExpandableProperty("recursiveProperty", "recursive");
        String propertyType = String.class.getCanonicalName();
        String propertyName = "simpleProperty";
        factModelTree.addSimpleProperty(propertyName, propertyType);
        hiddenFacts.put("recursive", factModelTree);
        this.dmnSimulationCreationStrategy.addFactMapping(factMappingExtractorMock, factModelTree, new ArrayList(), hiddenFacts);
        ((DMNSimulationSettingsCreationStrategy.FactMappingExtractor)Mockito.verify((Object)factMappingExtractorMock, (VerificationMode)Mockito.times((int)1))).getFactMapping((FactModelTree)Matchers.eq((Object)factModelTree), (String)Matchers.eq((Object)propertyName), (List)Matchers.eq(Arrays.asList("myFact", "recursiveProperty")), (String)Matchers.eq((Object)propertyType));
        ((DMNSimulationSettingsCreationStrategy.FactMappingExtractor)Mockito.verify((Object)factMappingExtractorMock, (VerificationMode)Mockito.times((int)2))).getFactMapping((FactModelTree)Matchers.any(), (String)Matchers.any(), (List)Matchers.any(), (String)Matchers.any());
    }

    @Test
    public void addEmptyColumnIfNeeded() {
        Simulation simulation = new Simulation();
        ScenarioWithIndex scenarioWithIndex = new ScenarioWithIndex(1, (Scenario)simulation.addData());
        ExpressionIdentifier givenExpressionIdentifier = ExpressionIdentifier.create((String)"given1", (FactMappingType)FactMappingType.GIVEN);
        ScesimModelDescriptor simulationDescriptor = simulation.getScesimModelDescriptor();
        simulationDescriptor.addFactMapping(FactIdentifier.EMPTY, givenExpressionIdentifier);
        this.dmnSimulationCreationStrategy.addEmptyColumnsIfNeeded(simulation, scenarioWithIndex);
        Assert.assertEquals((long)2L, (long)simulationDescriptor.getFactMappings().size());
        Assert.assertTrue((boolean)simulationDescriptor.getFactMappings().stream().anyMatch(elem -> FactMappingType.EXPECT.equals((Object)elem.getExpressionIdentifier().getType())));
        simulation = new Simulation();
        scenarioWithIndex = new ScenarioWithIndex(1, (Scenario)simulation.addData());
        ExpressionIdentifier expectExpressionIdentifier = ExpressionIdentifier.create((String)"expect1", (FactMappingType)FactMappingType.EXPECT);
        simulationDescriptor = simulation.getScesimModelDescriptor();
        simulationDescriptor.addFactMapping(FactIdentifier.EMPTY, expectExpressionIdentifier);
        this.dmnSimulationCreationStrategy.addEmptyColumnsIfNeeded(simulation, scenarioWithIndex);
        Assert.assertEquals((long)2L, (long)simulationDescriptor.getFactMappings().size());
        Assert.assertTrue((boolean)simulationDescriptor.getFactMappings().stream().anyMatch(elem -> FactMappingType.GIVEN.equals((Object)elem.getExpressionIdentifier().getType())));
    }

    @Test
    public void findNewIndexOfGroup() {
        ScesimModelDescriptor simulationDescriptorGiven = new ScesimModelDescriptor();
        ExpressionIdentifier givenExpressionIdentifier = ExpressionIdentifier.create((String)"given1", (FactMappingType)FactMappingType.GIVEN);
        simulationDescriptorGiven.addFactMapping(FactIdentifier.EMPTY, givenExpressionIdentifier);
        Assert.assertEquals((long)1L, (long)this.dmnSimulationCreationStrategy.findNewIndexOfGroup(simulationDescriptorGiven, FactMappingType.GIVEN));
        Assert.assertEquals((long)1L, (long)this.dmnSimulationCreationStrategy.findNewIndexOfGroup(simulationDescriptorGiven, FactMappingType.EXPECT));
        ScesimModelDescriptor simulationDescriptorExpect = new ScesimModelDescriptor();
        ExpressionIdentifier expectExpressionIdentifier = ExpressionIdentifier.create((String)"expect1", (FactMappingType)FactMappingType.EXPECT);
        simulationDescriptorExpect.addFactMapping(FactIdentifier.EMPTY, expectExpressionIdentifier);
        Assert.assertEquals((long)0L, (long)this.dmnSimulationCreationStrategy.findNewIndexOfGroup(simulationDescriptorExpect, FactMappingType.GIVEN));
        Assert.assertEquals((long)1L, (long)this.dmnSimulationCreationStrategy.findNewIndexOfGroup(simulationDescriptorExpect, FactMappingType.EXPECT));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.dmnSimulationCreationStrategy.findNewIndexOfGroup(new ScesimModelDescriptor(), FactMappingType.OTHER)).isInstanceOf(IllegalArgumentException.class)).hasMessage("This method can be invoked only with GIVEN or EXPECT as FactMappingType");
    }

    private void verifySimulationCreated(boolean hasInput, boolean hasOutput) throws Exception {
        Path pathMock = (Path)Mockito.mock(Path.class);
        String dmnFilePath = "test";
        FactModelTuple factModelTuple = this.getFactModelTuple(hasInput, hasOutput);
        ((DMNSimulationSettingsCreationStrategy)Mockito.doReturn((Object)factModelTuple).when((Object)this.dmnSimulationCreationStrategy)).getFactModelTuple((Path)Matchers.any(), (String)Matchers.any());
        Simulation simulation = this.dmnSimulationCreationStrategy.createSimulation(pathMock, "test");
        Assert.assertNotNull((Object)simulation);
        List factMappings = simulation.getScesimModelDescriptor().getFactMappings();
        if (hasInput) {
            Assert.assertTrue((boolean)factMappings.stream().anyMatch(elem -> FactMappingType.GIVEN.equals((Object)elem.getExpressionIdentifier().getType())));
        } else {
            Assert.assertEquals((long)1L, (long)factMappings.stream().filter(elem -> FactMappingType.GIVEN.equals((Object)elem.getExpressionIdentifier().getType())).count());
        }
        if (hasOutput) {
            Assert.assertTrue((boolean)factMappings.stream().anyMatch(elem -> FactMappingType.EXPECT.equals((Object)elem.getExpressionIdentifier().getType())));
        } else {
            Assert.assertEquals((long)1L, (long)factMappings.stream().filter(elem -> FactMappingType.EXPECT.equals((Object)elem.getExpressionIdentifier().getType())).count());
        }
    }

    private FactModelTuple getFactModelTuple() throws IOException {
        return this.getFactModelTuple(true, true);
    }

    private FactModelTuple getFactModelTuple(boolean hasInput, boolean hasOutput) throws IOException {
        DMNType type;
        TreeMap<String, FactModelTree> visibleFacts = new TreeMap<String, FactModelTree>();
        TreeMap<String, FactModelTree> hiddenFacts = new TreeMap<String, FactModelTree>();
        if (hasInput) {
            for (InputDataNode input : this.dmnModelLocal.getInputs()) {
                type = input.getType();
                visibleFacts.put(input.getName(), this.createFactModelTree(input.getName(), input.getName(), type, hiddenFacts, FactModelTree.Type.INPUT));
            }
        }
        if (hasOutput) {
            for (DecisionNode decision : this.dmnModelLocal.getDecisions()) {
                type = decision.getResultType();
                visibleFacts.put(decision.getName(), this.createFactModelTree(decision.getName(), decision.getName(), type, hiddenFacts, FactModelTree.Type.DECISION));
            }
        }
        return new FactModelTuple(visibleFacts, hiddenFacts);
    }

    private FactModelTree createFactModelTree(String name, String path, DMNType type, SortedMap<String, FactModelTree> hiddenFacts, FactModelTree.Type fmType) {
        HashMap<String, String> simpleFields = new HashMap<String, String>();
        if (!type.isComposite()) {
            simpleFields.put("value", type.getName());
            FactModelTree simpleFactModelTree = new FactModelTree(name, "", simpleFields, new HashMap(), fmType);
            simpleFactModelTree.setSimple(true);
            return simpleFactModelTree;
        }
        FactModelTree factModelTree = new FactModelTree(name, "", simpleFields, new HashMap(), fmType);
        for (Map.Entry entry : type.getFields().entrySet()) {
            if (!((DMNType)entry.getValue()).isComposite()) {
                simpleFields.put((String)entry.getKey(), ((DMNType)entry.getValue()).getName());
                continue;
            }
            String expandableId = path + "." + (String)entry.getKey();
            factModelTree.addExpandableProperty((String)entry.getKey(), expandableId);
            hiddenFacts.put(expandableId, this.createFactModelTree((String)entry.getKey(), expandableId, (DMNType)entry.getValue(), hiddenFacts, FactModelTree.Type.UNDEFINED));
        }
        return factModelTree;
    }
}

