/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.util;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.shared.test.Failure;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunListener;
import org.uberfire.backend.vfs.Path;

public class JunitRunnerHelper {
    public static Result runWithJunit(final Path path, Runner runner, List<Failure> failures, final List<Failure> failureDetails) {
        JUnitCore jUnitCore = new JUnitCore();
        jUnitCore.addListener(new RunListener(){

            public void testAssumptionFailure(org.junit.runner.notification.Failure failure) {
                failureDetails.add(JunitRunnerHelper.failureToFailure(path, failure));
            }
        });
        Result result = jUnitCore.run(runner);
        failures.addAll(JunitRunnerHelper.failuresToFailures(path, result.getFailures()));
        return result;
    }

    static List<Failure> failuresToFailures(Path path, List<org.junit.runner.notification.Failure> failures) {
        ArrayList<Failure> result = new ArrayList<Failure>();
        for (org.junit.runner.notification.Failure failure : failures) {
            result.add(JunitRunnerHelper.failureToFailure(path, failure));
        }
        return result;
    }

    static Failure failureToFailure(Path path, org.junit.runner.notification.Failure failure) {
        return new Failure(JunitRunnerHelper.getScenarioName(failure), failure.getMessage(), path);
    }

    static String getScenarioName(org.junit.runner.notification.Failure failure) {
        return failure.getDescription().getDisplayName();
    }
}

