/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.backend.server.DMNScenarioValidation;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.core.impl.BaseDMNTypeImpl;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNScenarioValidationTest {
    @Mock
    private DMNModel dmnModelMock;
    private Map<String, DecisionNode> mapOfMockDecisions = new HashMap<String, DecisionNode>();
    private Settings settingsLocal;

    @Before
    public void init() {
        this.settingsLocal = new Settings();
        this.settingsLocal.setType(ScenarioSimulationModel.Type.DMN);
        Mockito.when((Object)this.dmnModelMock.getDecisionByName(Matchers.anyString())).thenAnswer(invocation -> this.mapOfMockDecisions.get(invocation.getArguments()[0]));
    }

    @After
    public void end() {
        this.mapOfMockDecisions.clear();
    }

    @Test
    public void validate() {
        DMNScenarioValidation validationSpy = (DMNScenarioValidation)Mockito.spy((Object)new DMNScenarioValidation(){

            protected DMNModel getDMNModel(KieContainer kieContainer, String dmnPath) {
                return DMNScenarioValidationTest.this.dmnModelMock;
            }
        });
        Simulation test0 = new Simulation();
        test0.getScesimModelDescriptor().addFactMapping(FactIdentifier.DESCRIPTION, ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.OTHER));
        test0.getScesimModelDescriptor().addFactMapping(FactIdentifier.EMPTY, ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        List errorsTest0 = validationSpy.validate(test0, this.settingsLocal, null);
        this.checkResult(errorsTest0, new String[0]);
        Simulation test1 = new Simulation();
        test1.getScesimModelDescriptor().addFactMapping(FactIdentifier.create((String)"mySimpleType", (String)"tMYSIMPLETYPE"), ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        this.createDMNType("mySimpleType", "mySimpleType", new String[0]);
        List errorsTest1 = validationSpy.validate(test1, this.settingsLocal, null);
        this.checkResult(errorsTest1, new String[0]);
        Simulation test2 = new Simulation();
        FactIdentifier myComplexFactIdentifier = FactIdentifier.create((String)"myComplexType", (String)"tMYCOMPLEXTYPE");
        FactMapping nameFM = test2.getScesimModelDescriptor().addFactMapping(myComplexFactIdentifier, ExpressionIdentifier.create((String)"name", (FactMappingType)FactMappingType.GIVEN));
        nameFM.addExpressionElement("tMYCOMPLEXTYPE", "tMYCOMPLEXTYPE");
        nameFM.addExpressionElement("name", "tNAME");
        this.createDMNType("myComplexType", "myComplexType", "name");
        FactMapping parentFM = test2.getScesimModelDescriptor().addFactMapping(myComplexFactIdentifier, ExpressionIdentifier.create((String)"parent", (FactMappingType)FactMappingType.EXPECT));
        parentFM.addExpressionElement("tMYCOMPLEXTYPE", "tMYCOMPLEXTYPE");
        parentFM.addExpressionElement("parent", "tPARENT");
        this.createDMNType("myComplexType", "myComplexType", "parent");
        FactMapping quantityFM = test2.getScesimModelDescriptor().addFactMapping(myComplexFactIdentifier, ExpressionIdentifier.create((String)"quantity", (FactMappingType)FactMappingType.GIVEN));
        quantityFM.addExpressionElement("tMYCOMPLEXTYPE", "tMYCOMPLEXTYPE");
        quantityFM.addExpressionElement("quantity", "number");
        this.createDMNTypeWithBaseType("myComplexType", "myComplexType", "quantity");
        List errorsTest2 = validationSpy.validate(test2, this.settingsLocal, null);
        this.checkResult(errorsTest2, new String[0]);
        parentFM.addExpressionElement("notExisting", "notExisting");
        errorsTest2 = validationSpy.validate(test2, this.settingsLocal, null);
        this.checkResult(errorsTest2, "Impossible to find field 'notExisting' in type 'tPARENT'");
        FactMapping nameWrongTypeFM = test2.getScesimModelDescriptor().addFactMapping(myComplexFactIdentifier, ExpressionIdentifier.create((String)"parent2", (FactMappingType)FactMappingType.EXPECT));
        nameWrongTypeFM.addExpressionElement("tMYCOMPLEXTYPE", "tMYCOMPLEXTYPE");
        nameWrongTypeFM.addExpressionElement("name", Integer.class.getCanonicalName());
        errorsTest2 = validationSpy.validate(test2, this.settingsLocal, null);
        this.checkResult(errorsTest2, "Impossible to find field 'notExisting' in type 'tPARENT'", "Field type has changed: old 'java.lang.Integer', current 'tNAME'");
        Simulation test3 = new Simulation();
        FactMapping topLevelListFM = test3.getScesimModelDescriptor().addFactMapping(FactIdentifier.create((String)"myList", (String)List.class.getCanonicalName()), ExpressionIdentifier.create((String)"name", (FactMappingType)FactMappingType.GIVEN));
        topLevelListFM.addExpressionElement("tPERSON", List.class.getCanonicalName());
        topLevelListFM.setGenericTypes(Collections.singletonList("tPERSON"));
        this.createDMNType("myList", "person", new String[0]);
        Mockito.when((Object)this.mapOfMockDecisions.get("myList").getResultType().isCollection()).thenReturn((Object)true);
        FactMapping addressesFM = test3.getScesimModelDescriptor().addFactMapping(FactIdentifier.create((String)"myComplexObject", (String)"tMYCOMPLEXOBJECT"), ExpressionIdentifier.create((String)"addresses", (FactMappingType)FactMappingType.EXPECT));
        addressesFM.addExpressionElement("tMYCOMPLEXOBJECT", "tMYCOMPLEXOBJECT");
        addressesFM.addExpressionElement("addresses", List.class.getCanonicalName());
        addressesFM.setGenericTypes(Collections.singletonList("tADDRESSES"));
        this.createDMNType("myComplexObject", "myComplexObject", "addresses");
        Mockito.when((Object)((DMNType)this.mapOfMockDecisions.get("myComplexObject").getResultType().getFields().get("addresses")).isCollection()).thenReturn((Object)true);
        List errorsTest3 = validationSpy.validate(test3, this.settingsLocal, null);
        this.checkResult(errorsTest3, new String[0]);
        Simulation test4 = new Simulation();
        FactMapping factMappingNodeRemoved = test4.getScesimModelDescriptor().addFactMapping(FactIdentifier.create((String)"mySimpleType", (String)"tMYSIMPLETYPE"), ExpressionIdentifier.create((String)"value", (FactMappingType)FactMappingType.GIVEN));
        factMappingNodeRemoved.addExpressionElement("tMYSIMPLETYPE", "tMYSIMPLETYPE");
        Mockito.when((Object)this.dmnModelMock.getDecisionByName(Matchers.anyString())).thenReturn(null);
        List errorsTest4 = validationSpy.validate(test4, this.settingsLocal, null);
        this.checkResult(errorsTest4, "Node type has changed: old 'tMYSIMPLETYPE', current 'node not found'");
    }

    private void checkResult(List<FactMappingValidationError> validationErrors, String ... expectedErrors) {
        if (expectedErrors.length == 0) {
            Assert.assertEquals((long)0L, (long)validationErrors.size());
        }
        for (String expectedError : expectedErrors) {
            Assert.assertTrue((String)("Expected error: '" + expectedError + "' not found"), (boolean)validationErrors.stream().anyMatch(validationError -> Objects.equals(expectedError, validationError.getErrorMessage())));
        }
    }

    private void createDMNType(String decisionName, String rootType, String ... steps) {
        DecisionNode decisionNodeMock = this.getOrCreateDecisionNode(decisionName, rootType);
        DMNType currentType = decisionNodeMock.getResultType();
        for (String step : steps) {
            currentType = this.addStep(currentType, step);
        }
        this.mapOfMockDecisions.put(decisionName, decisionNodeMock);
    }

    private void createDMNTypeWithBaseType(String decisionName, String rootType, String step) {
        DecisionNode decisionNodeMock = this.getOrCreateDecisionNode(decisionName, rootType);
        DMNType currentType = decisionNodeMock.getResultType();
        currentType = this.addStep(currentType, step);
        Mockito.when((Object)currentType.getName()).thenReturn((Object)step);
        DMNType numberType = this.initDMNType("number");
        Mockito.when((Object)numberType.getName()).thenReturn((Object)"number");
        Mockito.when((Object)currentType.getBaseType()).thenReturn((Object)numberType);
        this.mapOfMockDecisions.put(decisionName, decisionNodeMock);
    }

    private DecisionNode getOrCreateDecisionNode(String decisionName, String typeName) {
        DecisionNode decisionNodeMock;
        if (this.mapOfMockDecisions.containsKey(decisionName)) {
            decisionNodeMock = this.mapOfMockDecisions.get(decisionName);
            String decisionTypeName = decisionNodeMock.getResultType().getName();
            if (!Objects.equals(decisionTypeName, this.createDMNTypeName(typeName))) {
                throw new IllegalArgumentException("Decision with name " + decisionName + " already created of type " + decisionTypeName);
            }
        } else {
            decisionNodeMock = (DecisionNode)Mockito.mock(DecisionNode.class);
            this.mapOfMockDecisions.put(decisionName, decisionNodeMock);
            Mockito.when((Object)decisionNodeMock.getName()).thenReturn((Object)decisionName);
            DMNType initDMNType = this.initDMNType(typeName);
            Mockito.when((Object)decisionNodeMock.getResultType()).thenReturn((Object)initDMNType);
        }
        return decisionNodeMock;
    }

    private DMNType addStep(DMNType dmnTypeMock, String field) {
        DMNType nestedDmnTypeMock = this.initDMNType(field);
        dmnTypeMock.getFields().put(field, nestedDmnTypeMock);
        return nestedDmnTypeMock;
    }

    private DMNType initDMNType(String name) {
        DMNType dmnTypeMock = (DMNType)Mockito.mock(BaseDMNTypeImpl.class);
        Mockito.when((Object)dmnTypeMock.getFields()).thenReturn(new HashMap());
        String type = this.createDMNTypeName(name);
        Mockito.when((Object)dmnTypeMock.getName()).thenReturn((Object)type);
        Mockito.when((Object)dmnTypeMock.isComposite()).thenAnswer(invocation -> ((DMNType)invocation.getMock()).getFields().size() != 0);
        return dmnTypeMock;
    }

    private String createDMNTypeName(String name) {
        return "t" + name.toUpperCase();
    }
}

