/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.scenariosimulation.api.model.Background;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.runner.AbstractScenarioRunner;
import org.drools.scenariosimulation.backend.runner.RuleScenarioRunner;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioLoader;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioRunnerServiceImpl;
import org.drools.workbench.screens.scenariosimulation.model.SimulationRunResult;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.core.Builder;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoImpl;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioRunnerServiceImplTest {
    @Mock
    private ScenarioLoader scenarioLoaderMock;
    @Mock
    private AbstractScenarioRunner runnerMock;
    @Mock
    private KieModuleService moduleServiceMock;
    @Mock
    private BuildInfoService buildInfoServiceMock;
    @Mock
    private BuildInfoImpl buildInfoMock;
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private ModuleClassLoaderHelper classLoaderHelperMock;
    @Mock
    private Builder builder;
    @InjectMocks
    private ScenarioRunnerServiceImpl scenarioRunnerService = new ScenarioRunnerServiceImpl();
    private Settings settingsLocal;
    private Simulation simulationLocal;
    private Background backgroundLocal;

    @Before
    public void setup() {
        this.simulationLocal = new Simulation();
        this.backgroundLocal = new Background();
        this.settingsLocal = new Settings();
        this.settingsLocal.setType(ScenarioSimulationModel.Type.RULE);
        Mockito.when((Object)this.classLoaderHelperMock.getModuleClassLoader((KieModule)Matchers.any())).thenReturn((Object)ClassLoader.getSystemClassLoader());
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfoMock);
        Builder oldBuilder = (Builder)Mockito.mock(Builder.class);
        Mockito.when((Object)this.buildInfoMock.getBuilder()).thenReturn((Object)oldBuilder);
        Mockito.when((Object)oldBuilder.clone()).thenReturn((Object)this.builder);
        Mockito.when((Object)this.builder.getKieContainer()).thenReturn((Object)this.kieContainerMock);
    }

    @Test
    public void runAllTests() throws Exception {
        HashMap<Object, ScenarioSimulationModel> scenarioSimulationMap = new HashMap<Object, ScenarioSimulationModel>();
        scenarioSimulationMap.put(Mockito.mock(Path.class), this.makeScenarioSimulationModel(true));
        scenarioSimulationMap.put(Mockito.mock(Path.class), this.makeScenarioSimulationModel(false));
        Mockito.when((Object)this.scenarioLoaderMock.loadScenarios((Path)Matchers.any())).thenReturn(scenarioSimulationMap);
        List testResultMessages = this.scenarioRunnerService.runAllTests("test", (Path)Mockito.mock(Path.class));
        Assert.assertNotNull((Object)testResultMessages);
        Assert.assertEquals((long)1L, (long)testResultMessages.size());
    }

    @Test
    public void runTest() throws Exception {
        SimulationRunResult test = this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), this.simulationLocal.getScesimModelDescriptor(), this.simulationLocal.getScenarioWithIndex(), this.settingsLocal, this.backgroundLocal);
        Assert.assertNotNull((Object)test.getTestResultMessage());
        Assert.assertNotNull((Object)test.getScenarioWithIndex());
        Assert.assertNotNull((Object)test.getSimulationRunMetadata());
        Mockito.when((Object)this.runnerMock.getLastRunResultMetadata()).thenReturn(Optional.empty());
        this.scenarioRunnerService.setRunnerSupplier((kieContainer, scenarioRunnerDTO) -> this.runnerMock);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), this.simulationLocal.getScesimModelDescriptor(), this.simulationLocal.getScenarioWithIndex(), this.settingsLocal, this.backgroundLocal)).isInstanceOf(IllegalStateException.class)).hasMessage("SimulationRunMetadata should be available after a run");
    }

    @Test
    public void runTestWithScenarios() throws Exception {
        ScesimModelDescriptor simulationDescriptor = new ScesimModelDescriptor();
        ArrayList scenarios = new ArrayList();
        SimulationRunResult test = this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), simulationDescriptor, scenarios, this.settingsLocal, this.backgroundLocal);
        ((Builder)Mockito.verify((Object)this.builder)).build();
        Assert.assertNotNull((Object)test.getTestResultMessage());
        Assert.assertNotNull((Object)test.getScenarioWithIndex());
        Assert.assertNotNull((Object)test.getSimulationRunMetadata());
    }

    @Test
    public void runFailed() throws Exception {
        this.simulationLocal.addData();
        Scenario scenario = (Scenario)this.simulationLocal.getDataByIndex(0);
        scenario.setDescription("Test Scenario");
        final String errorMessage = "Test Error";
        this.scenarioRunnerService.setRunnerSupplier((kieContainer, scenarioRunnerDTO) -> new RuleScenarioRunner(kieContainer, scenarioRunnerDTO){

            protected void internalRunScenario(ScenarioWithIndex scenarioWithIndex, ScenarioRunnerData scenarioRunnerData, Settings settings, Background background) {
                throw new ScenarioException(errorMessage);
            }
        });
        SimulationRunResult test = this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), this.simulationLocal.getScesimModelDescriptor(), this.simulationLocal.getScenarioWithIndex(), this.settingsLocal, this.backgroundLocal);
        TestResultMessage value = test.getTestResultMessage();
        List failures = value.getFailures();
        Assert.assertEquals((long)1L, (long)failures.size());
        String testDescription = String.format("#%d: %s", 1, scenario.getDescription());
        String errorMessageFormatted = String.format("#%d: %s", 1, errorMessage);
        Failure failure = (Failure)failures.get(0);
        Assert.assertEquals((Object)errorMessageFormatted, (Object)failure.getMessage());
        Assert.assertEquals((long)1L, (long)value.getRunCount());
        Assert.assertTrue((boolean)failure.getDisplayName().startsWith(testDescription));
    }

    @Test
    public void manageFailureToLoadABuilder() {
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scenarioRunnerService.getKieContainer((Path)Mockito.mock(Path.class))).isInstanceOf(IllegalStateException.class)).hasMessage("Failed to clone Builder.");
    }

    @Test
    public void kieContainerTest() {
        Mockito.when((Object)this.builder.getKieContainer()).thenReturn(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scenarioRunnerService.getKieContainer((Path)Mockito.mock(Path.class))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Retrieving KieContainer has failed. Fix all compilation errors within the project and build the project again.");
    }

    private ScenarioSimulationModel makeScenarioSimulationModel(boolean toSkip) {
        Simulation simulation = new Simulation();
        Settings settings = new Settings();
        settings.setType(ScenarioSimulationModel.Type.RULE);
        settings.setSkipFromBuild(toSkip);
        ScenarioSimulationModel scenarioSimulationModel = new ScenarioSimulationModel();
        scenarioSimulationModel.setSimulation(simulation);
        scenarioSimulationModel.setSettings(settings);
        scenarioSimulationModel.setBackground(new Background());
        return scenarioSimulationModel;
    }
}

