/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.AbstractScesimData;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.ScesimDataWithIndex;
import org.drools.scenariosimulation.api.model.ScesimModelDescriptor;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.SimulationSettingsCreationStrategy;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class DMNSimulationSettingsCreationStrategy
implements SimulationSettingsCreationStrategy {
    @Inject
    protected DMNTypeService dmnTypeService;

    @Override
    public Simulation createSimulation(Path context, String dmnFilePath) {
        FactModelTuple factModelTuple = this.getFactModelTuple(context, dmnFilePath);
        Simulation toReturn = new Simulation();
        ScesimModelDescriptor simulationDescriptor = toReturn.getScesimModelDescriptor();
        simulationDescriptor.addFactMapping(FactIdentifier.INDEX.getName(), FactIdentifier.INDEX, ExpressionIdentifier.INDEX);
        simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION.getName(), FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        ScenarioWithIndex scenarioWithIndex = this.createScesimDataWithIndex(toReturn, simulationDescriptor, ScenarioWithIndex::new);
        AtomicInteger id = new AtomicInteger(1);
        Collection visibleFactTrees = factModelTuple.getVisibleFacts().values();
        SortedMap hiddenValues = factModelTuple.getHiddenFacts();
        visibleFactTrees.stream().sorted((a, b) -> {
            FactModelTree.Type aType = a.getType();
            FactModelTree.Type bType = b.getType();
            int inputFirstOrder = FactModelTree.Type.INPUT.equals((Object)aType) ? -1 : 1;
            return aType.equals((Object)bType) ? 0 : inputFirstOrder;
        }).forEach(factModelTree -> {
            FactIdentifier factIdentifier = new FactIdentifier(factModelTree.getFactName(), factModelTree.getFactName());
            FactMappingExtractor factMappingExtractor = new FactMappingExtractor(factIdentifier, scenarioWithIndex.getIndex(), id, DMNSimulationSettingsCreationStrategy.convert(factModelTree.getType()), simulationDescriptor, scenarioWithIndex.getScesimData());
            this.addFactMapping(factMappingExtractor, (FactModelTree)factModelTree, (List<String>)new ArrayList<String>(), hiddenValues);
        });
        this.addEmptyColumnsIfNeeded(toReturn, scenarioWithIndex);
        return toReturn;
    }

    @Override
    public Settings createSettings(Path context, String dmnFilePath) {
        Settings toReturn = new Settings();
        toReturn.setType(ScenarioSimulationModel.Type.DMN);
        toReturn.setDmnFilePath(dmnFilePath);
        this.dmnTypeService.initializeNameAndNamespace(toReturn, context, dmnFilePath);
        return toReturn;
    }

    protected void addEmptyColumnsIfNeeded(Simulation simulation, ScenarioWithIndex scenarioWithIndex) {
        boolean hasGiven = false;
        boolean hasExpect = false;
        ScesimModelDescriptor simulationDescriptor = simulation.getScesimModelDescriptor();
        for (FactMapping factMapping : simulationDescriptor.getFactMappings()) {
            FactMappingType factMappingType = factMapping.getExpressionIdentifier().getType();
            if (!hasGiven && FactMappingType.GIVEN.equals((Object)factMappingType)) {
                hasGiven = true;
                continue;
            }
            if (hasExpect || !FactMappingType.EXPECT.equals((Object)factMappingType)) continue;
            hasExpect = true;
        }
        if (!hasGiven) {
            this.createEmptyColumn(simulationDescriptor, (ScesimDataWithIndex)scenarioWithIndex, 1, FactMappingType.GIVEN, this.findNewIndexOfGroup(simulationDescriptor, FactMappingType.GIVEN));
        }
        if (!hasExpect) {
            this.createEmptyColumn(simulationDescriptor, (ScesimDataWithIndex)scenarioWithIndex, 2, FactMappingType.EXPECT, this.findNewIndexOfGroup(simulationDescriptor, FactMappingType.EXPECT));
        }
    }

    protected int findNewIndexOfGroup(ScesimModelDescriptor simulationDescriptor, FactMappingType factMappingType) {
        List factMappings = simulationDescriptor.getFactMappings();
        if (FactMappingType.GIVEN.equals((Object)factMappingType)) {
            for (int i = 0; i < factMappings.size(); ++i) {
                if (!FactMappingType.EXPECT.equals((Object)((FactMapping)factMappings.get(i)).getExpressionIdentifier().getType())) continue;
                return i;
            }
            return factMappings.size();
        }
        if (FactMappingType.EXPECT.equals((Object)factMappingType)) {
            return factMappings.size();
        }
        throw new IllegalArgumentException("This method can be invoked only with GIVEN or EXPECT as FactMappingType");
    }

    protected FactModelTuple getFactModelTuple(Path context, String dmnFilePath) {
        return this.dmnTypeService.retrieveFactModelTuple(context, dmnFilePath);
    }

    protected void addFactMapping(FactMappingExtractor factMappingExtractor, FactModelTree factModelTree, List<String> previousSteps, Map<String, FactModelTree> hiddenValues) {
        this.internalAddToScenario(factMappingExtractor, factModelTree, previousSteps, hiddenValues, new HashSet<String>());
    }

    protected void internalAddToScenario(FactMappingExtractor factMappingExtractor, FactModelTree factModelTree, List<String> readOnlyPreviousSteps, Map<String, FactModelTree> hiddenValues, Set<String> alreadyVisited) {
        ArrayList<String> previousSteps = new ArrayList<String>(readOnlyPreviousSteps);
        if (factModelTree.isSimple()) {
            FactModelTree.PropertyTypeName factType = (FactModelTree.PropertyTypeName)factModelTree.getSimpleProperties().get("value");
            factMappingExtractor.getFactMapping(factModelTree, "value", previousSteps, factType.getTypeName());
        } else {
            for (Map.Entry entry : factModelTree.getSimpleProperties().entrySet()) {
                String factName = (String)entry.getKey();
                String factTypeName = ((FactModelTree.PropertyTypeName)entry.getValue()).getTypeName();
                FactMapping factMapping = factMappingExtractor.getFactMapping(factModelTree, factName, previousSteps, factTypeName);
                if (ScenarioSimulationSharedUtils.isList((String)factTypeName)) {
                    factMapping.setGenericTypes(factModelTree.getGenericTypeInfo(factName));
                }
                factMapping.addExpressionElement(factName, factTypeName);
            }
            for (Map.Entry entry : factModelTree.getExpandableProperties().entrySet()) {
                String factType = (String)entry.getValue();
                FactModelTree nestedModelTree = hiddenValues.get(factType);
                if (previousSteps.isEmpty()) {
                    previousSteps.add(factModelTree.getFactName());
                }
                ArrayList<String> currentSteps = new ArrayList<String>(previousSteps);
                currentSteps.add((String)entry.getKey());
                if (alreadyVisited.contains(nestedModelTree.getFactName())) continue;
                alreadyVisited.add(factModelTree.getFactName());
                this.internalAddToScenario(factMappingExtractor, nestedModelTree, currentSteps, hiddenValues, alreadyVisited);
            }
        }
    }

    private static FactMappingType convert(FactModelTree.Type modelTreeType) {
        switch (modelTreeType) {
            case INPUT: {
                return FactMappingType.GIVEN;
            }
            case DECISION: {
                return FactMappingType.EXPECT;
            }
        }
        throw new IllegalArgumentException("Impossible to map");
    }

    public static class FactMappingExtractor {
        private final FactIdentifier factIdentifier;
        private final int row;
        private final AtomicInteger id;
        private final FactMappingType type;
        private final ScesimModelDescriptor simulationDescriptor;
        private final AbstractScesimData abstractScesimData;

        public FactMappingExtractor(FactIdentifier factIdentifier, int row, AtomicInteger id, FactMappingType type, ScesimModelDescriptor simulationDescriptor, AbstractScesimData abstractScesimData) {
            this.factIdentifier = factIdentifier;
            this.row = row;
            this.id = id;
            this.type = type;
            this.simulationDescriptor = simulationDescriptor;
            this.abstractScesimData = abstractScesimData;
        }

        public FactMapping getFactMapping(FactModelTree factModelTree, String propertyName, List<String> previousSteps, String factType) {
            String factAlias = !previousSteps.isEmpty() ? previousSteps.get(0) : factModelTree.getFactName();
            ExpressionIdentifier expressionIdentifier = ExpressionIdentifier.create((String)(this.row + "|" + this.id.getAndIncrement()), (FactMappingType)this.type);
            FactMapping factMapping = this.simulationDescriptor.addFactMapping(factAlias, this.factIdentifier, expressionIdentifier);
            ArrayList<String> localPreviousStep = new ArrayList<String>(previousSteps);
            localPreviousStep.add(propertyName);
            String expressionAlias = String.join((CharSequence)".", localPreviousStep.size() > 1 ? localPreviousStep.subList(1, localPreviousStep.size()) : localPreviousStep);
            factMapping.setExpressionAlias(expressionAlias);
            factMapping.setGenericTypes(factModelTree.getGenericTypeInfo("value"));
            previousSteps.forEach(step -> factMapping.addExpressionElement(step, factType));
            if (previousSteps.isEmpty()) {
                factMapping.addExpressionElement(factModelTree.getFactName(), factType);
            }
            this.abstractScesimData.addMappingValue(this.factIdentifier, expressionIdentifier, null);
            return factMapping;
        }
    }
}

