/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.scenariosimulation.api.model.Settings;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractDMNTest;
import org.drools.workbench.screens.scenariosimulation.backend.server.DMNTypeServiceImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.exceptions.WrongDMNTypeException;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.api.core.ast.DMNNode;
import org.kie.dmn.api.core.ast.DecisionNode;
import org.kie.dmn.api.core.ast.InputDataNode;
import org.kie.dmn.core.impl.CompositeTypeImpl;
import org.kie.dmn.core.impl.SimpleTypeImpl;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;

public class DMNTypeServiceImplTest
extends AbstractDMNTest {
    private DMNTypeServiceImpl dmnTypeServiceImpl;

    @Override
    @Before
    public void init() {
        super.init();
        this.dmnTypeServiceImpl = new DMNTypeServiceImpl(){

            public DMNModel getDMNModel(Path path, String stringPath) {
                return DMNTypeServiceImplTest.this.dmnModelLocal;
            }
        };
    }

    @Test
    public void initializeNameAndNamespace() {
        Settings settings = new Settings();
        this.dmnTypeServiceImpl.initializeNameAndNamespace(settings, (Path)Mockito.mock(Path.class), "");
        Assert.assertEquals((Object)"https://github.com/kiegroup/drools/kie-dmn/_CC8924B0-D729-4D70-9588-039B5824FFE9", (Object)settings.getDmnNamespace());
        Assert.assertEquals((Object)"dmn-list", (Object)settings.getDmnName());
    }

    @Test
    public void retrieveFactModelTupleDmnList() throws WrongDMNTypeException {
        this.setDmnModelLocal("dmn-list.dmn", "https://github.com/kiegroup/drools/kie-dmn/_CC8924B0-D729-4D70-9588-039B5824FFE9", "dmn-list");
        FactModelTuple factModelTuple = this.dmnTypeServiceImpl.retrieveFactModelTuple((Path)Mockito.mock(Path.class), null);
        int expectedVisibleFacts = this.dmnModelLocal.getInputs().size() + this.dmnModelLocal.getDecisions().size();
        Assert.assertEquals((long)expectedVisibleFacts, (long)factModelTuple.getVisibleFacts().size());
        this.dmnModelLocal.getInputs().forEach(inputDataNode -> this.verifyFactModelTree(factModelTuple, (DMNNode)inputDataNode, factModelTuple.getHiddenFacts()));
        this.dmnModelLocal.getDecisions().forEach(decisionNode -> this.verifyFactModelTree(factModelTuple, (DMNNode)decisionNode, factModelTuple.getHiddenFacts()));
    }

    @Test
    public void retrieveFactModelTupleDmnListComposite() throws WrongDMNTypeException {
        this.setDmnModelLocal("dmn-list-composite.dmn", "https://github.com/kiegroup/drools/kie-dmn/_25BF2679-3109-488F-9AD1-DDBCCEBBE5F1", "dmn-list-composite");
        FactModelTuple factModelTuple = this.dmnTypeServiceImpl.retrieveFactModelTuple((Path)Mockito.mock(Path.class), null);
        int expectedVisibleFacts = this.dmnModelLocal.getInputs().size() + this.dmnModelLocal.getDecisions().size();
        Assert.assertEquals((long)expectedVisibleFacts, (long)factModelTuple.getVisibleFacts().size());
        this.dmnModelLocal.getInputs().forEach(inputDataNode -> this.verifyFactModelTree(factModelTuple, (DMNNode)inputDataNode, factModelTuple.getHiddenFacts()));
        this.dmnModelLocal.getDecisions().forEach(decisionNode -> this.verifyFactModelTree(factModelTuple, (DMNNode)decisionNode, factModelTuple.getHiddenFacts()));
    }

    @Test
    public void createTopLevelFactModelTreeSimpleNoCollection() throws WrongDMNTypeException {
        SimpleTypeImpl simpleString = this.getSimpleNoCollection();
        FactModelTree retrieved = this.dmnTypeServiceImpl.createTopLevelFactModelTree("testPath", (DMNType)simpleString, new TreeMap(), FactModelTree.Type.INPUT);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"testPath", (Object)retrieved.getFactName());
        Assert.assertEquals((long)1L, (long)retrieved.getSimpleProperties().size());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("value"));
        Assert.assertEquals((Object)simpleString.getName(), (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getTypeName());
        Assert.assertFalse((boolean)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getBaseTypeName().isPresent());
        Assert.assertEquals((Object)simpleString.getName(), (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getPropertyTypeNameToVisualize());
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().isEmpty());
        Assert.assertTrue((boolean)retrieved.getGenericTypesMap().isEmpty());
    }

    @Test
    public void createTopLevelFactModelTreeSimpleCollection() throws WrongDMNTypeException {
        SimpleTypeImpl simpleCollectionString = this.getSimpleCollection();
        TreeMap hiddenFactSimpleCollection = new TreeMap();
        FactModelTree retrieved = this.dmnTypeServiceImpl.createTopLevelFactModelTree("testPath", (DMNType)simpleCollectionString, hiddenFactSimpleCollection, FactModelTree.Type.INPUT);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"testPath", (Object)retrieved.getFactName());
        Assert.assertEquals((long)1L, (long)retrieved.getSimpleProperties().size());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("value"));
        Assert.assertEquals((Object)"java.util.List", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getTypeName());
        Assert.assertFalse((boolean)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getBaseTypeName().isPresent());
        Assert.assertEquals((Object)"java.util.List", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getPropertyTypeNameToVisualize());
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().isEmpty());
        Assert.assertEquals((long)1L, (long)retrieved.getGenericTypesMap().size());
        Assert.assertTrue((boolean)retrieved.getGenericTypesMap().containsKey("value"));
        Assert.assertNotNull(retrieved.getGenericTypesMap().get("value"));
        Assert.assertEquals((long)1L, (long)((List)retrieved.getGenericTypesMap().get("value")).size());
        Assert.assertEquals((Object)simpleCollectionString.getName(), ((List)retrieved.getGenericTypesMap().get("value")).get(0));
    }

    @Test
    public void createTopLevelFactModelTreeCompositeNoCollectionBaseType() throws WrongDMNTypeException {
        CompositeTypeImpl composite = this.getSingleCompositeWithBaseTypeField();
        FactModelTree retrieved = this.dmnTypeServiceImpl.createTopLevelFactModelTree("testPath", (DMNType)composite, new TreeMap(), FactModelTree.Type.INPUT);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"testPath", (Object)retrieved.getFactName());
        Assert.assertEquals((long)2L, (long)retrieved.getSimpleProperties().size());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("name"));
        Assert.assertEquals((Object)"string", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("name")).getTypeName());
        Assert.assertFalse((boolean)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("name")).getBaseTypeName().isPresent());
        Assert.assertEquals((Object)"string", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("name")).getPropertyTypeNameToVisualize());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("gender"));
        Assert.assertEquals((Object)"simpleType", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("gender")).getTypeName());
        Assert.assertEquals((Object)"string", ((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("gender")).getBaseTypeName().get());
        Assert.assertEquals((Object)"string", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("gender")).getPropertyTypeNameToVisualize());
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().isEmpty());
        Assert.assertTrue((boolean)retrieved.getGenericTypesMap().isEmpty());
    }

    @Test
    public void createTopLevelFactModelTreeCompositeNoCollection() throws WrongDMNTypeException {
        CompositeTypeImpl compositePerson = this.getSingleCompositeWithSimpleCollection();
        FactModelTree retrieved = this.dmnTypeServiceImpl.createTopLevelFactModelTree("testPath", (DMNType)compositePerson, new TreeMap(), FactModelTree.Type.INPUT);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"testPath", (Object)retrieved.getFactName());
        Assert.assertEquals((long)2L, (long)retrieved.getSimpleProperties().size());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("friends"));
        Assert.assertEquals((Object)"java.util.List", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("friends")).getTypeName());
        Assert.assertFalse((boolean)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("friends")).getBaseTypeName().isPresent());
        Assert.assertEquals((Object)"java.util.List", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("friends")).getPropertyTypeNameToVisualize());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("name"));
        Assert.assertEquals((Object)"string", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("name")).getTypeName());
        Assert.assertFalse((boolean)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("name")).getBaseTypeName().isPresent());
        Assert.assertEquals((Object)"string", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("name")).getPropertyTypeNameToVisualize());
        Assert.assertEquals((long)1L, (long)retrieved.getGenericTypesMap().size());
        Assert.assertTrue((boolean)retrieved.getGenericTypesMap().containsKey("friends"));
        Assert.assertEquals((Object)((DMNType)compositePerson.getFields().get("friends")).getName(), ((List)retrieved.getGenericTypesMap().get("friends")).get(0));
        Assert.assertEquals((long)2L, (long)retrieved.getExpandableProperties().size());
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().containsKey("phoneNumbers"));
        Assert.assertEquals((Object)"tPhoneNumber", retrieved.getExpandableProperties().get("phoneNumbers"));
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().containsKey("details"));
        Assert.assertEquals((Object)"tDetails", retrieved.getExpandableProperties().get("details"));
    }

    @Test
    public void createTopLevelFactModelTreeCompositeCollection() throws WrongDMNTypeException {
        CompositeTypeImpl compositePerson = this.getCompositeCollection();
        TreeMap hiddenFactSimpleCollection = new TreeMap();
        FactModelTree retrieved = this.dmnTypeServiceImpl.createTopLevelFactModelTree("testPath", (DMNType)compositePerson, hiddenFactSimpleCollection, FactModelTree.Type.INPUT);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"testPath", (Object)retrieved.getFactName());
        Assert.assertEquals((long)1L, (long)retrieved.getSimpleProperties().size());
        Assert.assertTrue((boolean)retrieved.getSimpleProperties().containsKey("value"));
        Assert.assertEquals((Object)"java.util.List", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getTypeName());
        Assert.assertFalse((boolean)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getBaseTypeName().isPresent());
        Assert.assertEquals((Object)"java.util.List", (Object)((FactModelTree.PropertyTypeName)retrieved.getSimpleProperties().get("value")).getPropertyTypeNameToVisualize());
        Assert.assertTrue((boolean)retrieved.getExpandableProperties().isEmpty());
        Assert.assertEquals((long)1L, (long)retrieved.getGenericTypesMap().size());
        Assert.assertTrue((boolean)retrieved.getGenericTypesMap().containsKey("value"));
        Assert.assertNotNull(retrieved.getGenericTypesMap().get("value"));
        Assert.assertEquals((long)1L, (long)((List)retrieved.getGenericTypesMap().get("value")).size());
        Assert.assertEquals((Object)compositePerson.getName(), ((List)retrieved.getGenericTypesMap().get("value")).get(0));
    }

    @Test
    public void createTopLevelFactModelTreeRecursiveTypes() throws WrongDMNTypeException {
        TreeMap hiddenFacts = new TreeMap();
        FactModelTree person = this.dmnTypeServiceImpl.createTopLevelFactModelTree("person", (DMNType)this.getRecursivePersonComposite(false), hiddenFacts, FactModelTree.Type.DECISION);
        Assert.assertNotNull((Object)person);
        Assert.assertTrue((boolean)person.getExpandableProperties().containsKey("parent"));
        Assert.assertEquals((Object)"tPerson", person.getExpandableProperties().get("parent"));
        Assert.assertTrue((boolean)hiddenFacts.containsKey("tPerson"));
        hiddenFacts = new TreeMap();
        FactModelTree personCollection = this.dmnTypeServiceImpl.createTopLevelFactModelTree("person", (DMNType)this.getRecursivePersonComposite(true), hiddenFacts, FactModelTree.Type.DECISION);
        Assert.assertNotNull((Object)personCollection);
        Assert.assertTrue((boolean)personCollection.getGenericTypesMap().containsKey("value"));
        Assert.assertEquals((Object)"tPerson", personCollection.getGenericTypeInfo("value").get(0));
        Assert.assertTrue((boolean)hiddenFacts.containsKey("tPerson"));
        Assert.assertTrue((boolean)hiddenFacts.containsKey("tPersonList"));
    }

    @Test
    public void checkTypeSimpleTopLevelCollection() {
        SimpleTypeImpl topLevelCollection = this.getSimpleCollection();
        DMNTypeServiceImpl.ErrorHolder errorHolder = new DMNTypeServiceImpl.ErrorHolder();
        this.dmnTypeServiceImpl.checkTypeSupport((DMNType)topLevelCollection, errorHolder, "fieldName");
        Assert.assertEquals((long)0L, (long)errorHolder.getMultipleNestedObject().size());
        Assert.assertEquals((long)0L, (long)errorHolder.getMultipleNestedCollection().size());
    }

    @Test
    public void checkTypeSingleCompositeWithNestedCompositeCollection() {
        CompositeTypeImpl singleCompositeWithComplexCollection = this.getSingleCompositeWithNestedCollection();
        DMNTypeServiceImpl.ErrorHolder errorHolder = new DMNTypeServiceImpl.ErrorHolder();
        this.dmnTypeServiceImpl.checkTypeSupport((DMNType)singleCompositeWithComplexCollection, errorHolder, "fieldName");
        Assert.assertEquals((long)0L, (long)errorHolder.getMultipleNestedObject().size());
        Assert.assertEquals((long)1L, (long)errorHolder.getMultipleNestedCollection().size());
        Assert.assertTrue((boolean)errorHolder.getMultipleNestedCollection().contains("fieldName.phoneNumbers.numbers"));
    }

    @Test
    public void checkTypeSingleCompositeWithCollection() {
        CompositeTypeImpl person = new CompositeTypeImpl();
        CompositeTypeImpl complexNumbers = new CompositeTypeImpl(null, "tPhoneNumber", null, false);
        CompositeTypeImpl phoneNumberCompositeCollection = new CompositeTypeImpl(null, "tPhoneNumber", null, true);
        phoneNumberCompositeCollection.addField("complexNumbers", (DMNType)complexNumbers);
        person.addField("phoneNumbers", (DMNType)phoneNumberCompositeCollection);
        DMNTypeServiceImpl.ErrorHolder errorHolder = new DMNTypeServiceImpl.ErrorHolder();
        this.dmnTypeServiceImpl.checkTypeSupport((DMNType)person, errorHolder, "fieldName");
        Assert.assertEquals((long)1L, (long)errorHolder.getMultipleNestedObject().size());
        Assert.assertEquals((long)0L, (long)errorHolder.getMultipleNestedCollection().size());
        Assert.assertTrue((boolean)errorHolder.getMultipleNestedObject().contains("fieldName.phoneNumbers.complexNumbers"));
    }

    @Test
    public void checkTypeRecursive() {
        DMNTypeServiceImpl.ErrorHolder errorHolder = new DMNTypeServiceImpl.ErrorHolder();
        this.dmnTypeServiceImpl.checkTypeSupport((DMNType)this.getRecursivePersonComposite(false), errorHolder, "");
        Assert.assertEquals((long)1L, (long)errorHolder.getMultipleNestedCollection().size());
        Assert.assertEquals((long)2L, (long)errorHolder.getMultipleNestedObject().size());
        errorHolder = new DMNTypeServiceImpl.ErrorHolder();
        this.dmnTypeServiceImpl.checkTypeSupport((DMNType)this.getRecursivePersonComposite(true), errorHolder, "");
        Assert.assertEquals((long)2L, (long)errorHolder.getMultipleNestedCollection().size());
        Assert.assertEquals((long)2L, (long)errorHolder.getMultipleNestedObject().size());
    }

    private void verifyFactModelTree(FactModelTuple factModelTuple, DMNNode dmnNode, SortedMap<String, FactModelTree> hiddenFacts) {
        DMNType originalType;
        Assert.assertTrue((boolean)factModelTuple.getVisibleFacts().containsKey(dmnNode.getName()));
        FactModelTree mappedFactModelTree = (FactModelTree)factModelTuple.getVisibleFacts().get(dmnNode.getName());
        Assert.assertNotNull((Object)mappedFactModelTree);
        if (dmnNode instanceof InputDataNode) {
            originalType = ((InputDataNode)dmnNode).getType();
        } else if (dmnNode instanceof DecisionNode) {
            originalType = ((DecisionNode)dmnNode).getResultType();
        } else {
            Assert.fail((String)("Unrecognized node type " + dmnNode.getName() + " -> " + dmnNode.getClass().getCanonicalName()));
            return;
        }
        if (originalType.isCollection()) {
            this.verifyCollectionDMNType(mappedFactModelTree, originalType, hiddenFacts);
        } else if (originalType.isComposite()) {
            this.verifyCompositeDMNType(mappedFactModelTree, originalType, hiddenFacts);
        } else {
            this.verifySimpleDMNType(mappedFactModelTree, originalType);
        }
    }

    private void verifyCollectionDMNType(FactModelTree mappedFactModelTree, DMNType originalType, SortedMap<String, FactModelTree> hiddenFacts) {
        if (originalType.isComposite()) {
            if (!mappedFactModelTree.getGenericTypesMap().isEmpty()) {
                Assert.assertTrue((boolean)mappedFactModelTree.getGenericTypesMap().containsKey("value"));
                String genericType = (String)((List)mappedFactModelTree.getGenericTypesMap().get("value")).get(0);
                Assert.assertTrue((boolean)hiddenFacts.containsKey(genericType));
                FactModelTree genericFactModelTree = (FactModelTree)hiddenFacts.get(genericType);
                Assert.assertNotNull((Object)genericFactModelTree);
                this.verifyCompositeDMNType(genericFactModelTree, originalType, hiddenFacts);
            } else {
                this.verifyCompositeDMNType(mappedFactModelTree, originalType, hiddenFacts);
            }
        } else {
            this.verifySimpleDMNType(mappedFactModelTree, originalType);
        }
    }

    private void verifyCompositeDMNType(FactModelTree mappedFactModelTree, DMNType originalType, SortedMap<String, FactModelTree> hiddenFacts) {
        originalType.getFields().forEach((key, value) -> {
            if (value.isCollection()) {
                Assert.assertTrue((boolean)hiddenFacts.containsKey(key));
                this.verifyCollectionDMNType((FactModelTree)hiddenFacts.get(key), (DMNType)value, hiddenFacts);
            } else if (value.isComposite()) {
                Assert.assertTrue((boolean)mappedFactModelTree.getExpandableProperties().containsKey(key));
                Assert.assertTrue((boolean)hiddenFacts.containsKey(value.getName()));
                Assert.assertNotNull(hiddenFacts.get(value.getName()));
            } else {
                Assert.assertTrue((boolean)mappedFactModelTree.getSimpleProperties().containsKey(key));
            }
        });
    }

    private void verifySimpleDMNType(FactModelTree mappedFactModelTree, DMNType originalType) {
        Assert.assertTrue((boolean)mappedFactModelTree.getSimpleProperties().containsKey("value"));
        Assert.assertEquals((Object)originalType.getName(), (Object)((FactModelTree.PropertyTypeName)mappedFactModelTree.getSimpleProperties().get("value")).getTypeName());
        Assert.assertEquals((Object)originalType.getName(), (Object)((FactModelTree.PropertyTypeName)mappedFactModelTree.getSimpleProperties().get("value")).getPropertyTypeNameToVisualize());
        if (originalType.getBaseType() != null) {
            Assert.assertTrue((boolean)((FactModelTree.PropertyTypeName)mappedFactModelTree.getSimpleProperties().get("value")).getBaseTypeName().isPresent());
            Assert.assertEquals((Object)originalType.getBaseType().getName(), ((FactModelTree.PropertyTypeName)mappedFactModelTree.getSimpleProperties().get("value")).getBaseTypeName().get());
            Assert.assertEquals((Object)originalType.getBaseType().getName(), (Object)((FactModelTree.PropertyTypeName)mappedFactModelTree.getSimpleProperties().get("value")).getPropertyTypeNameToVisualize());
        }
    }
}

