/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.stream.IntStream;
import org.drools.scenariosimulation.api.model.AuditLog;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.workbench.screens.scenariosimulation.backend.server.RunnerReportServiceImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RunnerReportServiceImplTest {
    private RunnerReportServiceImpl runnerReportServiceImpl;

    @Before
    public void setup() {
        this.runnerReportServiceImpl = new RunnerReportServiceImpl();
    }

    @Test
    public void getReportRULE() {
        AuditLog auditLog = new AuditLog();
        IntStream.range(0, 6).forEach(index -> auditLog.addAuditLogLine(this.getAuditLogLine()));
        String report = this.runnerReportServiceImpl.getReport(this.getSimulationRunMetadata(auditLog), ScenarioSimulationModel.Type.RULE);
        Assert.assertNotNull((Object)report);
        Assert.assertFalse((boolean)report.isEmpty());
        String[] reportLine = report.split("\\r\\n");
        Assert.assertTrue((boolean)report.contains("RULE"));
        Assert.assertFalse((boolean)report.contains("DECISION"));
        Assert.assertEquals((long)(7 + auditLog.getAuditLogLines().size()), (long)reportLine.length);
        for (int i = 0; i < reportLine.length; ++i) {
            Assert.assertNotNull((Object)reportLine[i]);
        }
    }

    @Test
    public void getReportDMN() {
        AuditLog auditLog = new AuditLog();
        IntStream.range(0, 6).forEach(index -> auditLog.addAuditLogLine(this.getAuditLogLine()));
        String report = this.runnerReportServiceImpl.getReport(this.getSimulationRunMetadata(auditLog), ScenarioSimulationModel.Type.DMN);
        Assert.assertNotNull((Object)report);
        Assert.assertFalse((boolean)report.isEmpty());
        String[] reportLine = report.split("\\r\\n");
        Assert.assertTrue((boolean)report.contains("DECISION"));
        Assert.assertFalse((boolean)report.contains("RULE"));
        Assert.assertEquals((long)(7 + auditLog.getAuditLogLines().size()), (long)reportLine.length);
        for (int i = 0; i < reportLine.length; ++i) {
            Assert.assertNotNull((Object)reportLine[i]);
        }
    }

    private AuditLogLine getAuditLogLine() {
        Random random = new Random();
        String message = random.nextBoolean() ? "WARN: Error during evaluation" : null;
        return new AuditLogLine(random.nextInt(3), "sce,nario-" + random.nextInt(5), random.nextInt(6), "Ru,le-" + random.nextInt(), "INFO", message);
    }

    private SimulationRunMetadata getSimulationRunMetadata(AuditLog auditLog) {
        Random random = new Random();
        HashMap<String, Integer> rules = new HashMap<String, Integer>();
        rules.put("Rule,1", random.nextInt(7));
        return new SimulationRunMetadata(random.nextInt(10), random.nextInt(5), rules, Collections.emptyMap(), auditLog);
    }
}

