/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.downloadreport;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.IntStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.drools.scenariosimulation.api.model.AuditLog;
import org.drools.scenariosimulation.api.model.AuditLogLine;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.workbench.screens.scenariosimulation.backend.server.downloadreport.ScenarioCsvDownloadReport;
import org.junit.Assert;
import org.junit.Test;

public class ScenarioCsvDownloadReportTest {
    private final ScenarioCsvDownloadReport scenarioCsvDownloadReport = new ScenarioCsvDownloadReport();

    @Test
    public void getReport_RULE() {
        this.commonGetReport(ScenarioSimulationModel.Type.RULE, ScenarioCsvDownloadReport.RULE_OVERALL_STATS_HEADER, ScenarioCsvDownloadReport.RULE_COUNTER_HEADER, ScenarioCsvDownloadReport.RULE_AUDIT_HEADER);
    }

    @Test
    public void getReport_DMN() {
        this.commonGetReport(ScenarioSimulationModel.Type.DMN, ScenarioCsvDownloadReport.DMN_OVERALL_STATS_HEADER, ScenarioCsvDownloadReport.DMN_COUNTER_HEADER, ScenarioCsvDownloadReport.DMN_AUDIT_HEADER);
    }

    private void commonGetReport(ScenarioSimulationModel.Type type, String[] overallStats, String[] counterHeader, String[] auditHeader) {
        AuditLog auditLog = new AuditLog();
        IntStream.range(0, 6).forEach(index -> auditLog.addAuditLogLine(this.getAuditLogLine()));
        SimulationRunMetadata simulationRunMetadata = this.getSimulationRunMetadata(auditLog);
        String retrieved = this.scenarioCsvDownloadReport.getReport(simulationRunMetadata, type);
        Assert.assertNotNull((Object)retrieved);
        String[] retrievedLines = retrieved.split("\r\n");
        this.commonCheckHeader(overallStats, retrievedLines[0]);
        List<String> overallStatsData = Arrays.asList(String.valueOf(simulationRunMetadata.getAvailable()), String.valueOf(simulationRunMetadata.getExecuted()), String.valueOf(simulationRunMetadata.getCoveragePercentage()));
        this.commonCheckRetrievedString(retrievedLines[1], overallStatsData);
        Assert.assertTrue((boolean)retrievedLines[2].isEmpty());
        this.commonCheckHeader(counterHeader, retrievedLines[3]);
        Map.Entry entry = simulationRunMetadata.getOutputCounter().entrySet().iterator().next();
        List<String> rulesCounterData = Arrays.asList("\"" + (String)entry.getKey() + "\"", String.valueOf(entry.getValue()));
        this.commonCheckRetrievedString(retrievedLines[4], rulesCounterData);
        Assert.assertTrue((boolean)retrievedLines[5].isEmpty());
        this.commonCheckHeader(auditHeader, retrievedLines[6]);
        for (int i = 7; i < retrievedLines.length; ++i) {
            AuditLogLine auditLogLine = (AuditLogLine)auditLog.getAuditLogLines().get(i - 7);
            List<String> auditData = Arrays.asList(String.valueOf(auditLogLine.getScenarioIndex()), "\"" + auditLogLine.getScenario() + "\"", String.valueOf(auditLogLine.getExecutionIndex()), "\"" + auditLogLine.getDecisionOrRuleName() + "\"", auditLogLine.getResult(), auditLogLine.getMessage().orElse(""));
            this.commonCheckRetrievedString(retrievedLines[i], auditData);
        }
    }

    @Test
    public void generateOverallStatsHeaderRULE() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        this.scenarioCsvDownloadReport.generateOverallStatsHeader(printer, ScenarioSimulationModel.Type.RULE);
        String retrieved = stringBuilder.toString();
        this.commonCheckHeader(ScenarioCsvDownloadReport.RULE_OVERALL_STATS_HEADER, retrieved);
    }

    @Test
    public void generateOverallStatsHeaderDMN() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        this.scenarioCsvDownloadReport.generateOverallStatsHeader(printer, ScenarioSimulationModel.Type.DMN);
        String retrieved = stringBuilder.toString();
        this.commonCheckHeader(ScenarioCsvDownloadReport.DMN_OVERALL_STATS_HEADER, retrieved);
    }

    @Test
    public void printOverallStatsLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        AuditLog auditLog = new AuditLog();
        auditLog.addAuditLogLine(this.getAuditLogLine());
        SimulationRunMetadata simulationRunMetadata = this.getSimulationRunMetadata(auditLog);
        this.scenarioCsvDownloadReport.printOverallStatsLine(printer, simulationRunMetadata.getAvailable(), simulationRunMetadata.getExecuted(), simulationRunMetadata.getCoveragePercentage());
        String retrieved = stringBuilder.toString();
        List<String> data = Arrays.asList(String.valueOf(simulationRunMetadata.getAvailable()), String.valueOf(simulationRunMetadata.getExecuted()), String.valueOf(simulationRunMetadata.getCoveragePercentage()));
        this.commonCheckRetrievedString(retrieved, data);
    }

    @Test
    public void generateRulesCounterHeaderRULE() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        this.scenarioCsvDownloadReport.generateRulesCounterHeader(printer, ScenarioSimulationModel.Type.RULE);
        String retrieved = stringBuilder.toString();
        this.commonCheckHeader(ScenarioCsvDownloadReport.RULE_COUNTER_HEADER, retrieved);
    }

    @Test
    public void generateRulesCounterHeaderDMN() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        this.scenarioCsvDownloadReport.generateRulesCounterHeader(printer, ScenarioSimulationModel.Type.DMN);
        String retrieved = stringBuilder.toString();
        this.commonCheckHeader(ScenarioCsvDownloadReport.DMN_COUNTER_HEADER, retrieved);
    }

    @Test
    public void printRulesCounterLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        AuditLog auditLog = new AuditLog();
        auditLog.addAuditLogLine(this.getAuditLogLine());
        SimulationRunMetadata simulationRunMetadata = this.getSimulationRunMetadata(auditLog);
        Map.Entry entry = simulationRunMetadata.getOutputCounter().entrySet().iterator().next();
        this.scenarioCsvDownloadReport.printRulesCounterLine(printer, (String)entry.getKey(), ((Integer)entry.getValue()).intValue());
        String retrieved = stringBuilder.toString();
        List<String> data = Arrays.asList("\"" + (String)entry.getKey() + "\"", String.valueOf(entry.getValue()));
        this.commonCheckRetrievedString(retrieved, data);
    }

    @Test
    public void generateAuditLogHeaderRULE() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        this.scenarioCsvDownloadReport.generateAuditLogHeader(printer, ScenarioSimulationModel.Type.RULE);
        String retrieved = stringBuilder.toString();
        this.commonCheckHeader(ScenarioCsvDownloadReport.RULE_AUDIT_HEADER, retrieved);
    }

    @Test
    public void generateAuditLogHeaderDMN() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        this.scenarioCsvDownloadReport.generateAuditLogHeader(printer, ScenarioSimulationModel.Type.DMN);
        String retrieved = stringBuilder.toString();
        this.commonCheckHeader(ScenarioCsvDownloadReport.DMN_AUDIT_HEADER, retrieved);
    }

    @Test
    public void printAuditLogLine() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CSVPrinter printer = this.getCSVPrinter(stringBuilder);
        AuditLogLine auditLogLine = this.getAuditLogLine();
        this.scenarioCsvDownloadReport.printAuditLogLine(auditLogLine, printer);
        String retrieved = stringBuilder.toString();
        List<String> data = Arrays.asList(String.valueOf(auditLogLine.getScenarioIndex()), "\"" + auditLogLine.getScenario() + "\"", String.valueOf(auditLogLine.getExecutionIndex()), "\"" + auditLogLine.getDecisionOrRuleName() + "\"", auditLogLine.getResult(), auditLogLine.getMessage().orElse(""));
        this.commonCheckRetrievedString(retrieved, data);
    }

    private void commonCheckHeader(String[] columns, String toCheck) {
        Assert.assertNotNull((Object)toCheck);
        toCheck = toCheck.replace("\r\n", "");
        String[] retrievedColumns = toCheck.split(",");
        Assert.assertEquals((long)columns.length, (long)retrievedColumns.length);
        for (int i = 0; i < retrievedColumns.length; ++i) {
            Assert.assertEquals((Object)columns[i], (Object)retrievedColumns[i]);
        }
    }

    private void commonCheckRetrievedString(String toCheck, List<String> rowData) {
        Assert.assertNotNull((Object)toCheck);
        toCheck = toCheck.replace("\r\n", "");
        for (String data : rowData) {
            Assert.assertTrue((boolean)toCheck.contains(String.valueOf(data)));
            toCheck = toCheck.replaceFirst(String.valueOf(data), "");
        }
        Assert.assertEquals((long)(rowData.size() - 1), (long)toCheck.length());
        Assert.assertEquals((long)(rowData.size() - 1), (long)toCheck.chars().filter(ch -> ch == 44).count());
    }

    private CSVPrinter getCSVPrinter(StringBuilder stringBuilder) throws IOException {
        return new CSVPrinter((Appendable)stringBuilder, CSVFormat.DEFAULT.withNullString(""));
    }

    private AuditLogLine getAuditLogLine() {
        Random random = new Random();
        String message = random.nextBoolean() ? "WARN: Error during evaluation" : null;
        return new AuditLogLine(random.nextInt(3), "sce,nario-" + random.nextInt(5), random.nextInt(6), "Ru,le-" + random.nextInt(), "INFO", message);
    }

    private SimulationRunMetadata getSimulationRunMetadata(AuditLog auditLog) {
        Random random = new Random();
        HashMap<String, Integer> rules = new HashMap<String, Integer>();
        rules.put("Rule,1", random.nextInt(7));
        return new SimulationRunMetadata(random.nextInt(10), random.nextInt(5), rules, Collections.emptyMap(), auditLog);
    }
}

